/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.jaas.AbstractLoginModule;
import org.gatein.sso.agent.tomcat.ServletAccess;

public class FilterDisabledLoginModule
extends AbstractLoginModule {
    private static final Log log = ExoLogger.getLogger(FilterDisabledLoginModule.class);
    public static final String DISABLED_USER_NAME = "_disabledUserName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean login() throws LoginException {
        log.debug((Object)"In login of FilterDisabledLoginModule.");
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Username")};
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            if (username != null) {
                OrganizationService organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
                this.begin(organizationService);
                try {
                    UserHandler uHandler = organizationService.getUserHandler();
                    User user = uHandler.findUserByName(username, UserStatus.ANY);
                    if (user == null) {
                        log.debug("user {0} doesn't exists. FilterDisabledLoginModule will be ignored.", new Object[]{username});
                        return true;
                    }
                    if (user.isEnabled()) return true;
                    HttpServletRequest request = this.getCurrentHttpServletRequest();
                    if (request == null) throw new LoginException("Can't authenticate. user " + username + " is disabled");
                    request.setAttribute(DISABLED_USER_NAME, (Object)username);
                    throw new LoginException("Can't authenticate. user " + username + " is disabled");
                }
                finally {
                    this.end(organizationService);
                }
            } else {
                log.debug((Object)"No username has been committed. FilterDisabledLoginModule will be ignored.");
            }
            return true;
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
            throw new LoginException(e.getMessage());
        }
    }

    protected HttpServletRequest getCurrentHttpServletRequest() {
        return ServletAccess.getRequest();
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    protected Log getLogger() {
        return log;
    }

    private void begin(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            ComponentRequestLifecycle componentRequestLifecycle = (ComponentRequestLifecycle)orgService;
            RequestLifeCycle.begin((ComponentRequestLifecycle)componentRequestLifecycle);
        }
    }

    private void end(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

