/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profilelabel.storage;

import java.util.List;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ProfileLabelDAO;
import org.exoplatform.social.core.jpa.storage.entity.ProfileLabelEntity;
import org.exoplatform.social.core.model.ProfileLabel;

public class ProfileLabelStorage {
    private final ProfileLabelDAO labelDAO;

    public ProfileLabelStorage(ProfileLabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    public ProfileLabel findLabelByObjectTypeAndObjectIdAndLang(String objectType, String objectId, String language) {
        ProfileLabelEntity profileLabelEntity = this.labelDAO.findLabelByObjectTypeAndObjectIdAndLang(objectType, objectId, language);
        return this.convertFromEntity(profileLabelEntity);
    }

    public List<ProfileLabel> findLabelByObjectTypeAndObjectId(String objectType, String objectId) {
        List<ProfileLabelEntity> labelEntities = this.labelDAO.findLabelByObjectTypeAndObjectId(objectType, objectId);
        return labelEntities.stream().map(this::convertFromEntity).toList();
    }

    public ProfileLabel saveLabel(ProfileLabel profileLabel, boolean isNew) {
        ProfileLabelEntity profileLabelEntity = this.convertToEntity(profileLabel);
        if (isNew) {
            profileLabelEntity = (ProfileLabelEntity)this.labelDAO.create(profileLabelEntity);
            return this.convertFromEntity(profileLabelEntity);
        }
        profileLabelEntity = (ProfileLabelEntity)this.labelDAO.update(profileLabelEntity);
        return this.convertFromEntity(profileLabelEntity);
    }

    public void deleteLabel(Long id) {
        ProfileLabelEntity profileLabelEntity = (ProfileLabelEntity)this.labelDAO.find(id);
        this.labelDAO.delete(profileLabelEntity);
    }

    private ProfileLabelEntity convertToEntity(ProfileLabel profileLabel) {
        if (profileLabel == null) {
            return null;
        }
        ProfileLabelEntity profileLabelEntity = new ProfileLabelEntity();
        profileLabelEntity.setId(profileLabel.getId());
        profileLabelEntity.setObjectType(profileLabel.getObjectType());
        profileLabelEntity.setObjectId(profileLabel.getObjectId());
        profileLabelEntity.setLabel(profileLabel.getLabel());
        profileLabelEntity.setLanguage(profileLabel.getLanguage());
        return profileLabelEntity;
    }

    private ProfileLabel convertFromEntity(ProfileLabelEntity profileLabelEntity) {
        if (profileLabelEntity == null) {
            return null;
        }
        ProfileLabel profileLabel = new ProfileLabel();
        profileLabel.setId(profileLabelEntity.getId());
        profileLabel.setObjectType(profileLabelEntity.getObjectType());
        profileLabel.setObjectId(profileLabelEntity.getObjectId());
        profileLabel.setLabel(profileLabelEntity.getLabel());
        profileLabel.setLanguage(profileLabelEntity.getLanguage());
        return profileLabel;
    }
}

