/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.InitialProperties;
import org.exoplatform.services.rest.impl.DependencySupplier;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.uri.UriComponent;

public class ApplicationContextImpl
implements ApplicationContext {
    private static ThreadLocal<ApplicationContext> current = new ThreadLocal();
    private List<String> parameterValues = new ArrayList<String>();
    private List<Object> matchedResources = new ArrayList<Object>();
    private List<String> encodedMatchedURIs = new ArrayList<String>();
    private List<String> matchedURIs = new ArrayList<String>();
    private Map<String, Object> attributes;
    private Map<String, String> properties;
    protected ProviderBinder providers;
    protected GenericContainerRequest request;
    protected GenericContainerResponse response;
    private URI absolutePath;
    private String path;
    private String encodedPath;
    private MultivaluedMap<String, String> encodedPathParameters;
    private MultivaluedMap<String, String> pathParameters;
    private List<PathSegment> encodedPathSegments;
    private List<PathSegment> pathSegments;
    private MultivaluedMap<String, String> encodedQueryParameters;
    private MultivaluedMap<String, String> queryParameters;
    private DependencySupplier dependencySupplier;

    public static ApplicationContext getCurrent() {
        return current.get();
    }

    public static void setCurrent(ApplicationContext context) {
        current.set(context);
    }

    public ApplicationContextImpl(GenericContainerRequest request, GenericContainerResponse response, ProviderBinder providers, DependencySupplier dependencySupplier) {
        this.request = request;
        this.response = response;
        this.providers = providers;
        this.dependencySupplier = dependencySupplier;
    }

    public ApplicationContextImpl(GenericContainerRequest request, GenericContainerResponse response, ProviderBinder providers) {
        this(request, response, providers, new DependencySupplier());
    }

    @Override
    public void addMatchedResource(Object resource) {
        this.matchedResources.add(0, resource);
    }

    @Override
    public void addMatchedURI(String uri) {
        this.encodedMatchedURIs.add(0, uri);
        this.matchedURIs.add(0, UriComponent.decode(uri, 4));
    }

    public URI getAbsolutePath() {
        if (this.absolutePath != null) {
            return this.absolutePath;
        }
        this.absolutePath = this.getRequestUriBuilder().replaceQuery(null).fragment(null).build(new Object[0]);
        return this.absolutePath;
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.getAbsolutePath());
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes == null ? (this.attributes = new HashMap<String, Object>()) : this.attributes;
    }

    public URI getBaseUri() {
        return this.request.getBaseUri();
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.getBaseUri());
    }

    @Override
    public GenericContainerRequest getContainerRequest() {
        return this.request;
    }

    @Override
    public GenericContainerResponse getContainerResponse() {
        return this.response;
    }

    @Override
    public DependencySupplier getDependencySupplier() {
        return this.dependencySupplier;
    }

    public void setDependencySupplier(DependencySupplier dependencySupplier) {
        this.dependencySupplier = dependencySupplier;
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.request;
    }

    @Override
    public InitialProperties getInitialProperties() {
        return this;
    }

    public List<Object> getMatchedResources() {
        return this.matchedResources;
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        return decode ? this.matchedURIs : this.encodedMatchedURIs;
    }

    @Override
    public List<String> getParameterValues() {
        return this.parameterValues;
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        if (this.encodedPath == null) {
            this.encodedPath = this.getAbsolutePath().getRawPath().substring(this.getBaseUri().getRawPath().length());
        }
        if (decode) {
            if (this.path != null) {
                return this.path;
            }
            this.path = UriComponent.decode(this.encodedPath, 5);
            return this.path;
        }
        return this.encodedPath;
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (this.encodedPathParameters == null) {
            throw new IllegalStateException("Path template variables not initialized yet.");
        }
        if (decode) {
            if (this.pathParameters == null) {
                this.pathParameters = new MultivaluedMapImpl();
            }
            if (this.pathParameters.size() != this.encodedPathParameters.size()) {
                for (String key : this.encodedPathParameters.keySet()) {
                    if (this.pathParameters.containsKey((Object)key)) continue;
                    this.pathParameters.putSingle((Object)UriComponent.decode(key, 4), (Object)UriComponent.decode((String)this.encodedPathParameters.getFirst((Object)key), 5));
                }
            }
            return this.pathParameters;
        }
        return this.encodedPathParameters;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            return this.pathSegments != null ? this.pathSegments : (this.pathSegments = UriComponent.parsePathSegments(this.getPath(), true));
        }
        return this.encodedPathSegments != null ? this.encodedPathSegments : (this.encodedPathSegments = UriComponent.parsePathSegments(this.getPath(), false));
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties == null ? (this.properties = new HashMap<String, String>()) : this.properties;
    }

    @Override
    public String getProperty(String name) {
        return this.getProperties().get(name);
    }

    @Override
    public ProviderBinder getProviders() {
        return this.providers;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            return this.queryParameters != null ? this.queryParameters : (this.queryParameters = UriComponent.parseQueryString(this.getRequestUri().getRawQuery(), true));
        }
        return this.encodedQueryParameters != null ? this.encodedQueryParameters : (this.encodedQueryParameters = UriComponent.parseQueryString(this.getRequestUri().getRawQuery(), false));
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    public URI getRequestUri() {
        return this.request.getRequestUri();
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.request;
    }

    @Override
    public UriInfo getUriInfo() {
        return this;
    }

    @Override
    public void setParameterNames(List<String> parameterNames) {
        if (this.encodedPathParameters == null) {
            this.encodedPathParameters = new MultivaluedMapImpl();
        }
        for (int i = 0; i < parameterNames.size(); ++i) {
            this.encodedPathParameters.add((Object)parameterNames.get(i), (Object)this.parameterValues.get(i));
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.getProperties().put(name, value);
    }

    public void setProviders(ProviderBinder providers) {
        this.providers = providers;
    }
}

