/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.persistence.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.cfg.AvailableSettings;

public class EntityManagerService
implements ComponentRequestLifecycle {
    public static final String PERSISTENCE_UNIT_NAME = "exo-pu";
    private static final Log LOGGER = ExoLogger.getLogger(EntityManagerService.class);
    private static final String EXO_JPA_DATASOURCE_NAME = "exo.jpa.datasource.name";
    private static final String EXO_PREFIX_FOR_HIB_SETTINGS = "exo.jpa.";
    protected EntityManagerFactory entityManagerFactory;
    protected Properties properties;
    private ThreadLocal<EntityManager> instance = new ThreadLocal();

    public EntityManagerService() {
        this(null, null);
    }

    public EntityManagerService(EntityManagerFactory managerFactory, Properties props) {
        if (managerFactory != null && props != null) {
            this.entityManagerFactory = managerFactory;
            this.properties = props;
            return;
        }
        this.properties = new Properties();
        String datasourceName = PropertyManager.getProperty((String)EXO_JPA_DATASOURCE_NAME);
        if (StringUtils.isNotBlank((String)datasourceName)) {
            this.properties.put("javax.persistence.nonJtaDataSource", datasourceName);
            LOGGER.info("EntityManagerFactory [{}] - Creating with datasource {}.", new Object[]{this.getPersistenceUnitName(), datasourceName});
        } else {
            LOGGER.info("EntityManagerFactory [{}] - Creating with default datasource.", new Object[]{this.getPersistenceUnitName()});
        }
        for (String propertyName : this.getHibernateAvailableSettings()) {
            String propertyValue = PropertyManager.getProperty((String)(EXO_PREFIX_FOR_HIB_SETTINGS + propertyName));
            if (!StringUtils.isNotBlank((String)propertyValue)) continue;
            this.properties.put(propertyName, propertyValue);
            LOGGER.info("EntityManagerFactory [{}] - Setting [{}] to [{}]", new Object[]{this.getPersistenceUnitName(), propertyName, propertyValue});
        }
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)this.properties);
        LOGGER.info("EntityManagerFactory [{}] - Created.", new Object[]{this.getPersistenceUnitName()});
    }

    public String getDatasourceName() {
        return (String)this.properties.get("javax.persistence.nonJtaDataSource");
    }

    public void setDatasourceName(String datasourceName) {
        this.properties.put("javax.persistence.nonJtaDataSource", datasourceName);
    }

    private List<String> getHibernateAvailableSettings() {
        ArrayList<String> result = new ArrayList<String>();
        for (Field field : AvailableSettings.class.getDeclaredFields()) {
            try {
                result.add((String)field.get(null));
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)"Error while getting Hibernate available settings.", (Throwable)e);
            }
        }
        return result;
    }

    public EntityManager getEntityManager() {
        if (this.instance.get() == null) {
            return null;
        }
        return this.instance.get();
    }

    EntityManager createEntityManager() {
        EntityManager em = this.entityManagerFactory.createEntityManager();
        this.instance.set(em);
        return em;
    }

    public void startRequest(ExoContainer container) {
        if (this.instance.get() != null) {
            this.endRequest(container);
        }
        this.createEntityManager();
    }

    public void endRequest(ExoContainer container) {
        this.closeEntityManager();
    }

    public boolean isStarted(ExoContainer container) {
        return this.instance.get() != null && this.instance.get().getTransaction() != null;
    }

    public String getPersistenceUnitName() {
        return PERSISTENCE_UNIT_NAME;
    }

    void closeEntityManager() {
        EntityManager em = this.getEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            try {
                tx = em.getTransaction();
                if (tx.isActive()) {
                    if (tx.getRollbackOnly()) {
                        tx.rollback();
                    } else {
                        tx.commit();
                    }
                }
                this.instance.remove();
            }
            catch (Throwable throwable) {
                this.instance.remove();
                em.close();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ended a request lifecycle of {} component service", new Object[]{EntityManagerService.class.getName()});
                }
                throw throwable;
            }
            em.close();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ended a request lifecycle of {} component service", new Object[]{EntityManagerService.class.getName()});
            }
        }
    }
}

