/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.management;

import java.util.List;
import java.util.Locale;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.simple.SimpleURL;
import org.exoplatform.web.url.simple.SimpleURLContext;
import org.gatein.api.BasicPortalRequest;
import org.gatein.api.EntityAlreadyExistsException;
import org.gatein.api.EntityNotFoundException;
import org.gatein.api.Portal;
import org.gatein.api.PortalRequest;
import org.gatein.api.Util;
import org.gatein.api.common.Attributes;
import org.gatein.api.common.Pagination;
import org.gatein.api.common.URIResolver;
import org.gatein.api.management.NavigationManagementResource;
import org.gatein.api.management.PageManagementResource;
import org.gatein.api.management.Utils;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.security.Group;
import org.gatein.api.security.Permission;
import org.gatein.api.security.User;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteQuery;
import org.gatein.api.site.SiteType;
import org.gatein.management.api.ManagedUser;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.annotations.Managed;
import org.gatein.management.api.annotations.ManagedAfter;
import org.gatein.management.api.annotations.ManagedBefore;
import org.gatein.management.api.annotations.ManagedContext;
import org.gatein.management.api.annotations.ManagedOperation;
import org.gatein.management.api.annotations.ManagedRole;
import org.gatein.management.api.annotations.MappedAttribute;
import org.gatein.management.api.annotations.MappedPath;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.model.ModelList;
import org.gatein.management.api.model.ModelObject;
import org.gatein.management.api.model.ModelProvider;
import org.gatein.management.api.model.ModelReference;
import org.gatein.management.api.model.ModelString;
import org.gatein.management.api.model.ModelValue;
import org.gatein.management.api.operation.OperationContext;

@Managed(value="api", description="GateIn API Management Resource")
public class GateInApiManagementResource {
    private static final Log log = ExoLogger.getLogger((String)"org.gatein.api.management");
    private static final SiteQuery SITE_QUERY = new SiteQuery.Builder().withSiteTypes(SiteType.SITE, new SiteType[0]).build();
    private static final SiteQuery SPACE_QUERY = new SiteQuery.Builder().withSiteTypes(SiteType.SPACE, new SiteType[0]).build();
    private final Portal portal;
    @ManagedContext
    private final ModelProvider modelProvider;

    public GateInApiManagementResource(Portal portal) {
        this(portal, null);
    }

    GateInApiManagementResource(Portal portal, ModelProvider modelProvider) {
        this.portal = portal;
        this.modelProvider = modelProvider;
    }

    @ManagedBefore
    public void before(@ManagedContext OperationContext context) {
        PortalRequest portalRequest = PortalRequest.getInstance();
        if (portalRequest == null) {
            this.setCurrentPortalRequest(context);
        }
    }

    @ManagedAfter
    public void after() {
        if (PortalRequest.getInstance() instanceof BasicPortalRequest) {
            BasicPortalRequest.setInstance(null);
        }
    }

    @Managed(value="/sites")
    public ModelList getSites(@ManagedContext PathAddress address, @MappedAttribute(value="emptySites") String emptySites, @MappedAttribute(value="offset") String offset, @MappedAttribute(value="limit") String limit) {
        return this._getSites(SITE_QUERY, address, emptySites, offset, limit);
    }

    @Managed(value="/sites/{site-name}")
    public ModelObject getSite(@MappedPath(value="site-name") String siteName, @ManagedContext OperationContext context) {
        SiteId id = new SiteId(siteName);
        return this._getSite(id, context);
    }

    @Managed(value="/sites/{site-name}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="add-resource", description="Adds a given site")
    public ModelObject addSite(@MappedPath(value="site-name") String siteName, @MappedAttribute(value="template") String template, @ManagedContext PathAddress address) {
        SiteId siteId = new SiteId(siteName);
        return this._addSite(address, siteId, template);
    }

    @Managed(value="/sites/{site-name}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="remove-resource", description="Removes the given site")
    public void removeSite(@MappedPath(value="site-name") String siteName, @ManagedContext OperationContext context) {
        SiteId id = new SiteId(siteName);
        this._removeSite(id, context);
    }

    @Managed(value="/sites/{site-name}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="update-resource", description="Updates a given site")
    public ModelObject updateSite(@MappedPath(value="site-name") String siteName, @ManagedContext ModelObject siteModel, @ManagedContext OperationContext context) {
        SiteId id = new SiteId(siteName);
        return this._updateSite(id, siteModel, context);
    }

    @Managed(value="/sites/{site-name}/pages")
    public PageManagementResource getPages(@MappedPath(value="site-name") String siteName, @ManagedContext OperationContext context) {
        SiteId id = new SiteId(siteName);
        return this.pagesResource(id, context);
    }

    @Managed(value="/sites/{site-name}/navigation")
    public NavigationManagementResource getNavigation(@MappedPath(value="site-name") String siteName, @ManagedContext OperationContext context) {
        SiteId id = new SiteId(siteName);
        return this.navigationResource(id, context);
    }

    @Managed(value="/spaces")
    public ModelList getSpaces(@ManagedContext PathAddress address, @MappedAttribute(value="emptySites") String emptySites, @MappedAttribute(value="offset") String offset, @MappedAttribute(value="limit") String limit) {
        return this._getSites(SPACE_QUERY, address, emptySites, offset, limit);
    }

    @Managed(value="/spaces/{group-name: .*}")
    public ModelObject getSpace(@MappedPath(value="group-name") String groupName, @ManagedContext OperationContext context) {
        SiteId id = new SiteId(new Group(groupName));
        return this._getSite(id, context);
    }

    @Managed(value="/spaces/{group-name: .*}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="add-resource", description="Adds a given site")
    public ModelObject addSpace(@MappedPath(value="group-name") String groupName, @MappedAttribute(value="template") String template, @ManagedContext PathAddress address) {
        SiteId siteId = new SiteId(new Group(groupName));
        return this._addSite(address, siteId, template);
    }

    @Managed(value="/spaces/{group-name: .*}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="remove-resource", description="Removes the given space")
    public void removeSpace(@MappedPath(value="group-name") String groupName, @ManagedContext OperationContext context) {
        SiteId id = new SiteId(new Group(groupName));
        this._removeSite(id, context);
    }

    @Managed(value="/spaces/{group-name: .*}")
    @ManagedRole(value="administrators")
    @ManagedOperation(name="update-resource", description="Updates a given space")
    public ModelObject updateSpace(@MappedPath(value="group-name") String groupName, @ManagedContext ModelObject siteModel, @ManagedContext OperationContext context) {
        SiteId id = new SiteId(new Group(groupName));
        return this._updateSite(id, siteModel, context);
    }

    @Managed(value="/spaces/{group-name: .*}/pages")
    public PageManagementResource getSpacePages(@MappedPath(value="group-name") String groupName, @ManagedContext OperationContext context) {
        SiteId id = new SiteId(new Group(groupName));
        return this.pagesResource(id, context);
    }

    @Managed(value="/spaces/{group-name: .*}/navigation")
    public NavigationManagementResource getSpaceNavigation(@MappedPath(value="group-name") String groupName, @ManagedContext OperationContext context) {
        SiteId id = new SiteId(new Group(groupName));
        return this.navigationResource(id, context);
    }

    private NavigationManagementResource navigationResource(SiteId siteId, OperationContext context) {
        this.requireSite(siteId, context);
        Navigation navigation = this.portal.getNavigation(siteId);
        if (navigation == null) {
            throw new ResourceNotFoundException("Navigation does not exist for site " + siteId);
        }
        return new NavigationManagementResource(navigation, this.modelProvider);
    }

    private PageManagementResource pagesResource(SiteId siteId, OperationContext context) {
        this.requireSite(siteId, context);
        return new PageManagementResource(this.portal, this.modelProvider, siteId);
    }

    private ModelList _getSites(SiteQuery query, PathAddress address, String emptySitesParam, String offsetParam, String limitParam) {
        boolean emptySites = Boolean.valueOf(emptySitesParam);
        Pagination pagination = Utils.getPagination(offsetParam, limitParam, query.getPagination());
        query = new SiteQuery.Builder().from(query).includeEmptySites(emptySites).withPagination(pagination).build();
        List sites = this.portal.findSites(query);
        return this.populateModel(sites, (ModelList)this.modelProvider.newModel(ModelList.class), address);
    }

    private ModelObject _getSite(SiteId id, OperationContext context) {
        Site site = this.requireSite(id, context);
        return this.populateModel(site, (ModelObject)this.modelProvider.newModel(ModelObject.class), context.getAddress());
    }

    private ModelObject _addSite(PathAddress address, SiteId siteId, String template) {
        Site site;
        try {
            site = template == null ? this.portal.createSite(siteId) : this.portal.createSite(siteId, template);
        }
        catch (EntityAlreadyExistsException e) {
            throw Utils.alreadyExists("Could not add site", siteId);
        }
        this.portal.saveSite(site);
        return this.populateModel(site, (ModelObject)this.modelProvider.newModel(ModelObject.class), address);
    }

    private void _removeSite(SiteId id, OperationContext context) {
        this.requireSite(id, context);
        try {
            boolean removed = this.portal.removeSite(id);
            if (!removed) {
                throw new RuntimeException("Could not remove site + " + id + " for unknown reasons.");
            }
        }
        catch (EntityNotFoundException e) {
            throw Utils.notFound("Cannot remove site", id);
        }
    }

    private ModelObject _updateSite(SiteId id, ModelObject siteModel, OperationContext context) {
        Permission permission;
        Site site = this.requireSite(id, context);
        if (siteModel.has("displayName")) {
            String displayName = Utils.get(siteModel, ModelString.class, "displayName").getValue();
            site.setDisplayName(displayName);
        }
        if (siteModel.has("description")) {
            String description = Utils.get(siteModel, ModelString.class, "description").getValue();
            site.setDescription(description);
        }
        if (siteModel.has("skin")) {
            String skin = Utils.get(siteModel, ModelString.class, "skin").getValue();
            site.setSkin(skin);
        }
        if (siteModel.has("locale")) {
            Locale locale = Utils.getLocale(siteModel, "locale");
            site.setLocale(locale);
        }
        if (siteModel.has("access-permissions")) {
            permission = Utils.getPermission(siteModel, false, "access-permissions");
            site.setAccessPermission(permission);
        }
        if (siteModel.has("edit-permissions")) {
            permission = Utils.getPermission(siteModel, true, "edit-permissions");
            site.setEditPermission(permission);
        }
        if (siteModel.hasDefined("attributes")) {
            ModelList list = Utils.get(siteModel, ModelList.class, "attributes");
            for (int i = 0; i < list.size(); ++i) {
                ModelValue mv = list.get(i);
                String field = "attributes[" + i + "]";
                if (mv.getValueType() != ModelValue.ModelValueType.OBJECT) {
                    throw Utils.invalidType(mv, ModelValue.ModelValueType.OBJECT, field);
                }
                ModelObject attrModel = (ModelObject)mv.asValue(ModelObject.class);
                if (!attrModel.hasDefined("key")) {
                    throw Utils.requiredField(field, "key");
                }
                String key = Utils.get(attrModel, ModelString.class, "key").getValue();
                if (!attrModel.has("value")) {
                    throw Utils.requiredField(field, "value");
                }
                String value = Utils.get(attrModel, ModelString.class, "value").getValue();
                site.getAttributes().put((Object)key, (Object)value);
            }
        }
        this.portal.saveSite(site);
        return this.populateModel(site, (ModelObject)this.modelProvider.newModel(ModelObject.class), context.getAddress());
    }

    private Site requireSite(SiteId id, OperationContext context) {
        Site site = this.portal.getSite(id);
        if (site == null) {
            throw new ResourceNotFoundException("Site not found for " + id);
        }
        Utils.verifyAccess(site, context);
        return site;
    }

    private ModelObject populateModel(Site site, ModelObject siteModel, PathAddress address) {
        siteModel.set("name", site.getId().getName());
        siteModel.set("type", site.getId().getType().name().toLowerCase());
        siteModel.set("displayName", site.getDisplayName());
        siteModel.set("description", site.getDescription());
        siteModel.set("skin", site.getSkin());
        Utils.populate("locale", site.getLocale(), siteModel);
        Utils.populate("access-permissions", site.getAccessPermission(), siteModel);
        Utils.populate("edit-permissions", site.getEditPermission(), siteModel);
        ModelList attrList = (ModelList)siteModel.get("attributes", ModelList.class);
        Attributes attributes = site.getAttributes();
        for (String key : attributes.keySet()) {
            ModelObject attr = attrList.add().setEmptyObject();
            attr.set("key", key);
            attr.set("value", (String)attributes.get((Object)key));
        }
        ModelReference pagesRef = (ModelReference)siteModel.get("pages", ModelReference.class);
        pagesRef.set(address.append("pages"));
        ModelReference navigationRef = (ModelReference)siteModel.get("navigation", ModelReference.class);
        navigationRef.set(address.append("navigation"));
        return siteModel;
    }

    private ModelList populateModel(List<Site> sites, ModelList list, PathAddress address) {
        for (Site site : sites) {
            if (!Utils.hasPermission(site.getAccessPermission())) continue;
            ModelReference siteRef = (ModelReference)list.add().asValue(ModelReference.class);
            siteRef.set("name", site.getName());
            siteRef.set("type", site.getType().getName());
            siteRef.set(address.append(site.getName()));
        }
        return list;
    }

    private User getUser(ManagedUser managedUser) {
        if (managedUser == null) {
            return User.anonymous();
        }
        return new User(managedUser.getUserName());
    }

    private void setCurrentPortalRequest(OperationContext context) {
        ManagedUser managedUser = context.getUser();
        PathAddress address = context.getAddress();
        SiteId siteId = GateInApiManagementResource.getSiteId(address);
        NodePath nodePath = GateInApiManagementResource.getNodePath(address);
        Locale locale = context.getLocale();
        if (locale != null && locale.getLanguage().equals("*")) {
            locale = null;
        }
        User user = managedUser == null || managedUser.getUserName() == null ? User.anonymous() : new User(managedUser.getUserName());
        final PortalContainer container = PortalContainer.getInstance();
        final WebAppController controller = (WebAppController)container.getComponentInstanceOfType(WebAppController.class);
        URIResolver uriResolver = new URIResolver(){

            public String resolveURI(SiteId siteId) {
                SiteKey siteKey = Util.from(siteId);
                NavigationResource navResource = new NavigationResource(siteKey, "");
                SimpleURL url = new SimpleURL((URLContext)new SimpleURLContext(container, controller));
                url.setSchemeUse(false);
                url.setAuthorityUse(false);
                String urlString = url.setResource(navResource).toString();
                return urlString.substring(0, urlString.length() - 1);
            }
        };
        BasicPortalRequest.setInstance(new BasicPortalRequest(user, siteId, nodePath, locale, this.portal, uriResolver));
    }

    private static SiteId getSiteId(PathAddress address) {
        String siteName = address.resolvePathTemplate("site-name");
        if (siteName != null) {
            return new SiteId(siteName);
        }
        String groupName = address.resolvePathTemplate("group-name");
        if (groupName != null) {
            return new SiteId(new Group(groupName));
        }
        String userName = address.resolvePathTemplate("user-name");
        if (userName != null) {
            return new SiteId(new User(userName));
        }
        return null;
    }

    private static NodePath getNodePath(PathAddress address) {
        String path = address.resolvePathTemplate("path");
        if (path != null) {
            return NodePath.fromString((String)path);
        }
        return null;
    }

    static PathAddress getSiteAddress(SiteId siteId) {
        PathAddress address = PathAddress.pathAddress((String)"api");
        switch (siteId.getType()) {
            case SITE: {
                address = address.append("sites");
                break;
            }
            case SPACE: {
                address = address.append("spaces");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return address.append(siteId.getName());
    }

    static PathAddress getPagesAddress(SiteId siteId) {
        return GateInApiManagementResource.getSiteAddress(siteId).append("pages");
    }

    static PathAddress getNavigationAddress(SiteId siteId) {
        return GateInApiManagementResource.getSiteAddress(siteId).append("navigation");
    }
}

