/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage.cache;

import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.storage.LayoutStorage;
import org.exoplatform.portal.mop.storage.PageStorageImpl;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PageKey;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.listener.ListenerService;

public class CachePageStorage
extends PageStorageImpl {
    public static final String PAGE_CACHE_NAME = "portal.PageService";
    private final FutureExoCache<org.exoplatform.portal.mop.page.PageKey, PageData, Object> pageFutureCache;

    public CachePageStorage(CacheService cacheService, ListenerService listenerService, LayoutStorage layoutStorage, SiteDAO siteDAO, PageDAO pageDAO) {
        super(listenerService, layoutStorage, siteDAO, pageDAO);
        this.pageFutureCache = new FutureExoCache((Loader)new Loader<org.exoplatform.portal.mop.page.PageKey, PageData, Object>(){

            public PageData retrieve(Object context, org.exoplatform.portal.mop.page.PageKey pageKey) throws Exception {
                PageData pageData = CachePageStorage.super.getPage(pageKey.toPomPageKey());
                return pageData == null ? PageData.NULL_OBJECT : pageData;
            }
        }, cacheService.getCacheInstance(PAGE_CACHE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageContext clone(org.exoplatform.portal.mop.page.PageKey srcPageKey, org.exoplatform.portal.mop.page.PageKey dstPageKey) {
        try {
            PageContext pageContext = super.clone(srcPageKey, dstPageKey);
            return pageContext;
        }
        finally {
            this.pageFutureCache.remove((Serializable)srcPageKey);
            this.pageFutureCache.remove((Serializable)dstPageKey);
        }
    }

    @Override
    public boolean savePage(PageContext page) {
        try {
            boolean bl = super.savePage(page);
            return bl;
        }
        finally {
            this.pageFutureCache.remove((Serializable)page.getKey());
        }
    }

    @Override
    public void save(PageData page) {
        try {
            super.save(page);
        }
        finally {
            this.pageFutureCache.remove((Serializable)page.getKey().toMopPageKey());
        }
    }

    @Override
    public boolean destroyPage(org.exoplatform.portal.mop.page.PageKey key) {
        try {
            boolean bl = super.destroyPage(key);
            return bl;
        }
        finally {
            this.pageFutureCache.remove((Serializable)key);
        }
    }

    @Override
    public PageData getPage(PageKey key) {
        PageData pageData = (PageData)this.pageFutureCache.get(null, (Object)key.toMopPageKey());
        return pageData == null || pageData.isNull() ? null : pageData;
    }
}

