/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.i18n;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.gatein.common.i18n.AbstractLocaleFormat;
import org.gatein.common.i18n.LocaleFactory;
import org.gatein.common.text.CharWriter;
import org.gatein.common.util.FormatConversionException;

class DefaultLocaleFormat
extends AbstractLocaleFormat {
    private Map<String, Locale> CACHE = new HashMap<String, Locale>();
    private LocaleFactory factory;

    public DefaultLocaleFormat(LocaleFactory factory) {
        this.factory = factory;
    }

    public DefaultLocaleFormat() {
        this(LocaleFactory.DEFAULT_FACTORY);
    }

    @Override
    protected Locale internalGetLocale(String value) throws FormatConversionException {
        Locale locale = this.CACHE.get(value);
        if (locale != null) {
            return locale;
        }
        int p1 = value.lastIndexOf(95);
        if (p1 < 0) {
            locale = this.factory.createLocale(value);
        } else {
            String a = p1 == value.length() - 1 ? "" : value.substring(p1 + 1, value.length());
            int p2 = value.lastIndexOf(95, p1 - 1);
            if (p2 < 0) {
                if (a.length() == 0) {
                    throw new FormatConversionException();
                }
                locale = this.factory.createLocale(value.substring(0, p1), a);
            } else {
                boolean emptyLanguage;
                boolean bl = emptyLanguage = p2 == p1 - 1;
                if (p2 == 0 && emptyLanguage) {
                    throw new FormatConversionException();
                }
                String b = emptyLanguage ? "" : value.substring(p2 + 1, p1);
                locale = this.factory.createLocale(value.substring(0, p2), b, a);
            }
        }
        HashMap<String, Locale> copy = new HashMap<String, Locale>(this.CACHE);
        copy.put(locale.toString(), locale);
        this.CACHE = copy;
        return locale;
    }

    @Override
    protected void internalWrite(Locale locale, CharWriter writer) throws IOException {
        writer.append(locale.toString());
    }
}

