/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.entity;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.entity.AbstractAuditingEntity;
import io.meeds.gamification.entity.ProgramEntity;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="Rule")
@ExoEntity
@Table(name="GAMIFICATION_RULE")
@NamedQueries(value={@NamedQuery(name="Rule.findActiveRuleByEventAndDomain", query="SELECT rule FROM Rule rule WHERE LOWER(rule.event) = LOWER(:event) AND rule.domainEntity.id = :domainId AND rule.isEnabled = true AND rule.isDeleted = false AND (rule.startDate IS NULL OR rule.startDate <= :date) AND (rule.endDate IS NULL OR rule.endDate > :date) AND rule.type = :type"), @NamedQuery(name="Rule.findRuleByTitle", query="SELECT rule FROM Rule rule WHERE LOWER(rule.title) = LOWER(:ruleTitle) AND rule.type = :type"), @NamedQuery(name="Rule.getRulesTotalScoreByDomain", query=" SELECT SUM(rule.score) FROM Rule rule  WHERE rule.domainEntity.id = :domainId AND rule.isEnabled = true AND rule.isDeleted = false AND (rule.startDate IS NULL OR rule.startDate <= :date) AND (rule.endDate IS NULL OR rule.endDate > :date)"), @NamedQuery(name="Rule.getHighestBudgetDomainIds", query=" SELECT rule.domainEntity.id, SUM(rule.score) as totalScore FROM Rule rule INNER JOIN rule.domainEntity domain   ON domain.isEnabled = true  AND domain.isDeleted = false WHERE rule.isEnabled = true   AND rule.isDeleted = false   AND (rule.startDate IS NULL OR rule.startDate <= :date)   AND (rule.endDate IS NULL OR rule.endDate > :date) GROUP BY rule.domainEntity.id  ORDER BY totalScore DESC"), @NamedQuery(name="Rule.getHighestBudgetOpenDomainIds", query=" SELECT rule.domainEntity.id, SUM(rule.score) as totalScore FROM Rule rule INNER JOIN rule.domainEntity domain   ON domain.isEnabled = true  AND domain.isDeleted = false  AND domain.audienceId IS NULL WHERE rule.isEnabled = true   AND rule.isDeleted = false   AND (rule.startDate IS NULL OR rule.startDate <= :date)   AND (rule.endDate IS NULL OR rule.endDate > :date) GROUP BY rule.domainEntity.id  ORDER BY totalScore DESC"), @NamedQuery(name="Rule.getHighestBudgetDomainIdsBySpacesIds", query=" SELECT rule.domainEntity.id, SUM(rule.score) as totalScore FROM Rule rule INNER JOIN rule.domainEntity domain   ON domain.isEnabled = true  AND domain.isDeleted = false  AND (domain.audienceId IS NULL OR domain.audienceId in (:spacesIds)) WHERE rule.isEnabled = true   AND rule.isDeleted = false   AND (rule.startDate IS NULL OR rule.startDate <= :date)   AND (rule.endDate IS NULL OR rule.endDate > :date) GROUP BY rule.domainEntity.id  ORDER BY totalScore DESC")})
public class RuleEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_RULE_ID", sequenceName="SEQ_GAMIFICATION_RULE_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_RULE_ID")
    protected Long id;
    @Column(name="TITLE", unique=true, nullable=false)
    protected String title;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="SCORE")
    protected int score;
    @Column(name="ACTIVITY_ID")
    protected long activityId;
    @Column(name="EVENT")
    protected String event;
    @ManyToOne
    @JoinColumn(name="DOMAIN_ID")
    private ProgramEntity domainEntity;
    @Column(name="ENABLED", nullable=false)
    protected boolean isEnabled;
    @Column(name="DELETED", nullable=false)
    protected boolean isDeleted;
    @Column(name="START_DATE")
    private Date startDate;
    @Column(name="END_DATE")
    private Date endDate;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE", nullable=false)
    protected EntityType type;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="RECURRENCE", nullable=false)
    private RecurrenceType recurrence;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="GAMIFICATION_PREREQUISITE_RULES", joinColumns={@JoinColumn(name="RULE_ID")})
    @Column(name="PREREQUISITE_RULE_ID")
    private Set<Long> prerequisiteRules;

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getScore() {
        return this.score;
    }

    public long getActivityId() {
        return this.activityId;
    }

    public String getEvent() {
        return this.event;
    }

    public ProgramEntity getDomainEntity() {
        return this.domainEntity;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public EntityType getType() {
        return this.type;
    }

    public RecurrenceType getRecurrence() {
        return this.recurrence;
    }

    public Set<Long> getPrerequisiteRules() {
        return this.prerequisiteRules;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setDomainEntity(ProgramEntity domainEntity) {
        this.domainEntity = domainEntity;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    public void setRecurrence(RecurrenceType recurrence) {
        this.recurrence = recurrence;
    }

    public void setPrerequisiteRules(Set<Long> prerequisiteRules) {
        this.prerequisiteRules = prerequisiteRules;
    }

    @Override
    public String toString() {
        return "RuleEntity(id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", score=" + this.getScore() + ", activityId=" + this.getActivityId() + ", event=" + this.getEvent() + ", domainEntity=" + this.getDomainEntity() + ", isEnabled=" + this.isEnabled() + ", isDeleted=" + this.isDeleted() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", type=" + this.getType() + ", recurrence=" + this.getRecurrence() + ", prerequisiteRules=" + this.getPrerequisiteRules() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleEntity)) {
            return false;
        }
        RuleEntity other = (RuleEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getScore() != other.getScore()) {
            return false;
        }
        if (this.getActivityId() != other.getActivityId()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        ProgramEntity this$domainEntity = this.getDomainEntity();
        ProgramEntity other$domainEntity = other.getDomainEntity();
        if (this$domainEntity == null ? other$domainEntity != null : !((Object)this$domainEntity).equals(other$domainEntity)) {
            return false;
        }
        Date this$startDate = this.getStartDate();
        Date other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Date this$endDate = this.getEndDate();
        Date other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        RecurrenceType this$recurrence = this.getRecurrence();
        RecurrenceType other$recurrence = other.getRecurrence();
        if (this$recurrence == null ? other$recurrence != null : !((Object)((Object)this$recurrence)).equals((Object)other$recurrence)) {
            return false;
        }
        Set<Long> this$prerequisiteRules = this.getPrerequisiteRules();
        Set<Long> other$prerequisiteRules = other.getPrerequisiteRules();
        return !(this$prerequisiteRules == null ? other$prerequisiteRules != null : !((Object)this$prerequisiteRules).equals(other$prerequisiteRules));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RuleEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getScore();
        long $activityId = this.getActivityId();
        result = result * 59 + (int)($activityId >>> 32 ^ $activityId);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        ProgramEntity $domainEntity = this.getDomainEntity();
        result = result * 59 + ($domainEntity == null ? 43 : ((Object)$domainEntity).hashCode());
        Date $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Date $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        RecurrenceType $recurrence = this.getRecurrence();
        result = result * 59 + ($recurrence == null ? 43 : ((Object)((Object)$recurrence)).hashCode());
        Set<Long> $prerequisiteRules = this.getPrerequisiteRules();
        result = result * 59 + ($prerequisiteRules == null ? 43 : ((Object)$prerequisiteRules).hashCode());
        return result;
    }
}

