/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.plugin;

import com.github.scribejava.apis.GitHubApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import io.meeds.gamification.model.RemoteConnectorSettings;
import io.meeds.gamification.plugin.ConnectorPlugin;
import io.meeds.gamification.service.ConnectorSettingService;
import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.gamification.github.model.GithubAccessTokenContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GithubConnectorPlugin
extends ConnectorPlugin {
    private static final Log LOG = ExoLogger.getLogger(GithubConnectorPlugin.class);
    private static final String CONNECTOR_NAME = "github";
    private static final String CONNECTOR_SCOPE = "read:user";
    private static final String CONNECTOR_REST_API = "https://api.github.com/user";
    private final ConnectorSettingService connectorSettingService;
    private OAuth20Service oAuthService;
    private long remoteConnectorId;

    public GithubConnectorPlugin(ConnectorSettingService connectorSettingService) {
        this.connectorSettingService = connectorSettingService;
    }

    public String validateToken(String accessToken) throws OAuthException {
        RemoteConnectorSettings remoteConnectorSettings = this.connectorSettingService.getConnectorSettings(CONNECTOR_NAME);
        remoteConnectorSettings.setSecretKey(this.connectorSettingService.getConnectorSecretKey(CONNECTOR_NAME));
        if (StringUtils.isBlank((String)remoteConnectorSettings.getApiKey()) || StringUtils.isBlank((String)remoteConnectorSettings.getSecretKey())) {
            LOG.warn("Missing '{}' connector settings", new Object[]{CONNECTOR_NAME});
            return null;
        }
        if (StringUtils.isNotBlank((String)accessToken)) {
            try {
                OAuth2AccessToken oAuth2AccessToken = this.getOAuthService(remoteConnectorSettings).getAccessToken(accessToken);
                GithubAccessTokenContext accessTokenContext = new GithubAccessTokenContext(oAuth2AccessToken);
                String githubIdentifier = GithubConnectorPlugin.fetchUsernameFromAccessToken(accessTokenContext);
                if (StringUtils.isBlank((String)githubIdentifier)) {
                    throw new OAuthException(OAuthExceptionCode.INVALID_STATE, "User Github identifier is empty");
                }
                return githubIdentifier;
            }
            catch (IOException | InterruptedException e) {
                throw new OAuthException(OAuthExceptionCode.IO_ERROR, (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new OAuthException(OAuthExceptionCode.UNKNOWN_ERROR, (Throwable)e);
            }
        }
        throw new OAuthException(OAuthExceptionCode.USER_DENIED_SCOPE, "User denied scope on Github authorization page");
    }

    public String getConnectorName() {
        return CONNECTOR_NAME;
    }

    private static String fetchUsernameFromAccessToken(GithubAccessTokenContext accessToken) throws IOException {
        URL url = new URL(CONNECTOR_REST_API);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Authorization", "Bearer " + accessToken.getAccessToken());
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                String string = response.toString().split("\"login\":")[1].split(",")[0].replace("\"", "").trim();
                return string;
            }
        }
        throw new IOException("Error retrieving user information from GitHub. Response code: " + responseCode);
    }

    public OAuth20Service getOAuthService(RemoteConnectorSettings remoteConnectorSettings) {
        if (this.oAuthService == null || (long)remoteConnectorSettings.hashCode() != this.remoteConnectorId) {
            this.remoteConnectorId = remoteConnectorSettings.hashCode();
            this.oAuthService = new ServiceBuilder(remoteConnectorSettings.getApiKey()).apiSecret(remoteConnectorSettings.getSecretKey()).callback(remoteConnectorSettings.getRedirectUrl()).defaultScope(CONNECTOR_SCOPE).build((DefaultApi20)GitHubApi.instance());
        }
        return this.oAuthService;
    }
}

