/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.serialization.SerializationContext;
import org.exoplatform.commons.serialization.api.TypeConverter;
import org.exoplatform.commons.serialization.api.factory.ObjectFactory;
import org.exoplatform.commons.serialization.model.ClassTypeModel;
import org.exoplatform.commons.serialization.model.ConvertedTypeModel;
import org.exoplatform.commons.serialization.model.FieldModel;
import org.exoplatform.commons.serialization.model.TypeModel;
import org.exoplatform.commons.serialization.serial.DataContainer;

public class ObjectReader
extends ObjectInputStream {
    private final SerializationContext context;
    private final Map<Integer, Object> idToObject;
    private final Map<Integer, List<FutureFieldUpdate<?>>> idToResolutions;

    public ObjectReader(SerializationContext context, InputStream in) throws IOException {
        super(in);
        this.enableResolveObject(true);
        this.context = context;
        this.idToObject = new HashMap<Integer, Object>();
        this.idToResolutions = new HashMap();
    }

    private <O> O instantiate(ClassTypeModel<O> typeModel, Map<FieldModel<? super O, ?>, ?> state) throws InvalidClassException {
        try {
            ObjectFactory factory = this.context.getFactory(typeModel.getJavaType());
            return factory.create(typeModel.getJavaType(), state);
        }
        catch (Exception e) {
            InvalidClassException ice = new InvalidClassException("Cannot instantiate object from class " + typeModel.getJavaType().getName());
            ice.initCause(e);
            throw ice;
        }
    }

    protected <O> O instantiate(int id, DataContainer container, ClassTypeModel<O> typeModel) throws IOException {
        HashMap<Object, Object> state = new HashMap<Object, Object>();
        ArrayList sets = new ArrayList();
        for (TypeModel currentTypeModel = typeModel; currentTypeModel != null; currentTypeModel = currentTypeModel.getSuperType()) {
            if (!(currentTypeModel instanceof ClassTypeModel)) continue;
            for (FieldModel<O, ?> fieldModel : currentTypeModel.getFields()) {
                if (fieldModel.isTransient()) continue;
                switch (container.readInt()) {
                    case 1: {
                        state.put(fieldModel, null);
                        break;
                    }
                    case 2: {
                        int n = container.readInt();
                        Object refO = this.idToObject.get(n);
                        if (refO != null) {
                            state.put(fieldModel, refO);
                            break;
                        }
                        sets.add(new FieldUpdate(n, fieldModel));
                        break;
                    }
                    case 0: {
                        Object o = container.readObject();
                        state.put(fieldModel, o);
                    }
                }
            }
        }
        O instance = this.instantiate(typeModel, state);
        for (FieldUpdate fieldUpdate : sets) {
            List<FutureFieldUpdate<?>> resolutions = this.idToResolutions.get(fieldUpdate.ref);
            if (resolutions == null) {
                resolutions = new ArrayList();
                this.idToResolutions.put(fieldUpdate.ref, resolutions);
            }
            resolutions.add(new FutureFieldUpdate(instance, fieldUpdate.fieldModel));
        }
        this.idToObject.put(id, instance);
        List<FutureFieldUpdate<?>> resolutions = this.idToResolutions.remove(id);
        if (resolutions != null) {
            for (FutureFieldUpdate<?> resolution : resolutions) {
                resolution.fieldModel.castAndSet(resolution.target, instance);
            }
        }
        return instance;
    }

    private Object read(DataContainer container) throws IOException {
        int sw = container.readInt();
        switch (sw) {
            case 2: {
                int id = container.readInt();
                Object o1 = this.idToObject.get(id);
                if (o1 == null) {
                    throw new AssertionError();
                }
                return o1;
            }
            case 0: {
                int id = container.readInt();
                Class clazz = (Class)container.readObject();
                ClassTypeModel typeModel = (ClassTypeModel)this.context.getTypeDomain().getTypeModel(clazz);
                return this.instantiate(id, container, typeModel);
            }
            case 3: {
                Class tclazz = (Class)container.readObject();
                ConvertedTypeModel ctm = (ConvertedTypeModel)this.context.getTypeDomain().getTypeModel(tclazz);
                return this.convertObject(container, ctm);
            }
            case 4: {
                return container.readObject();
            }
        }
        throw new StreamCorruptedException("Unrecognized data " + sw);
    }

    private <O, T> O convertObject(DataContainer container, ConvertedTypeModel<O, T> convertedType) throws IOException {
        TypeConverter<O, T> converter;
        Object inner = this.resolveObject(container);
        T t = convertedType.getTargetType().getJavaType().cast(inner);
        try {
            converter = convertedType.getConverterJavaType().newInstance();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        O o = null;
        try {
            o = converter.read(t);
        }
        catch (Exception e) {
            InvalidObjectException ioe = new InvalidObjectException("The object " + t + " conversion throw an exception " + converter);
            ioe.initCause(e);
            throw ioe;
        }
        if (o == null) {
            throw new InvalidObjectException("The object " + t + " was converted to null by converter " + converter);
        }
        return o;
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (obj instanceof DataContainer) {
            return this.read((DataContainer)obj);
        }
        return obj;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String name = desc.getName();
            return Class.forName(name, false, cl);
        }
        catch (ClassNotFoundException ex) {
            return super.resolveClass(desc);
        }
    }

    private static class FieldUpdate<O> {
        private final int ref;
        private final FieldModel<? super O, ?> fieldModel;

        private FieldUpdate(int ref, FieldModel<? super O, ?> fieldModel) {
            this.ref = ref;
            this.fieldModel = fieldModel;
        }
    }

    private static class FutureFieldUpdate<O> {
        private final O target;
        private final FieldModel<? super O, ?> fieldModel;

        private FutureFieldUpdate(O target, FieldModel<? super O, ?> fieldModel) {
            this.target = target;
            this.fieldModel = fieldModel;
        }
    }
}

