/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.social;

import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.analytics.listener.social.AnalyticsSpaceWebNotificationListener$AjcClosure1;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.exoplatform.social.notification.model.SpaceWebNotificationItemUpdate;

public class AnalyticsSpaceWebNotificationListener
extends Listener<SpaceWebNotificationItem, Long> {
    private SpaceService spaceService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AnalyticsSpaceWebNotificationListener(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    @ExoTransactional
    public void onEvent(Event<SpaceWebNotificationItem, Long> event) throws Exception {
        Event<SpaceWebNotificationItem, Long> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        AnalyticsSpaceWebNotificationListener$AjcClosure1 analyticsSpaceWebNotificationListener$AjcClosure1 = new AnalyticsSpaceWebNotificationListener$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(analyticsSpaceWebNotificationListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private StatisticData buildStatisticData(String operation, long spaceId, long userId) {
        StatisticData statisticData = this.buildStatisticData(operation, this.spaceService.getSpaceById(String.valueOf(spaceId)), userId);
        statisticData.setSpaceId(spaceId);
        return statisticData;
    }

    private StatisticData buildStatisticData(String operation, Space space, long userId) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("social");
        statisticData.setSubModule("spaceWebNotifications");
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        return statisticData;
    }

    static {
        AnalyticsSpaceWebNotificationListener.ajc$preClinit();
    }

    static /* synthetic */ void onEvent_aroundBody0(AnalyticsSpaceWebNotificationListener ajc$this, Event event, JoinPoint joinPoint) {
        SpaceWebNotificationItemUpdate spaceWebNotificationItemUpdate;
        String userEvent;
        StatisticData statisticData;
        String eventName = event.getEventName();
        SpaceWebNotificationItem spaceWebNotificationItem = (SpaceWebNotificationItem)event.getSource();
        switch (eventName) {
            case "notification.read.item": {
                statisticData = ajc$this.buildStatisticData("markAsRead", spaceWebNotificationItem.getSpaceId(), spaceWebNotificationItem.getUserId());
                break;
            }
            case "notification.unread.item": {
                statisticData = ajc$this.buildStatisticData("markAsUnRead", spaceWebNotificationItem.getSpaceId(), spaceWebNotificationItem.getUserId());
                break;
            }
            case "notification.read.allItems": {
                statisticData = ajc$this.buildStatisticData("markAllAsRead", spaceWebNotificationItem.getSpaceId(), spaceWebNotificationItem.getUserId());
                break;
            }
            default: {
                return;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)spaceWebNotificationItem.getApplicationName())) {
            statisticData.addParameter("entityType", (Object)spaceWebNotificationItem.getApplicationName());
        }
        if (StringUtils.isNotBlank((CharSequence)spaceWebNotificationItem.getApplicationItemId())) {
            statisticData.addParameter("entityId", (Object)spaceWebNotificationItem.getApplicationItemId());
        }
        if (spaceWebNotificationItem instanceof SpaceWebNotificationItemUpdate && StringUtils.isNotBlank((CharSequence)(userEvent = (spaceWebNotificationItemUpdate = (SpaceWebNotificationItemUpdate)spaceWebNotificationItem).getUserEvent()))) {
            statisticData.addParameter("event-type", (Object)userEvent);
        }
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AnalyticsSpaceWebNotificationListener.java", AnalyticsSpaceWebNotificationListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "org.exoplatform.analytics.listener.social.AnalyticsSpaceWebNotificationListener", "org.exoplatform.services.listener.Event", "event", "java.lang.Exception", "void"), 44);
    }
}

