/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ConnectionDAOImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.dao.jpa.query.RelationshipQueryBuilder;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;

public class ConnectionDAOImpl
extends GenericDAOJPAImpl<ConnectionEntity, Long>
implements ConnectionDAO {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    @ExoTransactional
    public long count(Identity identity, Relationship.Type status) {
        Identity identity2 = identity;
        Relationship.Type type = status;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)identity2, (Object)type);
        Object[] objectArray = new Object[]{this, identity2, type, joinPoint};
        ConnectionDAOImpl$AjcClosure1 connectionDAOImpl$AjcClosure1 = new ConnectionDAOImpl$AjcClosure1(objectArray);
        return Conversions.longValue((Object)ExoTransactionalAspect.aspectOf().around(connectionDAOImpl$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    @Override
    public ConnectionEntity getConnection(Identity identity1, Identity identity2) {
        long senderId = Long.parseLong(identity1.getId());
        long receiverId = Long.parseLong(identity2.getId());
        return this.getConnection(senderId, receiverId);
    }

    @Override
    public ConnectionEntity getConnection(Long sender, Long reciver) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocConnection.findConnectionBySenderAndReceiver", ConnectionEntity.class);
        query.setParameter("sender", (Object)sender);
        query.setParameter("reciver", (Object)reciver);
        query.setMaxResults(1);
        try {
            return (ConnectionEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<ConnectionEntity> getConnections(Identity identity, Relationship.Type status, long offset, long limit, Sorting sorting) {
        String sortFieldName = sorting == null || sorting.sortBy == null ? null : sorting.sortBy.getFieldName();
        String sortDirection = sorting == null || sorting.orderBy == null ? Sorting.OrderBy.ASC.name() : sorting.orderBy.name();
        Query query = this.getConnectionsQuery(identity.getId(), status, sortFieldName, sortDirection);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    @Override
    public Set<Long> getConnectionIds(long identityId, Relationship.Type status) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocConnection.getConnectionIdsWithStatus", Tuple.class);
        query.setParameter("identityId", (Object)identityId);
        query.setParameter("status", (Object)status);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptySet() : resultList.stream().map(tuple -> {
            Long id = (Long)tuple.get(0);
            if (identityId == id) {
                id = (Long)tuple.get(1);
            }
            return id;
        }).collect(Collectors.toSet());
    }

    @Override
    public List<ConnectionEntity> getConnections(Identity sender, Identity receiver, Relationship.Type status) {
        if (receiver == null && sender == null) {
            throw new IllegalArgumentException("Sender and receiver are null. Can't query the whole database.");
        }
        TypedQuery query = null;
        if (sender == null) {
            if (status == null) {
                query = this.getEntityManager().createNamedQuery("SocConnection.getSenderByReceiverWithoutStatus", ConnectionEntity.class);
                long id = Long.parseLong(receiver.getId());
                query.setParameter("identityId", (Object)id);
            } else {
                query = this.getEntityManager().createNamedQuery("SocConnection.getSenderByReceiverWithStatus", ConnectionEntity.class);
                long id = Long.parseLong(receiver.getId());
                query.setParameter("identityId", (Object)id);
                query.setParameter("status", (Object)status);
            }
        } else if (receiver == null && status == null) {
            query = this.getEntityManager().createNamedQuery("SocConnection.getReceiverBySenderWithoutStatus", ConnectionEntity.class);
            long id = Long.parseLong(sender.getId());
            query.setParameter("identityId", (Object)id);
        } else if (receiver == null) {
            query = this.getEntityManager().createNamedQuery("SocConnection.getReceiverBySenderWithStatus", ConnectionEntity.class);
            long id = Long.parseLong(sender.getId());
            query.setParameter("identityId", (Object)id);
            query.setParameter("status", (Object)status);
        } else if (status == null) {
            query = this.getEntityManager().createNamedQuery("SocConnection.findConnectionBySenderAndReceiver", ConnectionEntity.class);
            long id = Long.parseLong(sender.getId());
            query.setParameter("senderId", (Object)id);
            id = Long.parseLong(receiver.getId());
            query.setParameter("receiverId", (Object)id);
        } else {
            query = this.getEntityManager().createNamedQuery("SocConnection.findConnectionBySenderAndReceiverWithStatus", ConnectionEntity.class);
            long id = Long.parseLong(sender.getId());
            query.setParameter("senderId", (Object)id);
            id = Long.parseLong(receiver.getId());
            query.setParameter("receiverId", (Object)id);
            query.setParameter("status", (Object)status);
        }
        return query.getResultList();
    }

    @Override
    public int getConnectionsCount(Identity identity, Relationship.Type status) {
        Long ownerId = Long.valueOf(identity.getId());
        String queryName = null;
        if (status == null || status == Relationship.Type.ALL) {
            queryName = "SocConnection.countConnectionsWithoutStatus";
        } else {
            if (status == Relationship.Type.INCOMING) {
                return this.countSenderId(ownerId, Relationship.Type.PENDING).intValue();
            }
            if (status == Relationship.Type.OUTGOING) {
                return this.countReceiverId(ownerId, Relationship.Type.PENDING).intValue();
            }
            queryName = "SocConnection.countConnectionsWithStatus";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, Long.class);
        query.setParameter("identityId", (Object)ownerId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<ConnectionEntity> getLastConnections(Identity identity, int limit) {
        if (identity == null) {
            throw new IllegalArgumentException("identity is null. Can't query the whole database.");
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocConnection.getConnectionsWithStatus", ConnectionEntity.class);
        long id = Long.parseLong(identity.getId());
        query.setParameter("identityId", (Object)id);
        query.setParameter("status", (Object)Relationship.Type.CONFIRMED);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<ConnectionEntity> getConnectionsByFilter(Identity existingIdentity, ProfileFilter profileFilter, Relationship.Type type, long offset, long limit) {
        return RelationshipQueryBuilder.builder().owner(existingIdentity).status(type).offset(0L).limit(limit).filter(profileFilter).buildFilter().getResultList();
    }

    @Override
    public int getConnectionsByFilterCount(Identity identity, ProfileFilter profileFilter, Relationship.Type type) {
        return ((Long)RelationshipQueryBuilder.builder().owner(identity).status(type).filter(profileFilter).buildFilterCount().getSingleResult()).intValue();
    }

    @Override
    public List<Long> getSenderIds(long receiverId, Relationship.Type status, int offset, int limit) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.getSenderIdsByReceiverWithoutStatus" : "SocConnection.getSenderIdsByReceiverWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, Long.class);
        query.setParameter("identityId", (Object)receiverId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<Long> getReceiverIds(long senderId, Relationship.Type status, int offset, int limit) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.getReceiverIdsBySenderWithoutStatus" : "SocConnection.getReceiverIdsBySenderWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, Long.class);
        query.setParameter("identityId", (Object)senderId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public int getConnectionsInCommonCount(String id1, String id2) {
        int statusOrdinal = Relationship.Type.CONFIRMED.ordinal();
        StringBuilder queryStringBuilder = new StringBuilder("SELECT count(DISTINCT COMMON_CONNECTIONS.ID) \n");
        queryStringBuilder.append(" FROM \n");
        queryStringBuilder.append(" ( \n");
        queryStringBuilder.append(" SELECT conn1.ID \n");
        queryStringBuilder.append(" FROM  \n");
        queryStringBuilder.append(" ( \n");
        queryStringBuilder.append("   SELECT conn1Rec.RECEIVER_ID AS ID \n");
        queryStringBuilder.append("   FROM SOC_CONNECTIONS as conn1Rec \n");
        queryStringBuilder.append("   WHERE \n");
        queryStringBuilder.append("     conn1Rec.STATUS = ");
        queryStringBuilder.append(statusOrdinal);
        queryStringBuilder.append(" \n");
        queryStringBuilder.append("     AND conn1Rec.SENDER_ID = ");
        queryStringBuilder.append(id1);
        queryStringBuilder.append(" \n");
        queryStringBuilder.append("   UNION \n");
        queryStringBuilder.append("   SELECT conn1Send.SENDER_ID AS ID \n");
        queryStringBuilder.append("   FROM SOC_CONNECTIONS as conn1Send \n");
        queryStringBuilder.append("   WHERE \n");
        queryStringBuilder.append("     conn1Send.STATUS = ");
        queryStringBuilder.append(statusOrdinal);
        queryStringBuilder.append(" \n");
        queryStringBuilder.append("     AND conn1Send.RECEIVER_ID = ");
        queryStringBuilder.append(id1);
        queryStringBuilder.append(" \n");
        queryStringBuilder.append(" ) AS conn1 \n");
        queryStringBuilder.append(" WHERE conn1.ID in \n");
        queryStringBuilder.append("   ( \n");
        queryStringBuilder.append("     SELECT conn2Rec.RECEIVER_ID AS ID \n");
        queryStringBuilder.append("     FROM SOC_CONNECTIONS as conn2Rec \n");
        queryStringBuilder.append("     WHERE \n");
        queryStringBuilder.append("       conn2Rec.STATUS = ");
        queryStringBuilder.append(statusOrdinal);
        queryStringBuilder.append(" \n");
        queryStringBuilder.append("       AND conn2Rec.SENDER_ID = ");
        queryStringBuilder.append(id2);
        queryStringBuilder.append(" \n");
        queryStringBuilder.append("     UNION \n");
        queryStringBuilder.append("     SELECT conn2Send.SENDER_ID AS ID \n");
        queryStringBuilder.append("     FROM SOC_CONNECTIONS as conn2Send \n");
        queryStringBuilder.append("     WHERE \n");
        queryStringBuilder.append("       conn2Send.STATUS = ");
        queryStringBuilder.append(statusOrdinal);
        queryStringBuilder.append(" \n");
        queryStringBuilder.append("       AND conn2Send.RECEIVER_ID = ");
        queryStringBuilder.append(id2);
        queryStringBuilder.append(" \n");
        queryStringBuilder.append("   ) \n");
        queryStringBuilder.append(" ) AS COMMON_CONNECTIONS \n");
        Query query = this.getEntityManager().createNativeQuery(queryStringBuilder.toString());
        BigInteger result = (BigInteger)query.getSingleResult();
        return result == null ? 0 : result.intValue();
    }

    private Query getConnectionsQuery(String identityId, Relationship.Type status, String sortField, String sortDirection) {
        StringBuilder queryStringBuilder = new StringBuilder("SELECT c.* FROM SOC_CONNECTIONS c \n");
        if (StringUtils.isNotBlank((CharSequence)sortField)) {
            queryStringBuilder.append(" LEFT JOIN SOC_IDENTITY_PROPERTIES identity_prop \n");
            queryStringBuilder.append("   ON identity_prop.identity_id <> ").append(identityId).append(" \n");
            queryStringBuilder.append("       AND (identity_prop.identity_id = c.sender_id OR identity_prop.identity_id = c.receiver_id) \n");
            queryStringBuilder.append("       AND identity_prop.name = '").append(sortField).append("' \n");
        }
        switch (status) {
            case ALL: {
                queryStringBuilder.append("WHERE (c.sender_id = ").append(identityId).append(" OR c.receiver_id = ").append(identityId).append(") \n");
                break;
            }
            case CONFIRMED: {
                queryStringBuilder.append("WHERE (c.sender_id =  ").append(identityId).append("  OR c.receiver_id = ").append(identityId).append(") \n");
                queryStringBuilder.append(" AND c.status = ").append(Relationship.Type.CONFIRMED.ordinal()).append(" \n");
                break;
            }
            case PENDING: {
                queryStringBuilder.append("WHERE (c.sender_id = ").append(identityId).append("  OR c.receiver_id = ").append(identityId).append(") \n");
                queryStringBuilder.append(" AND c.status = ").append(Relationship.Type.PENDING.ordinal()).append(" \n");
                break;
            }
            case INCOMING: {
                queryStringBuilder.append("WHERE c.receiver_id = ").append(identityId).append(" \n");
                queryStringBuilder.append(" AND c.status = ").append(Relationship.Type.PENDING.ordinal()).append(" \n");
                break;
            }
            case OUTGOING: {
                queryStringBuilder.append("WHERE c.sender_id = ").append(identityId).append(" \n");
                queryStringBuilder.append(" AND c.status = ").append(Relationship.Type.PENDING.ordinal()).append(" \n");
                break;
            }
            case IGNORED: {
                queryStringBuilder.append("WHERE (c.sender_id = ").append(identityId).append("  OR c.receiver_id = ").append(identityId).append(") \n");
                queryStringBuilder.append(" AND c.status = ").append(Relationship.Type.IGNORED.ordinal()).append(" \n");
                break;
            }
        }
        if (sortField != null) {
            queryStringBuilder.append(" ORDER BY lower(identity_prop.value) ").append(sortDirection);
        }
        return this.getEntityManager().createNativeQuery(queryStringBuilder.toString(), ConnectionEntity.class);
    }

    private Long countSenderId(long receiverId, Relationship.Type status) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.countSenderByReceiverWithoutStatus" : "SocConnection.countSenderByReceiverWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, Long.class);
        query.setParameter("identityId", (Object)receiverId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        return (Long)query.getSingleResult();
    }

    private Long countReceiverId(long sender, Relationship.Type status) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.countReceiverBySenderWithoutStatus" : "SocConnection.countReceiverBySenderWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, Long.class);
        query.setParameter("identityId", (Object)sender);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        return (Long)query.getSingleResult();
    }

    private List<ConnectionEntity> getReceivers(long receiverId, Relationship.Type status, int offset, int limit) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.getReceiverBySenderWithoutStatus" : "SocConnection.getReceiverBySenderWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, ConnectionEntity.class);
        query.setParameter("identityId", (Object)receiverId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List receiversList = query.getResultList();
        return receiversList;
    }

    private List<ConnectionEntity> getSenders(long receiverId, Relationship.Type status, int offset, int limit) {
        EntityManager em = this.getEntityManager();
        String queryName = null;
        queryName = status == null || status == Relationship.Type.ALL ? "SocConnection.getSenderByReceiverWithoutStatus" : "SocConnection.getSenderByReceiverWithStatus";
        TypedQuery query = em.createNamedQuery(queryName, ConnectionEntity.class);
        query.setParameter("identityId", (Object)receiverId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    static {
        ConnectionDAOImpl.ajc$preClinit();
    }

    static /* synthetic */ long count_aroundBody0(ConnectionDAOImpl ajc$this, Identity identity, Relationship.Type status, JoinPoint joinPoint) {
        return (Long)RelationshipQueryBuilder.builder().owner(identity).status(status).buildCount().getSingleResult();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConnectionDAOImpl.java", ConnectionDAOImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "count", "org.exoplatform.social.core.jpa.storage.dao.jpa.ConnectionDAOImpl", "org.exoplatform.social.core.identity.model.Identity:org.exoplatform.social.core.relationship.model.Relationship$Type", "identity:status", "", "long"), 49);
    }
}

