/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.saml;

import java.net.URI;
import java.security.Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.wci.ServletContainerFactory;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusCodeType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2LogOutHandler;

public class PortalSAML2LogOutHandler
extends SAML2LogOutHandler {
    private static final String COOKIE_NAME = "rememberme";
    private static final String OAUTH_COOKIE_NAME = "oauth_rememberme";
    private static final String JSESSIONIDSSO_COOKIE_NAME = "JSESSIONIDSSO";
    private final SPLogOutHandler sp = new SPLogOutHandler();
    private static Log log = ExoLogger.getLogger(PortalSAML2LogOutHandler.class);

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof LogoutRequestType)) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpServletRequest servletRequest = httpContext.getRequest();
        HttpServletResponse servletResponse = httpContext.getResponse();
        super.handleRequestType(request, response);
        if (servletRequest.getSession(false) == null) {
            this.portalLogout(servletRequest, servletResponse);
        }
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof ResponseType) {
            return;
        }
        if (!(request.getSAML2Object() instanceof StatusResponseType)) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpServletRequest servletRequest = httpContext.getRequest();
        HttpServletResponse servletResponse = httpContext.getResponse();
        super.handleStatusResponseType(request, response);
        if (servletRequest.getSession(false) == null) {
            this.portalLogout(servletRequest, servletResponse);
        }
    }

    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getTypeOfRequestToBeGenerated() == null) {
            return;
        }
        if (SAML2HandlerRequest.GENERATE_REQUEST_TYPE.LOGOUT != request.getTypeOfRequestToBeGenerated()) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            super.generateSAMLRequest(request, response);
        } else {
            this.sp.generateSAMLRequest(request, response);
        }
    }

    protected void portalLogout(HttpServletRequest request, HttpServletResponse response) {
        request.getSession(true);
        try {
            if (request.getRemoteUser() != null) {
                ServletContainerFactory.getServletContainer().logout(request, response);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Session has been invalidated but WCI logout failed.", (Throwable)e);
        }
        Cookie cookie = new Cookie(COOKIE_NAME, "");
        cookie.setPath("/");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
        Cookie jsessionIdSSOCookie = new Cookie(JSESSIONIDSSO_COOKIE_NAME, "");
        jsessionIdSSOCookie.setPath("/");
        jsessionIdSSOCookie.setMaxAge(0);
        response.addCookie(jsessionIdSSOCookie);
        Cookie oauthCookie = new Cookie(OAUTH_COOKIE_NAME, "");
        oauthCookie.setPath(request.getContextPath());
        oauthCookie.setMaxAge(0);
        response.addCookie(oauthCookie);
    }

    private SPType getSPConfiguration() {
        return (SPType)this.getProviderconfig();
    }

    Principal getUserPrincipal(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal == null) {
            userPrincipal = (Principal)session.getAttribute("picketlink.principal");
        }
        return userPrincipal;
    }

    private String getIdentityURL(SAML2HandlerRequest request) {
        SPType spConfiguration = this.getSPConfiguration();
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpServletRequest httpServletRequest = httpContext.getRequest();
        String desiredIdP = (String)httpServletRequest.getAttribute("picketlink.desired.idp");
        if (desiredIdP != null) {
            return desiredIdP;
        }
        return spConfiguration.getIdentityURL();
    }

    private class SPLogOutHandler {
        private SPLogOutHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            SAML2Request samlRequest = new SAML2Request();
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpRequest = httpContext.getRequest();
            Principal userPrincipal = PortalSAML2LogOutHandler.this.getUserPrincipal(httpRequest);
            if (userPrincipal == null) {
                return;
            }
            try {
                LogoutRequestType lot = samlRequest.createLogoutRequest(request.getIssuer().getValue());
                NameIDType nameID = new NameIDType();
                nameID.setValue(userPrincipal.getName());
                lot.setNameID(nameID);
                SPType spConfiguration = PortalSAML2LogOutHandler.this.getSPConfiguration();
                String logoutUrl = spConfiguration.getLogoutUrl();
                if (logoutUrl == null) {
                    logoutUrl = PortalSAML2LogOutHandler.this.getIdentityURL(request);
                }
                lot.setDestination(URI.create(logoutUrl));
                response.setDestination(logoutUrl);
                response.setResultingDocument(samlRequest.convert((RequestAbstractType)lot));
                response.setSendRequest(true);
            }
            catch (Exception e) {
                throw logger.processingError((Throwable)e);
            }
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            StatusResponseType statusResponseType = (StatusResponseType)request.getSAML2Object();
            PortalSAML2LogOutHandler.this.checkDestination(statusResponseType.getDestination(), PortalSAML2LogOutHandler.this.getSPConfiguration().getServiceURL());
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest servletRequest = httpContext.getRequest();
            HttpSession session = servletRequest.getSession(false);
            StatusType statusType = statusResponseType.getStatus();
            StatusCodeType statusCode = statusType.getStatusCode();
            URI statusCodeValueURI = statusCode.getValue();
            boolean success = false;
            if (statusCodeValueURI != null) {
                String statusCodeValue = statusCodeValueURI.toString();
                if (JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusCodeValue)) {
                    success = true;
                    session.invalidate();
                }
            }
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            SAML2Object samlObject = request.getSAML2Object();
            if (!(samlObject instanceof LogoutRequestType)) {
                return;
            }
            SPType spConfiguration = PortalSAML2LogOutHandler.this.getSPConfiguration();
            LogoutRequestType logOutRequest = (LogoutRequestType)samlObject;
            PortalSAML2LogOutHandler.this.checkDestination(logOutRequest.getDestination(), spConfiguration.getServiceURL());
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest servletRequest = httpContext.getRequest();
            HttpSession session = servletRequest.getSession(false);
            String relayState = servletRequest.getParameter("RelayState");
            session.invalidate();
            StatusResponseType statusResponse = null;
            try {
                statusResponse = new StatusResponseType(IDGenerator.create((String)"ID_"), XMLTimeUtil.getIssueInstant());
            }
            catch (ConfigurationException e) {
                throw logger.processingError((Throwable)e);
            }
            StatusType statusType = new StatusType();
            StatusCodeType statusCodeType = new StatusCodeType();
            statusCodeType.setValue(URI.create(JBossSAMLURIConstants.STATUS_RESPONDER.get()));
            StatusCodeType status2ndLevel = new StatusCodeType();
            status2ndLevel.setValue(URI.create(JBossSAMLURIConstants.STATUS_SUCCESS.get()));
            statusCodeType.setStatusCode(status2ndLevel);
            statusType.setStatusCode(statusCodeType);
            statusResponse.setStatus(statusType);
            statusResponse.setInResponseTo(logOutRequest.getID());
            statusResponse.setIssuer(request.getIssuer());
            String logoutResponseLocation = spConfiguration.getLogoutResponseLocation();
            if (logoutResponseLocation == null) {
                response.setDestination(logOutRequest.getIssuer().getValue());
            } else {
                response.setDestination(logoutResponseLocation);
            }
            statusResponse.setDestination(response.getDestination());
            SAML2Response saml2Response = new SAML2Response();
            try {
                response.setResultingDocument(saml2Response.convert(statusResponse));
            }
            catch (Exception je) {
                throw logger.processingError((Throwable)je);
            }
            response.setRelayState(relayState);
            response.setDestination(logOutRequest.getIssuer().getValue());
            response.setSendRequest(false);
        }
    }
}

