/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;

@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageBody.gtmpl")
public class UIPageBody
extends UIComponentDecorator {
    private String storageId;
    private String pageName;
    private final Log log = ExoLogger.getLogger(UIPageBody.class);

    public UIPageBody(PageBody model) {
        this.setId("UIPageBody");
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public UIPageBody() {
        this.setId("UIPageBody");
    }

    public void init(PageBody model) {
        this.setId("UIPageBody");
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageBody(UserNode pageNode, UIPortal uiPortal) throws Exception {
        PortalRequestContext context = Util.getPortalRequestContext();
        uiPortal.setMaximizedUIComponent(null);
        UIPage uiPage = this.getUIPage(pageNode, uiPortal, context);
        if (uiPage == null) {
            this.setUIComponent(null);
            return;
        }
        this.setUIComponent((UIComponent)uiPage);
        this.pageName = uiPage.getName();
        if (uiPage.isShowMaxWindow()) {
            context.setShowMaxWindow(true);
        }
        if (uiPage.isHideSharedLayout()) {
            context.setHideSharedLayout(true);
        }
        Util.getUIPortalApplication().setCurrentPage(uiPage);
        if (context.isShowMaxWindow()) {
            uiPortal.setMaximizedUIComponent((UIComponent)uiPage);
        } else {
            UIComponent maximizedComponent = uiPortal.getMaximizedUIComponent();
            if (maximizedComponent instanceof UIPage) {
                uiPortal.setMaximizedUIComponent(null);
            }
        }
    }

    private UIPage getUIPage(UserNode pageNode, UIPortal uiPortal, WebuiRequestContext context) throws Exception {
        PageContext pageContext = null;
        String pageReference = null;
        ExoContainer appContainer = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)appContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        if (pageNode != null && pageNode.getPageRef() != null) {
            pageReference = pageNode.getPageRef().format();
            pageContext = userPortalConfigService.getPage(pageNode.getPageRef());
        }
        if (pageContext == null) {
            uiPortal.clearUIPage(pageReference);
            return null;
        }
        UIPage uiPage = uiPortal.getUIPage(pageReference);
        if (uiPage != null) {
            return uiPage;
        }
        try {
            UIPageFactory clazz = UIPageFactory.getInstance(pageContext.getState().getFactoryId());
            uiPage = clazz.createUIPage(context);
            Page page = userPortalConfigService.getDataStorage().getPage(pageReference);
            pageContext.update(page);
            PortalDataMapper.toUIPage(uiPage, page);
            uiPortal.setUIPage(pageReference, uiPage);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Could not handle page '" + pageContext.getKey().format() + "'."), (Throwable)e);
            }
            throw e;
        }
        return uiPage;
    }
}

