/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.management;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.exoplatform.commons.reflect.AnnotationIntrospector;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.spi.ManagedMethodMetaData;
import org.exoplatform.management.spi.ManagedMethodParameterMetaData;
import org.exoplatform.management.spi.ManagedParameterMetaData;
import org.exoplatform.management.spi.ManagedPropertyMetaData;
import org.exoplatform.management.spi.ManagedTypeMetaData;

public class MetaDataBuilder {
    private Class clazz;
    private boolean buildable;

    public MetaDataBuilder(Class clazz) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("The clazz cannot be null");
        }
        Managed mb = (Managed)AnnotationIntrospector.resolveClassAnnotations((Class)clazz, Managed.class);
        this.clazz = clazz;
        this.buildable = mb != null;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    public ManagedTypeMetaData build() throws IllegalStateException {
        if (!this.buildable) {
            throw new IllegalStateException("Class " + this.clazz.getName() + " does not contain management annotation");
        }
        ManagedDescription typeDescriptionAnn = (ManagedDescription)AnnotationIntrospector.resolveClassAnnotations((Class)this.clazz, ManagedDescription.class);
        String typeDescription = typeDescriptionAnn != null ? typeDescriptionAnn.value() : null;
        Map managedMethods = AnnotationIntrospector.resolveMethodAnnotations((Class)this.clazz, Managed.class);
        Map methodNames = AnnotationIntrospector.resolveMethodAnnotations((Class)this.clazz, ManagedName.class);
        Map methodDescriptions = AnnotationIntrospector.resolveMethodAnnotations((Class)this.clazz, ManagedDescription.class);
        HashMap<Method, ManagedMethodMetaData> bilto = new HashMap<Method, ManagedMethodMetaData>();
        for (Map.Entry entry : managedMethods.entrySet()) {
            Method method = (Method)entry.getKey();
            ManagedDescription methodDescriptionAnn = (ManagedDescription)methodDescriptions.get(method);
            String string = methodDescriptionAnn != null ? methodDescriptionAnn.value() : null;
            Impact impactAnn = method.getAnnotation(Impact.class);
            ImpactType impactType = impactAnn != null ? impactAnn.value() : ImpactType.WRITE;
            ManagedMethodMetaData managedMethod = new ManagedMethodMetaData(method, impactType);
            managedMethod.setDescription(string);
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                ManagedMethodParameterMetaData mmpMD = new ManagedMethodParameterMetaData(i);
                for (Annotation parameterAnnotation : parameterAnnotations[i]) {
                    if (parameterAnnotation instanceof ManagedName) {
                        mmpMD.setName(((ManagedName)parameterAnnotation).value());
                        continue;
                    }
                    if (!(parameterAnnotation instanceof ManagedDescription)) continue;
                    mmpMD.setDescription(((ManagedDescription)parameterAnnotation).value());
                }
                managedMethod.addParameter(mmpMD);
            }
            bilto.put(method, managedMethod);
        }
        ManagedTypeMetaData managedType = new ManagedTypeMetaData(this.clazz);
        managedType.setDescription(typeDescription);
        HashMap<String, ManagedMethodMetaData> setters = new HashMap<String, ManagedMethodMetaData>();
        HashMap getters = new HashMap();
        for (Map.Entry entry : bilto.entrySet()) {
            Method method = (Method)entry.getKey();
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            OperationType type = OperationType.OP;
            Integer index = null;
            if (method.getReturnType() == Void.TYPE) {
                if (parameterTypes.length == 1 && methodName.startsWith("set") && methodName.length() > 4) {
                    type = OperationType.SET;
                    index = 3;
                }
            } else if (parameterTypes.length == 0) {
                type = OperationType.GET;
                if (methodName.startsWith("get") && methodName.length() > 3) {
                    index = 3;
                } else if (methodName.startsWith("is") && methodName.length() > 2) {
                    index = 2;
                }
            }
            if (index != null) {
                String attributeName;
                HashMap<String, ManagedMethodMetaData> map = type == OperationType.SET ? setters : getters;
                ManagedMethodMetaData previous = map.put(attributeName = methodName.substring(index), (ManagedMethodMetaData)entry.getValue());
                if (previous == null) continue;
                throw new IllegalArgumentException("Duplicate attribute " + type + " " + previous + " and " + method);
            }
            ManagedName managedName = (ManagedName)methodNames.get(method);
            if (managedName != null) {
                throw new IllegalArgumentException("Managed operation " + method.getName() + " cannot be annoated with @" + ManagedName.class.getName() + " with value " + managedName.value());
            }
            managedType.addMethod((ManagedMethodMetaData)entry.getValue());
        }
        HashSet attributeNames = new HashSet();
        attributeNames.addAll(getters.keySet());
        attributeNames.addAll(setters.keySet());
        for (String attributeName : attributeNames) {
            ManagedMethodMetaData managedGetter = (ManagedMethodMetaData)getters.get(attributeName);
            ManagedMethodMetaData managedSetter = (ManagedMethodMetaData)setters.get(attributeName);
            String propertyDescription = null;
            ManagedName getterName = null;
            ManagedName setterName = null;
            String getterDescription = null;
            String setterDescription = null;
            Method getter = null;
            Method setter = null;
            ManagedParameterMetaData mpm = null;
            if (managedGetter != null) {
                getter = managedGetter.getMethod();
                getterName = (ManagedName)methodNames.get(getter);
                propertyDescription = getterDescription = managedGetter.getDescription();
            }
            if (managedSetter != null) {
                setter = managedSetter.getMethod();
                setterName = (ManagedName)methodNames.get(setter);
                setterDescription = managedSetter.getDescription();
                if (propertyDescription == null) {
                    propertyDescription = setterDescription;
                }
                mpm = managedSetter.getParameters().iterator().next();
            }
            if (getterName != null) {
                if (setterName != null && !getterName.value().equals(setterName.value())) {
                    throw new IllegalArgumentException("Getter name=" + getterName.value() + " does not match the setter name=" + setterName.value());
                }
                attributeName = getterName.value();
            } else if (setterName != null) {
                attributeName = setterName.value();
            }
            ManagedPropertyMetaData managedProperty = new ManagedPropertyMetaData(attributeName, getter, getterDescription, setter, setterDescription, mpm);
            managedProperty.setDescription(propertyDescription);
            ManagedPropertyMetaData previousManagedProperty = managedType.getProperty(managedProperty.getName());
            if (previousManagedProperty != null) {
                throw new IllegalArgumentException("The same property was declared twice old=" + previousManagedProperty + " new=" + managedProperty);
            }
            managedType.addProperty(managedProperty);
        }
        return managedType;
    }

    private static enum OperationType {
        SET,
        GET,
        OP;

    }
}

