/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.spi.portlet.Portlet;

public class Application<S>
extends ModelObject
implements Cloneable {
    private ApplicationState<S> state;
    private String id;
    private String title;
    private String icon;
    private String description;
    private boolean showInfoBar;
    private boolean showApplicationState = true;
    private boolean showApplicationMode = true;
    private String theme;
    private String width;
    private String height;
    private Properties properties;
    private String[] accessPermissions;
    private boolean isModifiable;
    private final ApplicationType<S> type;

    public Application(ApplicationData<S> data) {
        super(data.getStorageId());
        this.storageName = data.getStorageName();
        this.state = data.getState();
        this.id = data.getId();
        this.title = data.getTitle();
        this.icon = data.getIcon();
        this.description = data.getDescription();
        this.showInfoBar = data.isShowInfoBar();
        this.showApplicationState = data.isShowApplicationState();
        this.showApplicationMode = data.isShowApplicationMode();
        this.theme = data.getTheme();
        this.width = data.getWidth();
        this.height = data.getHeight();
        this.properties = new Properties(data.getProperties());
        this.accessPermissions = data.getAccessPermissions().toArray(new String[data.getAccessPermissions().size()]);
        this.type = data.getType();
    }

    public Application(ApplicationType<S> type, String storageId) {
        super(storageId);
        this.type = type;
    }

    public Application(ApplicationType<S> type) {
        this.type = type;
    }

    public ApplicationType<S> getType() {
        return this.type;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String s) {
        this.width = s;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String s) {
        this.height = s;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    public void setAccessPermissions(String[] accessPermissions) {
        this.accessPermissions = accessPermissions;
    }

    public boolean isModifiable() {
        return this.isModifiable;
    }

    public void setModifiable(boolean modifiable) {
        this.isModifiable = modifiable;
    }

    public ApplicationState<S> getState() {
        return this.state;
    }

    public void setState(ApplicationState<S> value) {
        this.state = value;
    }

    public boolean getShowInfoBar() {
        return this.showInfoBar;
    }

    public void setShowInfoBar(boolean b) {
        this.showInfoBar = b;
    }

    public boolean getShowApplicationState() {
        return this.showApplicationState;
    }

    public void setShowApplicationState(boolean b) {
        this.showApplicationState = b;
    }

    public boolean getShowApplicationMode() {
        return this.showApplicationMode;
    }

    public void setShowApplicationMode(boolean b) {
        this.showApplicationMode = b;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String value) {
        this.icon = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    @Override
    public ApplicationData build() {
        return new ApplicationData<S>(this.storageId, this.storageName, this.getType(), this.state, this.id, this.title, this.icon, this.description, this.showInfoBar, this.showApplicationState, this.showApplicationMode, this.theme, this.width, this.height, Utils.safeImmutableMap(this.properties), Utils.safeImmutableList(this.accessPermissions));
    }

    public static Application<Portlet> createPortletApplication(ApplicationData<Portlet> data) {
        return new Application<Portlet>(data);
    }

    public static Application<Portlet> createPortletApplication(String storageId) {
        return new Application<Portlet>(ApplicationType.PORTLET, storageId);
    }

    public static Application<Portlet> createPortletApplication() {
        return new Application<Portlet>(ApplicationType.PORTLET);
    }

    @Override
    public void resetStorage() {
        if (!(this.state instanceof TransientApplicationState)) {
            try {
                LayoutService dataStorage = (LayoutService)ExoContainerContext.getService(LayoutService.class);
                Portlet preferences = (Portlet)dataStorage.load(this.state, this.type);
                String contentId = dataStorage.getId(this.state);
                if (this.type == ApplicationType.PORTLET) {
                    this.state = new TransientApplicationState<Portlet>(contentId, preferences);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while building transient application state", e);
            }
        }
        super.resetStorage();
    }

    public Application clone() {
        try {
            return (Application)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new Application<S>(this.build());
        }
    }
}

