/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.model;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.model.ProgramDTO;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RuleDTO
implements Serializable {
    private static final long serialVersionUID = 7423093905330790451L;
    protected Long id;
    protected String title;
    protected String description;
    protected int score;
    protected ProgramDTO program;
    protected boolean enabled;
    protected boolean deleted;
    protected String createdBy;
    protected String createdDate;
    protected String lastModifiedBy;
    protected String event;
    protected String lastModifiedDate;
    protected String startDate;
    protected String endDate;
    protected long activityId;
    protected long cacheTime;
    protected Set<Long> prerequisiteRuleIds;
    protected EntityType type;
    protected RecurrenceType recurrence;

    @Deprecated(forRemoval=true, since="1.5.0")
    public long getAudienceId() {
        return this.getSpaceId();
    }

    public long getProgramId() {
        return this.program == null ? 0L : this.program.getId();
    }

    public long getSpaceId() {
        return this.program == null ? 0L : this.program.getSpaceId();
    }

    public Set<Long> getManagers() {
        return this.program == null ? Collections.emptySet() : this.program.getOwnerIds();
    }

    public boolean isOpen() {
        return this.program != null && this.program.isOpen();
    }

    public RuleDTO clone() {
        return new RuleDTO(this.id, this.title, this.description, this.score, this.program, this.enabled, this.deleted, this.createdBy, this.createdDate, this.lastModifiedBy, this.event, this.lastModifiedDate, this.startDate, this.endDate, this.activityId, this.cacheTime, this.prerequisiteRuleIds == null ? null : new HashSet<Long>(this.prerequisiteRuleIds), this.type, this.recurrence);
    }

    public RuleDTO() {
    }

    public RuleDTO(Long id, String title, String description, int score, ProgramDTO program, boolean enabled, boolean deleted, String createdBy, String createdDate, String lastModifiedBy, String event, String lastModifiedDate, String startDate, String endDate, long activityId, long cacheTime, Set<Long> prerequisiteRuleIds, EntityType type, RecurrenceType recurrence) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.score = score;
        this.program = program;
        this.enabled = enabled;
        this.deleted = deleted;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.event = event;
        this.lastModifiedDate = lastModifiedDate;
        this.startDate = startDate;
        this.endDate = endDate;
        this.activityId = activityId;
        this.cacheTime = cacheTime;
        this.prerequisiteRuleIds = prerequisiteRuleIds;
        this.type = type;
        this.recurrence = recurrence;
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getScore() {
        return this.score;
    }

    public ProgramDTO getProgram() {
        return this.program;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public String getEvent() {
        return this.event;
    }

    public String getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public long getActivityId() {
        return this.activityId;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    public Set<Long> getPrerequisiteRuleIds() {
        return this.prerequisiteRuleIds;
    }

    public EntityType getType() {
        return this.type;
    }

    public RecurrenceType getRecurrence() {
        return this.recurrence;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public void setProgram(ProgramDTO program) {
        this.program = program;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setLastModifiedDate(String lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    public void setCacheTime(long cacheTime) {
        this.cacheTime = cacheTime;
    }

    public void setPrerequisiteRuleIds(Set<Long> prerequisiteRuleIds) {
        this.prerequisiteRuleIds = prerequisiteRuleIds;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    public void setRecurrence(RecurrenceType recurrence) {
        this.recurrence = recurrence;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleDTO)) {
            return false;
        }
        RuleDTO other = (RuleDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScore() != other.getScore()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        if (this.getActivityId() != other.getActivityId()) {
            return false;
        }
        if (this.getCacheTime() != other.getCacheTime()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ProgramDTO this$program = this.getProgram();
        ProgramDTO other$program = other.getProgram();
        if (this$program == null ? other$program != null : !((Object)this$program).equals(other$program)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$createdDate = this.getCreatedDate();
        String other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !this$createdDate.equals(other$createdDate)) {
            return false;
        }
        String this$lastModifiedBy = this.getLastModifiedBy();
        String other$lastModifiedBy = other.getLastModifiedBy();
        if (this$lastModifiedBy == null ? other$lastModifiedBy != null : !this$lastModifiedBy.equals(other$lastModifiedBy)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$lastModifiedDate = this.getLastModifiedDate();
        String other$lastModifiedDate = other.getLastModifiedDate();
        if (this$lastModifiedDate == null ? other$lastModifiedDate != null : !this$lastModifiedDate.equals(other$lastModifiedDate)) {
            return false;
        }
        String this$startDate = this.getStartDate();
        String other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        String this$endDate = this.getEndDate();
        String other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
            return false;
        }
        Set<Long> this$prerequisiteRuleIds = this.getPrerequisiteRuleIds();
        Set<Long> other$prerequisiteRuleIds = other.getPrerequisiteRuleIds();
        if (this$prerequisiteRuleIds == null ? other$prerequisiteRuleIds != null : !((Object)this$prerequisiteRuleIds).equals(other$prerequisiteRuleIds)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        RecurrenceType this$recurrence = this.getRecurrence();
        RecurrenceType other$recurrence = other.getRecurrence();
        return !(this$recurrence == null ? other$recurrence != null : !((Object)((Object)this$recurrence)).equals((Object)other$recurrence));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getScore();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        long $activityId = this.getActivityId();
        result = result * 59 + (int)($activityId >>> 32 ^ $activityId);
        long $cacheTime = this.getCacheTime();
        result = result * 59 + (int)($cacheTime >>> 32 ^ $cacheTime);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ProgramDTO $program = this.getProgram();
        result = result * 59 + ($program == null ? 43 : ((Object)$program).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : $createdDate.hashCode());
        String $lastModifiedBy = this.getLastModifiedBy();
        result = result * 59 + ($lastModifiedBy == null ? 43 : $lastModifiedBy.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : $lastModifiedDate.hashCode());
        String $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        String $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        Set<Long> $prerequisiteRuleIds = this.getPrerequisiteRuleIds();
        result = result * 59 + ($prerequisiteRuleIds == null ? 43 : ((Object)$prerequisiteRuleIds).hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        RecurrenceType $recurrence = this.getRecurrence();
        result = result * 59 + ($recurrence == null ? 43 : ((Object)((Object)$recurrence)).hashCode());
        return result;
    }

    public String toString() {
        return "RuleDTO(id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", score=" + this.getScore() + ", program=" + this.getProgram() + ", enabled=" + this.isEnabled() + ", deleted=" + this.isDeleted() + ", createdBy=" + this.getCreatedBy() + ", createdDate=" + this.getCreatedDate() + ", lastModifiedBy=" + this.getLastModifiedBy() + ", event=" + this.getEvent() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", activityId=" + this.getActivityId() + ", cacheTime=" + this.getCacheTime() + ", prerequisiteRuleIds=" + this.getPrerequisiteRuleIds() + ", type=" + this.getType() + ", recurrence=" + this.getRecurrence() + ")";
    }
}

