/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.service;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.collections.MapUtils;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.service.DescriptionService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleManager;

public class DescriptionServiceImpl
implements DescriptionService {
    private DescriptionStorage descriptionStorage;
    private NavigationService navigationService;
    private LocaleConfigService localeConfigService;
    private ResourceBundleManager resourceBundleManager;

    public DescriptionServiceImpl(DescriptionStorage descriptionStorage, NavigationService navigationService, LocaleConfigService localeConfigService, ResourceBundleManager resourceBundleManager) {
        this.descriptionStorage = descriptionStorage;
        this.navigationService = navigationService;
        this.localeConfigService = localeConfigService;
        this.resourceBundleManager = resourceBundleManager;
    }

    public Map<Locale, State> getDescriptions(String nodeId) {
        Map nodeLabels = this.descriptionStorage.getDescriptions(nodeId);
        NodeData nodeData = this.navigationService.getNodeById(Long.valueOf(nodeId));
        if (MapUtils.isEmpty((Map)nodeLabels)) {
            HashMap<Locale, State> nodeLocalizedLabels = new HashMap<Locale, State>();
            this.localeConfigService.getLocalConfigs().forEach(localeConfig -> {
                Locale locale = localeConfig.getLocale();
                String label = nodeData.getState().getLabel();
                if (ExpressionUtil.isResourceBindingExpression((String)label)) {
                    SiteKey siteKey = nodeData.getSiteKey();
                    ResourceBundle nodeLabelResourceBundle = this.resourceBundleManager.getNavigationResourceBundle(this.getLocaleName(locale), siteKey.getTypeName(), siteKey.getName());
                    if (nodeLabelResourceBundle != null) {
                        label = ExpressionUtil.getExpressionValue((ResourceBundle)nodeLabelResourceBundle, (String)label);
                    }
                }
                nodeLocalizedLabels.put(locale, new State(label, null));
            });
            return nodeLocalizedLabels;
        }
        return nodeLabels;
    }

    public void setDescriptions(String id, Map<Locale, State> descriptions) {
        this.descriptionStorage.setDescriptions(id, descriptions);
    }

    private String getLocaleName(Locale locale) {
        return locale.toLanguageTag().replace("-", "_");
    }
}

