/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.search.UserSearchServiceImpl;
import org.exoplatform.social.core.identity.UserFilterListAccess;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SocialUserSearchServiceImpl
extends UserSearchServiceImpl {
    private IdentityStorage identityStorage;
    private OrganizationService organizationService;

    public SocialUserSearchServiceImpl(OrganizationService organizationService, IdentityStorage identityStorage) {
        super(organizationService);
        this.identityStorage = identityStorage;
        this.organizationService = organizationService;
    }

    public ListAccess<User> searchUsers(String term, UserStatus userStatus) throws Exception {
        if (userStatus == UserStatus.DISABLED || userStatus == UserStatus.ANY) {
            return super.searchUsers(term, userStatus);
        }
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setName(term);
        profileFilter.setSearchEmail(true);
        profileFilter.setSorting(new Sorting(Sorting.SortBy.TITLE, Sorting.OrderBy.ASC));
        return new UserFilterListAccess(this.organizationService, this.identityStorage, profileFilter);
    }
}

