/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.jaas.UserPrincipal;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.client.SecurityClient;
import org.jboss.security.client.SecurityClientFactory;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;

public class PicketlinkSTSIntegrationFilter
extends AbstractFilter {
    private static Log log = ExoLogger.getLogger(PicketlinkSTSIntegrationFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getRemoteUser() != null) {
            try {
                SamlCredential samlCredential = this.getSamlCredential();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Found SamlCredential inside Subject: " + String.valueOf(samlCredential)));
                }
                if (samlCredential != null) {
                    SecurityClient client = SecurityClientFactory.getSecurityClient();
                    client.setSimple((Object)new UserPrincipal(httpRequest.getRemoteUser()), (Object)samlCredential);
                    client.login();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"SecurityClient successfully updated with SAMLCredential");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private SamlCredential getSamlCredential() {
        Subject subj = this.getCurrentSubject();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Found subject " + String.valueOf(subj)));
        }
        if (subj == null) {
            return null;
        }
        Set<Object> credentials = subj.getPublicCredentials();
        for (Object credential : credentials) {
            if (!(credential instanceof SamlCredential)) continue;
            return (SamlCredential)credential;
        }
        return null;
    }

    protected Subject getCurrentSubject() {
        SecurityContext securityContext = AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
        return securityContext.getSubjectInfo().getAuthenticatedSubject();
    }
}

