/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.user;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.deprecation.DeprecatedAPIAspect;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.organization.search.UserSearchService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.metadata.thumbnail.ImageThumbnailService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.ErrorResource;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.UserImportResultEntity;
import org.exoplatform.social.rest.api.UserRestResources;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.ExperienceEntity;
import org.exoplatform.social.rest.entity.IMEntity;
import org.exoplatform.social.rest.entity.PhoneEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.exoplatform.social.rest.entity.ProfilePropertySettingEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.entity.URLEntity;
import org.exoplatform.social.rest.entity.UserEntity;
import org.exoplatform.social.rest.impl.activity.ActivityRestResourcesV1;
import org.exoplatform.social.rest.impl.user.UserRestResourcesV1$AjcClosure1;
import org.exoplatform.social.rest.impl.user.UserRestResourcesV1$AjcClosure3;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.json.JSONException;
import org.json.JSONObject;
import org.picocontainer.Startable;

@Path(value="v1/social/users")
@Tag(name="v1/social/users", description="Operations on users with their activities, connections and spaces")
public class UserRestResourcesV1
implements UserRestResources,
Startable {
    public static final String PROFILE_DEFAULT_BANNER_URL = "/skin/images/banner/DefaultUserBanner.png";
    public static final String PROFILE_DEFAULT_AVATAR_URL = "/skin/images/avatar/DefaultUserAvatar.png";
    private static final String ONLINE = "online";
    private static final String INTERNAL = "internal";
    private static final String CONNECTED = "connected";
    private static final CacheControl CACHE_CONTROL;
    private static final Date DEFAULT_IMAGES_LAST_MODIFED;
    private static final long DEFAULT_IMAGES_HASH;
    private static final int CACHE_IN_SECONDS = 259200;
    private static final int CACHE_IN_MILLI_SECONDS = 259200000;
    public static final UserFieldValidator USERNAME_VALIDATOR;
    public static final UserFieldValidator EMAIL_VALIDATOR;
    public static final UserFieldValidator LASTNAME_VALIDATOR;
    public static final UserFieldValidator FIRSTNAME_VALIDATOR;
    public static final UserFieldValidator PASSWORD_VALIDATOR;
    public static final List<UserFieldValidator> USER_FIELD_VALIDATORS;
    private static Map<String, UserImportResultEntity> importUsersProcessing;
    private UserACL userACL;
    private ActivityRestResourcesV1 activityRestResourcesV1;
    private OrganizationService organizationService;
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;
    private UserStateService userStateService;
    private SpaceService spaceService;
    private UserSearchService userSearchService;
    private ImageThumbnailService imageThumbnailService;
    private ProfilePropertyService profilePropertyService;
    private PasswordRecoveryService passwordRecoveryService;
    private LocaleConfigService localeConfigService;
    private static final Log LOG;
    private byte[] defaultUserAvatar = null;
    private byte[] defaultUserBanner = null;
    private UploadService uploadService;
    private ExecutorService importExecutorService = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public UserRestResourcesV1(ActivityRestResourcesV1 activityRestResourcesV1, UserACL userACL, OrganizationService organizationService, IdentityManager identityManager, RelationshipManager relationshipManager, UserStateService userStateService, SpaceService spaceService, UploadService uploadService, UserSearchService userSearchService, ImageThumbnailService imageThumbnailService, ProfilePropertyService profilePropertyService, PasswordRecoveryService passwordRecoveryService, LocaleConfigService localeConfigService) {
        this.userACL = userACL;
        this.activityRestResourcesV1 = activityRestResourcesV1;
        this.organizationService = organizationService;
        this.identityManager = identityManager;
        this.relationshipManager = relationshipManager;
        this.userStateService = userStateService;
        this.spaceService = spaceService;
        this.uploadService = uploadService;
        this.userSearchService = userSearchService;
        this.imageThumbnailService = imageThumbnailService;
        this.profilePropertyService = profilePropertyService;
        this.passwordRecoveryService = passwordRecoveryService;
        this.localeConfigService = localeConfigService;
        this.importExecutorService = Executors.newSingleThreadExecutor();
        CACHE_CONTROL.setMaxAge(259200);
    }

    public void start() {
    }

    public void stop() {
        this.importExecutorService.shutdownNow();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @GET
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets all users", method="GET", description="Using the query param \"q\" to filter the target users, ex: \"q=jo*\" returns all the users beginning by \"jo\".Using the query param \"status\" to filter the target users, ex: \"status=online*\" returns the visible online users.Using the query params \"status\" and \"spaceId\" together to filter the target users, ex: \"status=online*\" and \"spaceId=1*\" returns the visible online users who are member of space with id=1.The params \"status\" and \"spaceId\" cannot be used with \"q\" param since it will falsify the \"limit\" param which is 20 by default. If these 3 parameters are used together, the parameter \"q\" will be ignored,the current user \"excludeCurrentUser\" will be excluded")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getUsers(@Context UriInfo uriInfo, @Parameter(description="User name information to filter, ex: user name, last name, first name or full name") @QueryParam(value="q") String q, @Parameter(description="Is search with email") @QueryParam(value="searchEmail") boolean searchEmail, @Parameter(description="Is search with username") @QueryParam(value="searchUsername") boolean searchUsername, @Parameter(description="User status to filter online users, ex: online") @QueryParam(value="status") String status, @Parameter(description="User type to filter, ex: internal, external") @DefaultValue(value="internal") @QueryParam(value="userType") String userType, @Parameter(description="Is connected users") @QueryParam(value="isConnected") String isConnected, @Parameter(description="Space id to filter only its members, ex: 1") @QueryParam(value="spaceId") String spaceId, @Parameter(description="Is disabled users") @Schema(defaultValue="false") @QueryParam(value="isDisabled") boolean isDisabled, @Parameter(description="Enrollment status, ex: enrolled, not enrolled, no possible enrollment") @QueryParam(value="enrollmentStatus") String enrollmentStatus, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of users found or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource if any") @QueryParam(value="expand") String expand, @Parameter(description="the current user will be excluded in the list") @Schema(defaultValue="false") @QueryParam(value="excludeCurrentUser") boolean excludeCurrentUser) throws Exception {
        org.exoplatform.social.core.identity.model.Identity[] identities;
        String userId;
        try {
            userId = ConversationState.getCurrent().getIdentity().getUserId();
        }
        catch (Exception e) {
            return Response.status((int)401).build();
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Response.status((int)401).build();
        }
        if (!(this.userACL.getSuperUser().equals(userId) || RestUtils.isMemberOfAdminGroup() || RestUtils.isMemberOfDelegatedGroup() || userType == null || userType.equals(INTERNAL))) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        int totalSize = 0;
        if (StringUtils.isNotBlank((CharSequence)status) && ONLINE.equals(status)) {
            Space space = null;
            if (StringUtils.isNotBlank((CharSequence)spaceId)) {
                space = this.spaceService.getSpaceById(spaceId);
                if (space == null) return EntityBuilder.getResponse(new ErrorResource("space " + spaceId + " does not exist", "space not found"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.NOT_FOUND);
                identities = RestUtils.getOnlineIdentitiesOfSpace(this.userStateService, userId, space, limit);
            } else {
                identities = RestUtils.getOnlineIdentities(this.userStateService, userId, limit);
            }
        } else {
            org.exoplatform.social.core.identity.model.Identity target = this.identityManager.getOrCreateIdentity("organization", userId);
            org.exoplatform.social.core.identity.model.Identity[] filter = new ProfileFilter();
            filter.setName(q == null || q.isEmpty() ? "" : q);
            filter.setSearchEmail(searchEmail);
            filter.setSearchUserName(searchUsername);
            filter.setEnabled(!isDisabled);
            if (target != null && excludeCurrentUser) {
                filter.setExcludedIdentityList(Collections.singletonList(target));
            }
            if (!isDisabled) {
                filter.setUserType(userType);
                filter.setConnected(isConnected != null ? Boolean.valueOf(isConnected.equals(CONNECTED)) : null);
                filter.setEnrollmentStatus(enrollmentStatus);
            }
            if (RestUtils.isMemberOfDelegatedGroup() && !RestUtils.isMemberOfAdminGroup() && userType != null && !userType.equals(INTERNAL)) {
                int limitToFetch;
                Query query = new Query();
                if (q != null && !q.isEmpty()) {
                    query.setUserName(q);
                }
                ListAccess usersListAccess = null;
                List groupIds = this.organizationService.getMembershipHandler().findMembershipsByUser(userId).stream().filter(x -> x.getMembershipType().equals("manager") && !x.getGroupId().equals("/platform/delegated") && !x.getGroupId().startsWith("/spaces/")).map(Membership::getGroupId).collect(Collectors.toList());
                if (groupIds.size() > 0) {
                    usersListAccess = this.organizationService.getUserHandler().findUsersByQuery(query, groupIds, isDisabled ? UserStatus.DISABLED : UserStatus.ENABLED);
                }
                if ((totalSize = usersListAccess.getSize()) < offset + (limitToFetch = limit)) {
                    limitToFetch = totalSize - offset;
                }
                User[] users = limitToFetch <= 0 ? new User[]{} : (User[])usersListAccess.load(offset, limitToFetch);
                identities = (org.exoplatform.social.core.identity.model.Identity[])Arrays.stream(users).map(user -> this.identityManager.getOrCreateIdentity("organization", user.getUserName())).toArray(org.exoplatform.social.core.identity.model.Identity[]::new);
            } else if (isDisabled && q != null && !q.isEmpty()) {
                int limitToFetch;
                ListAccess usersListAccess = this.userSearchService.searchUsers(q, UserStatus.DISABLED);
                totalSize = usersListAccess.getSize();
                if (totalSize < offset + (limitToFetch = limit)) {
                    limitToFetch = totalSize - offset;
                }
                User[] users = limitToFetch <= 0 ? new User[]{} : (User[])usersListAccess.load(offset, limitToFetch);
                identities = (org.exoplatform.social.core.identity.model.Identity[])Arrays.stream(users).map(user -> this.identityManager.getOrCreateIdentity("organization", user.getUserName())).toArray(org.exoplatform.social.core.identity.model.Identity[]::new);
            } else {
                ListAccess list = this.identityManager.getIdentitiesByProfileFilter("organization", (ProfileFilter)filter, true);
                identities = (org.exoplatform.social.core.identity.model.Identity[])list.load(offset, limit);
                if (returnSize) {
                    totalSize = list.getSize();
                }
            }
        }
        ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
        for (org.exoplatform.social.core.identity.model.Identity identity : identities) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            profileInfos.add(profileInfo.getDataEntity());
        }
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (!returnSize) return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        collectionUser.setSize(totalSize);
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/advancedfilter")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets all users or connections by advanced filter", method="POST", description="")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getUsersOrConnectionsByAdvancedFilter(@Context UriInfo uriInfo, @Parameter(description="User type to filter, ex: internal, external") @DefaultValue(value="internal") @QueryParam(value="userType") String userType, @Parameter(description="Filter type to filter , ex all , connection") @DefaultValue(value="all") @QueryParam(value="filterType") String filterType, @Parameter(description="Is disabled users") @Schema(defaultValue="false") @QueryParam(value="isDisabled") boolean isDisabled, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of users found or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource if any") @QueryParam(value="expand") String expand, @RequestBody(description="pam user settings profile", required=true) Map<String, String> settings, @Parameter(description="User name information to filter, ex: user name, last name, first name or full name") @QueryParam(value="q") String q, @Parameter(description="Whether to search for exact word or words containing it") @QueryParam(value="wildCardSearch") String wildcardSearch) throws Exception {
        String userId;
        try {
            userId = ConversationState.getCurrent().getIdentity().getUserId();
        }
        catch (Exception e) {
            return Response.status((int)401).build();
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Response.status((int)401).build();
        }
        try {
            org.exoplatform.social.core.identity.model.Identity target = this.identityManager.getOrCreateIdentity("organization", userId);
            if (target == null) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (!(this.userACL.getSuperUser().equals(userId) || RestUtils.isMemberOfAdminGroup() || RestUtils.isMemberOfDelegatedGroup() || userType == null || userType.equals(INTERNAL))) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
            limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
            int totalSize = 0;
            ProfileFilter filter = new ProfileFilter();
            filter.setName(q == null || q.isEmpty() ? "" : q);
            if (filterType.equals("all")) {
                filter.setEnabled(!isDisabled);
                if (!isDisabled) {
                    filter.setUserType(userType);
                }
            }
            if (settings != null) {
                filter.setExcludedIdentityList(Collections.singletonList(target));
                settings.replaceAll((key, value) -> value.trim());
            }
            filter.setProfileSettings(settings);
            if (StringUtils.isNotBlank((CharSequence)wildcardSearch)) {
                filter.setWildcardSearch(Boolean.parseBoolean(wildcardSearch));
            }
            ListAccess list = filterType.equals("all") ? this.identityManager.getIdentitiesByProfileFilter("organization", filter, true) : this.relationshipManager.getConnectionsByFilter(target, filter);
            org.exoplatform.social.core.identity.model.Identity[] identities = (org.exoplatform.social.core.identity.model.Identity[])list.load(offset, limit);
            if (returnSize) {
                totalSize = list.getSize();
            }
            ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
            for (org.exoplatform.social.core.identity.model.Identity identity : identities) {
                if (identity == null) continue;
                ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
                profileInfos.add(profileInfo.getDataEntity());
            }
            CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
            if (returnSize) {
                collectionUser.setSize(totalSize);
            }
            return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to get users or connections with advanced filter", (Throwable)e);
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @Override
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a new user", method="POST", description="This creates the user if the authenticated user is in the /platform/administrators group.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response addUser(@Context UriInfo uriInfo, @Parameter(description="Asking for a full representation of a specific subresource if any") @QueryParam(value="expand") String expand, @RequestBody(description="User object to be created, ex:<br />{<br />\"username\": \"john\",<br />\"password\": \"gtngtn\",<br />\"email\": \"john@exoplatform.com\",<br />\"firstname\": \"John\",<br />\"lastname\": \"Smith\"<br />}", required=true) UserEntity model) throws Exception {
        if (model.isNotValid()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (!RestUtils.isMemberOfAdminGroup()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", model.getUsername());
        if (identity != null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (this.isEmailAlreadyExists(model.getUsername(), model.getEmail())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        UserHandler userHandler = this.organizationService.getUserHandler();
        User user = userHandler.createUserInstance(model.getUsername());
        user.setFirstName(model.getFirstname());
        user.setLastName(model.getLastname());
        user.setEmail(model.getEmail());
        user.setPassword(model.getPassword() == null || model.getPassword().isEmpty() ? "exo" : model.getPassword());
        userHandler.createUser(user, true);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(model.getUsername(), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets a specific user by user name", method="GET", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getUserById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="User name", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource if any") @QueryParam(value="expand") String expand) throws Exception {
        long cacheTime;
        String eTagValue;
        EntityTag eTag;
        Response.ResponseBuilder builder;
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", id);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        String expandedSettings = expand;
        if (expand != null && expand.contains("settings")) {
            expandedSettings = String.valueOf(Objects.hash(EntityBuilder.buildEntityProfilePropertySettingList(this.profilePropertyService.getPropertySettings().stream().filter(prop -> prop.isVisible() || prop.isEditable()).toList(), this.profilePropertyService, "profileProperty")));
        }
        if ((builder = request.evaluatePreconditions(eTag = new EntityTag(eTagValue = String.valueOf(Objects.hash(cacheTime = identity.getCacheTime(), authenticatedUser, expandedSettings)), true))) == null) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            builder = Response.ok((Object)profileInfo.getDataEntity(), (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="email/{email}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific user by user email", method="GET", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getUserByEmail(@Context UriInfo uriInfo, @Parameter(description="User email", required=true) @PathParam(value="email") String email) throws JSONException {
        User user = this.getUserByEmail(email);
        if (user == null) {
            return Response.ok().entity((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"{\"id\":\"null\"}"})).build();
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", user.getUserName());
        JSONObject jsonProfile = new JSONObject();
        jsonProfile.put("avatarUrl", (Object)identity.getProfile().getAvatarUrl());
        jsonProfile.put("fullName", (Object)identity.getProfile().getFullName());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)identity.toString());
        jsonObject.put("profile", (Object)jsonProfile);
        jsonObject.put("providerId", (Object)identity.getProviderId());
        jsonObject.put("remoteId", (Object)identity.getRemoteId());
        return Response.ok((Object)jsonObject.toString()).build();
    }

    @GET
    @Path(value="{id}/avatar")
    @Operation(summary="Gets a specific user avatar by username", method="GET", description="The user avatar will be returned only if there is a currently authenticated user or an anonymous user that has a valid token generated by a Server encryption key.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getUserAvatarById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="User name", required=true) @PathParam(value="id") String id, @Parameter(description="Whether to retrieve avatar by identity id or username", required=true) @DefaultValue(value="false") @QueryParam(value="byId") boolean byId, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @Parameter(description="Resized avatar size. Use 0x0 for original size.") @DefaultValue(value="45x45") @QueryParam(value="size") String size, @Parameter(description="A mandatory valid token that is used to authorize anonymous request") @QueryParam(value="r") String token) throws IOException {
        boolean isDefault = StringUtils.equals((CharSequence)"default-image", (CharSequence)id);
        org.exoplatform.social.core.identity.model.Identity identity = null;
        Long lastUpdated = null;
        Response.ResponseBuilder builder = null;
        if (isDefault) {
            lastUpdated = DEFAULT_IMAGES_LAST_MODIFED.getTime();
        } else {
            org.exoplatform.social.core.identity.model.Identity identity2 = identity = byId ? this.identityManager.getIdentity(id) : this.identityManager.getOrCreateUserIdentity(id);
            if (identity == null || !identity.isUser()) {
                LOG.debug("Identity of user {} is not found, thus no avatar will be returned", new Object[]{id});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Profile profile = identity.getProfile();
            if (profile != null) {
                lastUpdated = profile.getAvatarLastUpdated();
            }
        }
        EntityTag eTag = null;
        if (isDefault) {
            eTag = new EntityTag(String.valueOf(DEFAULT_IMAGES_HASH));
        } else if (lastUpdated != null) {
            eTag = new EntityTag(lastUpdated + "-" + size);
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null) {
            if (isDefault || lastUpdated == null) {
                builder = this.getDefaultAvatarBuilder();
            } else {
                if (RestUtils.isAnonymous() && !LinkProvider.isAttachmentTokenValid((String)token, (String)"organization", (String)id, (String)"avatar", (String)lastModified)) {
                    LOG.warn("An anonymous user attempts to access avatar of user {} without a valid access token", new Object[]{id});
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                if (identity.isEnable() && !identity.isDeleted()) {
                    int[] dimension = Utils.parseDimension((String)size);
                    byte[] avatarContent = null;
                    try {
                        if (this.identityManager.getAvatarFile(identity) != null) {
                            avatarContent = this.imageThumbnailService.getOrCreateThumbnail(this.identityManager.getAvatarFile(identity), identity, dimension[0], dimension[1]).getAsByte();
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Error while resizing avatar of user identity with Id {}, original Image will be returned", new Object[]{identity.getId(), e});
                    }
                    if (avatarContent != null) {
                        builder = Response.ok(avatarContent, (String)"image/png");
                    }
                }
            }
        }
        if (builder == null) {
            InputStream stream = this.identityManager.getAvatarInputStream(identity);
            builder = Response.ok((Object)stream, (String)"image/png");
        }
        builder.lastModified(lastUpdated == null ? DEFAULT_IMAGES_LAST_MODIFED : new Date(lastUpdated));
        if (eTag != null) {
            builder.tag(eTag);
        }
        builder.cacheControl(CACHE_CONTROL);
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 259200000L));
        }
        return builder.build();
    }

    @GET
    @Path(value="{id}/banner")
    @Operation(summary="Gets a specific user banner by username", method="GET", description="The user avatar will be returned only if there is a currently authenticated user or an anonymous user that has a valid token generated by a Server encryption key.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getUserBannerById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="User name", required=true) @PathParam(value="id") String id, @Parameter(description="Whether to retrieve banner by identity id or username", required=true) @DefaultValue(value="false") @QueryParam(value="byId") boolean byId, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @Parameter(description="A mandatory valid token that is used to authorize anonymous request") @QueryParam(value="r") String token) throws IOException {
        boolean isDefault = StringUtils.equals((CharSequence)"default-image", (CharSequence)id);
        org.exoplatform.social.core.identity.model.Identity identity = null;
        Long lastUpdated = null;
        Response.ResponseBuilder builder = null;
        if (isDefault) {
            lastUpdated = DEFAULT_IMAGES_LAST_MODIFED.getTime();
        } else {
            org.exoplatform.social.core.identity.model.Identity identity2 = identity = byId ? this.identityManager.getIdentity(id) : this.identityManager.getOrCreateUserIdentity(id);
            if (identity == null || !identity.isUser()) {
                LOG.debug("Identity of user {} is not found, thus no banner will be returned", new Object[]{id});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Profile profile = identity.getProfile();
            if (profile != null) {
                lastUpdated = profile.getBannerLastUpdated();
            }
        }
        EntityTag eTag = null;
        if (isDefault) {
            eTag = new EntityTag(String.valueOf(DEFAULT_IMAGES_HASH));
        } else if (lastUpdated != null) {
            eTag = new EntityTag(String.valueOf(lastUpdated));
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null) {
            if (isDefault) {
                builder = this.getDefaultBannerBuilder();
            } else {
                if (RestUtils.isAnonymous() && !LinkProvider.isAttachmentTokenValid((String)token, (String)"organization", (String)id, (String)"banner", (String)lastModified)) {
                    LOG.warn("An anonymous user attempts to access banner of user {} without a valid access token", new Object[]{id});
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                if (identity.isEnable() && !identity.isDeleted()) {
                    InputStream stream = this.identityManager.getBannerInputStream(identity);
                    if (stream != null) {
                        builder = Response.ok((Object)stream, (String)"image/png");
                        builder.lastModified(lastUpdated == null ? DEFAULT_IMAGES_LAST_MODIFED : new Date(lastUpdated));
                        if (eTag != null) {
                            builder.tag(eTag);
                        }
                    } else {
                        builder = this.getDefaultBannerBuilder();
                    }
                } else {
                    builder = this.getDefaultBannerBuilder();
                }
            }
        }
        builder.cacheControl(CACHE_CONTROL);
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 259200000L));
        }
        return builder.build();
    }

    @PATCH
    @Path(value="{id}")
    @Operation(summary="Update user property", method="PATCH", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled but not content returned"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding"), @ApiResponse(responseCode="403", description="Unothorized to modify user profile"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateUserProfileAttribute(@Context HttpServletRequest request, @Parameter(description="User name", required=true) @PathParam(value="id") String username, @Parameter(description="User profile attribute name", required=true) @FormParam(value="name") String name, @Parameter(description="User profile attribute value", required=true) @FormParam(value="value") String value) throws IOException {
        if (StringUtils.isBlank((CharSequence)name)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'name' parameter is mandatory").build();
        }
        if (value == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'value' parameter is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'username' path parameter is empty").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        if (!StringUtils.equals((CharSequence)currentUser, (CharSequence)username) && !RestUtils.isMemberOfAdminGroup()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Locale locale = request == null ? Locale.ENGLISH : request.getLocale();
        org.exoplatform.social.core.identity.model.Identity userIdentity = RestUtils.getUserIdentity(username);
        Profile profile = userIdentity.getProfile();
        try {
            String errorMessage;
            String fieldName = ProfileEntity.getFieldName(name);
            if ("firstName".equals(fieldName) && StringUtils.isNotBlank((CharSequence)(errorMessage = FIRSTNAME_VALIDATOR.validate(locale, value)))) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("FIRSTNAME:" + errorMessage)).build();
            }
            if ("lastName".equals(fieldName) && StringUtils.isNotBlank((CharSequence)(errorMessage = LASTNAME_VALIDATOR.validate(locale, value)))) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("LASTNAME:" + errorMessage)).build();
            }
            if ("email".equals(fieldName)) {
                errorMessage = EMAIL_VALIDATOR.validate(locale, value);
                if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("EMAIL:" + errorMessage)).build();
                }
                Query query = new Query();
                query.setEmail(value);
                ListAccess users = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
                int usersLength = users.getSize();
                if (usersLength > 1 || usersLength == 1 && !StringUtils.equals((CharSequence)((User[])users.load(0, 1))[0].getUserName(), (CharSequence)username)) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"EMAIL:ALREADY_EXISTS").build();
                }
            }
            if (value.equals("DEFAULT_BANNER")) {
                profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.BANNER));
                profile.setBannerUrl("DEFAULT_BANNER");
                profile.removeProperty(name);
                this.identityManager.updateProfile(profile, RestUtils.getCurrentUser(), true);
            } else {
                this.updateProfileField(profile, fieldName, value, true);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("User {} is not allowed to update attribute {}", new Object[]{currentUser, name});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (IdentityStorageException e) {
            return Response.serverError().entity((Object)e.getMessageKey()).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)("Can't update Banner, error = " + e.getMessage())).build();
        }
        return Response.noContent().build();
    }

    @PATCH
    @Path(value="{id}/profile")
    @Operation(summary="Update set of properties in user profile", method="PATCH", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled but not content returned"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding"), @ApiResponse(responseCode="403", description="Unothorized to modify user profile"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateUserProfileAttributes(@Context HttpServletRequest request, @Parameter(description="User name", required=true) @PathParam(value="id") String username, @RequestBody(description="User profile attributes map", required=true) ProfileEntity profileEntity) throws Exception {
        String errorMessage;
        if (StringUtils.isBlank((CharSequence)username)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'username' path parameter is empty").build();
        }
        if (profileEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Use profile entity is mandatory").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        if (!StringUtils.equals((CharSequence)currentUser, (CharSequence)username) && !RestUtils.isMemberOfAdminGroup()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Locale locale = request == null ? Locale.ENGLISH : request.getLocale();
        String firstName = profileEntity.getFirstname();
        String lastName = profileEntity.getLastname();
        String email = profileEntity.getEmail();
        if (firstName != null && StringUtils.isNotBlank((CharSequence)(errorMessage = FIRSTNAME_VALIDATOR.validate(locale, firstName)))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("FIRSTNAME:" + errorMessage)).build();
        }
        if (lastName != null && StringUtils.isNotBlank((CharSequence)(errorMessage = LASTNAME_VALIDATOR.validate(locale, lastName)))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("LASTNAME:" + errorMessage)).build();
        }
        if (email != null) {
            errorMessage = EMAIL_VALIDATOR.validate(locale, email);
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("EMAIL:" + errorMessage)).build();
            }
            if (this.isEmailAlreadyExists(username, email)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"EMAIL:ALREADY_EXISTS").build();
            }
        }
        try {
            Map<String, Object> userProfileProperties = this.extractPropertiesFromEntities(profileEntity);
            this.saveProfile(username, userProfileProperties);
        }
        catch (IllegalAccessException e) {
            LOG.error("User {} is not allowed to update attributes", new Object[]{currentUser});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error("Error updating user {} attributes", new Object[]{currentUser, e});
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    private Map<String, Object> extractPropertiesFromEntities(ProfileEntity profileEntity) {
        HashMap<String, Object> userProfileProperties = new HashMap<String, Object>();
        for (String key : profileEntity.getDataEntity().keySet()) {
            if (profileEntity.getDataEntity().get(key) instanceof List) {
                ArrayList properties = new ArrayList();
                if (key.equalsIgnoreCase("ims")) {
                    List imsEntities = (List)profileEntity.getDataEntity().get(key);
                    for (IMEntity im : imsEntities) {
                        HashMap<String, String> imMap = new HashMap<String, String>();
                        imMap.put(im.getImType(), im.getImId());
                        properties.add(imMap);
                    }
                } else if (key.equalsIgnoreCase("phones")) {
                    List phoneEntities = (List)profileEntity.getDataEntity().get(key);
                    for (PhoneEntity phoneEntity : phoneEntities) {
                        HashMap<String, String> phoneMap = new HashMap<String, String>();
                        phoneMap.put(phoneEntity.getPhoneType(), phoneEntity.getPhoneNumber());
                        properties.add(phoneMap);
                    }
                } else if (key.equalsIgnoreCase("urls")) {
                    List urlEntities = (List)profileEntity.getDataEntity().get(key);
                    for (URLEntity url : urlEntities) {
                        HashMap<String, String> urlMap = new HashMap<String, String>();
                        urlMap.put(url.getUrl(), url.getUrl());
                        properties.add(urlMap);
                    }
                } else if (key.equalsIgnoreCase("experiences")) {
                    List experienceEntities = (List)profileEntity.getDataEntity().get(key);
                    for (ExperienceEntity experienceEntity : experienceEntities) {
                        HashMap<String, String> experienceMap = new HashMap<String, String>();
                        if (StringUtils.isNotBlank((CharSequence)experienceEntity.getId())) {
                            experienceMap.put("id", experienceEntity.getId());
                        }
                        experienceMap.put("company", experienceEntity.getCompany());
                        experienceMap.put("description", experienceEntity.getDescription());
                        experienceMap.put("skills", experienceEntity.getSkills());
                        experienceMap.put("startDate", experienceEntity.getStartDate());
                        experienceMap.put("endDate", experienceEntity.getEndDate());
                        experienceMap.put("position", experienceEntity.getPosition());
                        experienceMap.put("isCurrent", String.valueOf(experienceEntity.getIsCurrent()));
                        properties.add(experienceMap);
                    }
                }
                userProfileProperties.put(key, properties);
                continue;
            }
            userProfileProperties.put(key, profileEntity.getDataEntity().get(key));
        }
        return userProfileProperties;
    }

    @PATCH
    @Path(value="{id}/profile/properties")
    @Operation(summary="Update set of properties in user profile", method="PATCH", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled but not content returned"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding"), @ApiResponse(responseCode="403", description="Unothorized to modify user profile"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateUserProfileAttributes(@Context HttpServletRequest request, @Parameter(description="User name", required=true) @PathParam(value="id") String username, @RequestBody(description="User profile attributes map", required=true) List<ProfilePropertySettingEntity> profilePropertySettingEntities) throws Exception {
        if (StringUtils.isBlank((CharSequence)username)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'username' path parameter is empty").build();
        }
        if (profilePropertySettingEntities == null || profilePropertySettingEntities.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Use profile properties are mandatory").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        if (!StringUtils.equals((CharSequence)currentUser, (CharSequence)username) && !RestUtils.isMemberOfAdminGroup()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Locale locale = request == null ? Locale.ENGLISH : request.getLocale();
        org.exoplatform.social.core.identity.model.Identity userIdentity = RestUtils.getUserIdentity(username);
        Profile profile = userIdentity.getProfile();
        for (ProfilePropertySettingEntity profileProperty : profilePropertySettingEntities) {
            String errorMessage;
            if (profileProperty.getPropertyName().equals("firstName") && StringUtils.isNotBlank((CharSequence)(errorMessage = FIRSTNAME_VALIDATOR.validate(locale, profileProperty.getValue())))) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("FIRSTNAME:" + errorMessage)).build();
            }
            if (profileProperty.getPropertyName().equals("lastName") && StringUtils.isNotBlank((CharSequence)(errorMessage = LASTNAME_VALIDATOR.validate(locale, profileProperty.getValue())))) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("LASTNAME:" + errorMessage)).build();
            }
            if (profileProperty.getPropertyName().equals("email")) {
                errorMessage = EMAIL_VALIDATOR.validate(locale, profileProperty.getValue());
                if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("EMAIL:" + errorMessage)).build();
                }
                if (this.isEmailAlreadyExists(username, profileProperty.getValue())) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"EMAIL:ALREADY_EXISTS").build();
                }
            }
            try {
                if (!profileProperty.isMultiValued() && profileProperty.getChildren().isEmpty()) {
                    this.updateProfileField(profile, profileProperty.getPropertyName(), profileProperty.getValue(), false);
                    continue;
                }
                ArrayList maps = new ArrayList();
                profileProperty.getChildren().forEach(profilePropertySettingEntity -> {
                    if (profilePropertySettingEntity.getValue() != null && !profilePropertySettingEntity.getValue().isBlank() && (profilePropertySettingEntity.getPropertyName() != null && !profilePropertySettingEntity.getPropertyName().isBlank() || profileProperty.isMultiValued())) {
                        HashMap<String, String> childrenMap = new HashMap<String, String>();
                        if (profilePropertySettingEntity.getPropertyName() != null) {
                            childrenMap.put("key", profilePropertySettingEntity.getPropertyName());
                        }
                        childrenMap.put("value", profilePropertySettingEntity.getValue());
                        maps.add(childrenMap);
                    }
                });
                this.updateProfileField(profile, profileProperty.getPropertyName(), maps, false);
            }
            catch (IllegalAccessException e) {
                LOG.error("User {} is not allowed to update attributes", new Object[]{currentUser});
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            catch (Exception e) {
                LOG.error("Error updating user {} attributes", new Object[]{currentUser, e});
                return Response.serverError().build();
            }
        }
        this.identityManager.updateProfile(profile, RestUtils.getCurrentUser(), true);
        return Response.ok().build();
    }

    @Override
    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a specific user by user name", method="DELETE", description="This deletes the user if the authenticated user is in the /platform/administrators group.")
    public Response deleteUserById(@Context UriInfo uriInfo, @Parameter(description="User name", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource if any") @QueryParam(value="expand") String expand) throws Exception {
        if (!RestUtils.isMemberOfAdminGroup()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", id);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.identityManager.hardDeleteIdentity(identity);
        identity.setDeleted(true);
        UserHandler userHandler = this.organizationService.getUserHandler();
        userHandler.removeUser(id, false);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific user by user name", method="PUT", description="This updates the user if he is the authenticated user.")
    public Response updateUserById(@Context UriInfo uriInfo, @Parameter(description="User name", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource if any") @QueryParam(value="expand") String expand, @RequestBody(description="User object to be updated, ex:<br />{<br />\"username\": \"john\",<br />\"password\": \"gtngtn\",<br />\"email\": \"john@exoplatform.com\",<br />\"firstname\": \"John\",<br />\"lastname\": \"Smith\"<br />}", required=true) UserEntity model) throws Exception {
        UserHandler userHandler = this.organizationService.getUserHandler();
        User user = userHandler.findUserByName(id);
        if (user == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!ConversationState.getCurrent().getIdentity().getUserId().equals(id)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (this.isEmailAlreadyExists(user.getUserName(), user.getEmail())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        this.fillUserFromModel(user, model);
        userHandler.saveUser(user, true);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(id, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @PATCH
    @Path(value="onboard/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Send onBoarding email to a specific user", method="PATCH", description="This send onBoarding email to a specific user.")
    public Response sendOnBoardingEmail(@Context HttpServletRequest request, @Parameter(description="User name", required=true) @PathParam(value="id") String id) throws Exception {
        if (!RestUtils.isMemberOfAdminGroup() && !RestUtils.isMemberOfDelegatedGroup()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        UserHandler userHandler = this.organizationService.getUserHandler();
        User user = userHandler.findUserByName(id);
        if (user == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        StringBuilder url = this.getUrl(request);
        this.sendOnBoardingEmail((UserImpl)user, url);
        return Response.ok().build();
    }

    @PATCH
    @Path(value="bulk/{action}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Make action on list of users", method="PATCH", description="This will realize the action on the list of users if possible")
    public Response bulk(@Context HttpServletRequest request, @Parameter(description="Action", required=true) @PathParam(value="action") String action, @Parameter(description="User List", required=true) List<String> users) throws Exception {
        if (!RestUtils.isMemberOfAdminGroup() && !RestUtils.isMemberOfDelegatedGroup()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ArrayList<String> updatedUsers = new ArrayList<String>();
        switch (action) {
            case "onboard": {
                StringBuilder url = this.getUrl(request);
                for (String username : users) {
                    UserHandler userHandler = this.organizationService.getUserHandler();
                    User user = userHandler.findUserByName(username);
                    if (user == null) {
                        LOG.warn("Cannot find user by username {} for onboarding, he is disabled or not existing", new Object[]{username});
                        continue;
                    }
                    org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", username);
                    if (identity == null) {
                        LOG.warn("Cannot find identity by username {} for onboarding, he is disabled or not existing", new Object[]{username});
                        continue;
                    }
                    if (Util.isExternal(identity.getId())) {
                        LOG.warn("User {} is external, he cannot be enrolled.", new Object[]{username});
                        continue;
                    }
                    if (!user.getLastLoginTime().equals(user.getCreatedDate())) {
                        LOG.warn("User {} is already logged in, he cannot be enrolled", new Object[]{username});
                        continue;
                    }
                    this.sendOnBoardingEmail((UserImpl)user, url);
                    updatedUsers.add(username);
                }
                break;
            }
            case "enable": {
                for (String username : users) {
                    UserHandler userHandler = this.organizationService.getUserHandler();
                    User user = userHandler.findUserByName(username, UserStatus.DISABLED);
                    if (user == null) {
                        LOG.warn("Username {} is not found in disabled user list. He does not exists, or he is already enabled", new Object[]{username});
                        continue;
                    }
                    this.organizationService.getUserHandler().setEnabled(username, true, true);
                    updatedUsers.add(username);
                }
                break;
            }
            case "disable": {
                for (String username : users) {
                    UserHandler userHandler = this.organizationService.getUserHandler();
                    User user = userHandler.findUserByName(username, UserStatus.ENABLED);
                    if (user == null) {
                        LOG.warn("Username {} is not found in enabled user list. He does not exists, or he is already disabled", new Object[]{username});
                        continue;
                    }
                    String currentUsername = ConversationState.getCurrent().getIdentity().getUserId();
                    if (StringUtils.equals((CharSequence)currentUsername, (CharSequence)user.getUserName())) {
                        LOG.warn("User {} tries to suspend his own account. Not allowed", new Object[]{currentUsername});
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)this.userACL.getSuperUser(), (CharSequence)user.getUserName())) {
                        LOG.warn("Try to suspend superuser account {}. Not allowed", new Object[]{username});
                        continue;
                    }
                    this.organizationService.getUserHandler().setEnabled(username, false, true);
                    updatedUsers.add(username);
                }
                break;
            }
        }
        return Response.ok(updatedUsers).build();
    }

    @Override
    @GET
    @Path(value="{id}/connections")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets connections of a specific user", method="GET", description="This can only be done by the logged in user.")
    public Response getConnectionsOfUser(@Context UriInfo uriInfo, @Parameter(description="User name", required=true) @PathParam(value="id") String id, @Parameter(description="User name information to filter, ex: user name, last name, first name or full name", required=false) @QueryParam(value="q") String q, @Parameter(description="Returning the number of connections or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        org.exoplatform.social.core.identity.model.Identity[] identities;
        org.exoplatform.social.core.identity.model.Identity target = this.identityManager.getOrCreateIdentity("organization", id);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        int limit = RestUtils.getLimit(uriInfo);
        int offset = RestUtils.getOffset(uriInfo);
        ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setName(q);
        ListAccess listAccess = this.relationshipManager.getConnectionsByFilter(target, profileFilter);
        for (org.exoplatform.social.core.identity.model.Identity identity : identities = (org.exoplatform.social.core.identity.model.Identity[])listAccess.load(offset, limit)) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            profileInfos.add(profileInfo.getDataEntity());
        }
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="connections/invitations")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets received invitations of current user", method="GET", description="This can only be done by the logged in user.")
    public Response getInvitationsOfUser(@Context UriInfo uriInfo, @Parameter(description="Returning the number of connections or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        org.exoplatform.social.core.identity.model.Identity[] identities;
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity target = this.identityManager.getOrCreateIdentity("organization", currentUser);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        int limit = RestUtils.getLimit(uriInfo);
        int offset = RestUtils.getOffset(uriInfo);
        ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
        ListAccess listAccess = this.relationshipManager.getIncomingWithListAccess(target);
        for (org.exoplatform.social.core.identity.model.Identity identity : identities = (org.exoplatform.social.core.identity.model.Identity[])listAccess.load(offset, limit)) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            profileInfos.add(profileInfo.getDataEntity());
        }
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="connections/pending")
    @Operation(summary="Gets received invitations of current user", method="GET", description="This can only be done by the logged in user.")
    public Response getPendingOfUser(@Context UriInfo uriInfo, @Parameter(description="Returning the number of connections or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        org.exoplatform.social.core.identity.model.Identity[] identities;
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity target = this.identityManager.getOrCreateIdentity("organization", currentUser);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        int limit = RestUtils.getLimit(uriInfo);
        int offset = RestUtils.getOffset(uriInfo);
        ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
        ListAccess listAccess = this.relationshipManager.getOutgoing(target);
        for (org.exoplatform.social.core.identity.model.Identity identity : identities = (org.exoplatform.social.core.identity.model.Identity[])listAccess.load(offset, limit)) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            profileInfos.add(profileInfo.getDataEntity());
        }
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/spaces")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets spaces of a specific user", method="GET", description="This returns a list of spaces in the following cases: <br/><ul><li>the given user is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    public Response getSpacesOfUser(@Context UriInfo uriInfo, @Parameter(description="User name", required=true) @PathParam(value="id") String id, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of spaces or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource, ex: <em>members</em> or <em>managers</em>") @QueryParam(value="expand") String expand) throws Exception {
        org.exoplatform.social.core.identity.model.Identity userIdentity;
        org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity;
        Relationship relationship;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        org.exoplatform.social.core.identity.model.Identity target = this.identityManager.getOrCreateIdentity("organization", id);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!(this.userACL.getSuperUser().equals(authenticatedUser) || authenticatedUser.equals(id) || (relationship = this.relationshipManager.get(authenticatedUserIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser), userIdentity = this.identityManager.getOrCreateIdentity("organization", id))) != null && relationship.getStatus() == Relationship.Type.CONFIRMED)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ArrayList<DataEntity> spaceInfos = new ArrayList<DataEntity>();
        ListAccess listAccess = this.spaceService.getMemberSpaces(id);
        for (Relationship space : (Relationship)listAccess.load(offset, limit)) {
            SpaceEntity spaceInfo = EntityBuilder.buildEntityFromSpace((Space)space, id, uriInfo.getPath(), expand);
            spaceInfos.add(spaceInfo.getDataEntity());
        }
        CollectionEntity collectionSpace = new CollectionEntity(spaceInfos, "spaces", offset, limit);
        if (returnSize) {
            collectionSpace.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionSpace, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{userId}/spaces/{profileId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets commons spaces of current user", method="GET", description="This returns a list of commons spaces in the following cases: <br/><ul><li>the given user is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    public Response getCommonSpacesOfUser(@Context UriInfo uriInfo, @Parameter(description="User Id", required=true) @PathParam(value="userId") String userId, @Parameter(description="Profile Id", required=true) @PathParam(value="profileId") String profileId, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of spaces or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource, ex: <em>members</em> or <em>managers</em>") @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", userId);
        org.exoplatform.social.core.identity.model.Identity userProfile = this.identityManager.getOrCreateIdentity("organization", profileId);
        if (currentUser == null || userProfile == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.userACL.getSuperUser().equals(authenticatedUser) && !authenticatedUser.equals(userId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ListAccess commonSpacesAccessList = this.spaceService.getCommonSpaces(userId, profileId);
        List commonSpaceInfos = Arrays.stream((Space[])commonSpacesAccessList.load(offset, limit)).map(space -> EntityBuilder.buildEntityFromSpace(space, userId, uriInfo.getPath(), expand).getDataEntity()).collect(Collectors.toList());
        CollectionEntity collectionSpace = new CollectionEntity(commonSpaceInfos, "spaces", offset, limit);
        if (returnSize) {
            collectionSpace.setSize(commonSpacesAccessList.getSize());
        }
        return EntityBuilder.getResponse(collectionSpace, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @POST
    @Path(value="{id}/activities")
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates an activity by a specific user", method="POST", description="This creates the activity if the given user is the authenticated user.")
    @Deprecated
    @DeprecatedAPI(value="Use ActivityRestResourcesV1.postActivity instead", insist=true)
    public Response addActivityByUser(@Context UriInfo uriInfo, @Parameter(description="User name", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource, ex: <em>comments</em> or <em>likes</em>") @QueryParam(value="expand") String expand, @RequestBody(description="Activity object to be created, in which the title of activity is required, ex: <br/>{\"title\": \"act4 posted\"}", required=true) ActivityEntity model) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        String string2 = expand;
        ActivityEntity activityEntity = model;
        Object[] objectArray = new Object[]{uriInfo2, string, string2, activityEntity};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, activityEntity, joinPoint};
        UserRestResourcesV1$AjcClosure1 userRestResourcesV1$AjcClosure1 = new UserRestResourcesV1$AjcClosure1(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(userRestResourcesV1$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @GET
    @Path(value="{id}/activities")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets activities of a specific user", method="GET", description="This returns an activity in the list in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user or one of his connections</li><li>this is a space activity and the authenticated user is a member of the space</li></ul>")
    @Deprecated
    @DeprecatedAPI(value="Use ActivityRestResourcesV1.getActivities instead", insist=true)
    public Response getActivitiesOfUser(@Context UriInfo uriInfo, @Parameter(description="User name", required=true) @PathParam(value="id") String id, @Parameter(description="Activity stream type, ex: <em>owner, connections, spaces</em> or <em>all</em>") @Schema(defaultValue="all") @QueryParam(value="type") String type, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Base time to load older activities (yyyy-MM-dd HH:mm:ss)") @QueryParam(value="before") String before, @Parameter(description="Base time to load newer activities (yyyy-MM-dd HH:mm:ss)") @QueryParam(value="after") String after, @Parameter(description="Returning the number of activities or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource, ex: <em>comments</em> or <em>likes</em>") @QueryParam(value="expand") String expand) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        String string2 = type;
        int n = offset;
        int n2 = limit;
        String string3 = before;
        String string4 = after;
        boolean bl = returnSize;
        String string5 = expand;
        Object[] objectArray = new Object[]{uriInfo2, string, string2, Conversions.intObject((int)n), Conversions.intObject((int)n2), string3, string4, Conversions.booleanObject((boolean)bl), string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, Conversions.intObject((int)n), Conversions.intObject((int)n2), string3, string4, Conversions.booleanObject((boolean)bl), string5, joinPoint};
        UserRestResourcesV1$AjcClosure3 userRestResourcesV1$AjcClosure3 = new UserRestResourcesV1$AjcClosure3(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(userRestResourcesV1$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="csv")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Import users using CSV file", description="Import users using CSV file that has a header defining user fields names.exemple of first line of CSV file: userName,firstName,lastName,password,email,groups,aboutMe,timeZone,company,position", method="POST")
    public Response importUsers(@Context HttpServletRequest request, @Parameter(description="CSV File uploadId retrieved after uploading", required=true) @FormParam(value="uploadId") String uploadId, @Parameter(description="Get processing progress percentage of imported file") @Schema(defaultValue="false") @FormParam(value="progress") boolean progress, @Parameter(description="Whether clean file after processing or not") @Schema(defaultValue="false") @FormParam(value="clean") boolean clean, @Parameter(description="Whether process importing users in a sync or async way of current request") @Schema(defaultValue="false") @FormParam(value="sync") boolean sync) {
        if (StringUtils.isBlank((CharSequence)uploadId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"UPLOAD_ID:MANDATORY").build();
        }
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"UPLOAD_ID:NOT_FOUND").build();
        }
        UserImportResultEntity existingImportResult = importUsersProcessing.get(uploadId);
        if (clean || progress) {
            if (existingImportResult == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"UPLOAD_ID_PROGRESS:NOT_FOUND").build();
            }
            if (clean) {
                this.uploadService.removeUploadResource(uploadId);
                importUsersProcessing.remove(uploadId);
            }
            return Response.ok((Object)existingImportResult.clone()).build();
        }
        if (existingImportResult != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"UPLOAD_ID_PROCESSING:ALREADY_PROCESSING").build();
        }
        Locale locale = request == null ? Locale.ENGLISH : request.getLocale();
        StringBuilder url = this.getUrl(request);
        Response errorResponse = this.importUsers(uploadId, uploadResource.getStoreLocation(), locale, url, sync);
        return errorResponse == null ? Response.noContent().build() : errorResponse;
    }

    private Response importUsers(String uploadId, String fileLocation, Locale locale, StringBuilder url, boolean sync) {
        UserImportResultEntity userImportResultEntity = new UserImportResultEntity();
        importUsersProcessing.put(uploadId, userImportResultEntity);
        try (BufferedReader reader = new BufferedReader(new FileReader(fileLocation));){
            userImportResultEntity.setCount(reader.lines().count() - 1L);
        }
        catch (FileNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"UPLOAD_ID_FILE:NOT_FOUND").build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"ERROR_READING_FILE").build();
        }
        if (userImportResultEntity.getCount() < 1L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"BAD_FORMAT:FILE_EMPTY").build();
        }
        if (sync) {
            this.importUsers(fileLocation, userImportResultEntity, locale, url);
        } else {
            this.importUsersAsync(fileLocation, userImportResultEntity, locale, url, ConversationState.getCurrent());
        }
        return null;
    }

    private void importUsersAsync(String fileLocation, UserImportResultEntity userImportResultEntity, Locale locale, StringBuilder url, ConversationState currentState) {
        this.importExecutorService.execute(() -> {
            ConversationState.setCurrent((ConversationState)currentState);
            this.importUsers(fileLocation, userImportResultEntity, locale, url);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importUsers(String fileLocation, UserImportResultEntity userImportResultEntity, Locale locale, StringBuilder url) {
        try (BufferedReader reader = new BufferedReader(new FileReader(fileLocation));){
            String headerLine = null;
            headerLine = reader.readLine();
            if (StringUtils.isBlank((CharSequence)headerLine)) {
                return;
            }
            ArrayList<String> fields = new ArrayList<String>(Arrays.stream(headerLine.split(",")).map(String::trim).toList());
            List<String> standardFields = List.of("userName", "password", "groups", "aboutMe", "timeZone", "enabled");
            List<String> systemParentAndMultivaluedFields = Arrays.asList("user", "phones", "ims", "urls");
            ArrayList<String> unauthorizedFields = new ArrayList<String>();
            ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                for (String field : fields) {
                    if (standardFields.contains(field)) continue;
                    if (!field.contains(".")) {
                        ProfilePropertySetting propertySetting = this.profilePropertyService.getProfileSettingByName(field);
                        if (propertySetting == null) {
                            userImportResultEntity.addWarnMessage("ALL", "PROFILE_PROPERTY_DOES_NOT_EXIST:" + field);
                            unauthorizedFields.add(field);
                            continue;
                        }
                        if (this.profilePropertyService.hasChildProperties(propertySetting)) {
                            userImportResultEntity.addWarnMessage("ALL", "PARENT_PROPERTY_SHOULD_NOT_HAVE_VALUES:" + field);
                            unauthorizedFields.add(field);
                            continue;
                        }
                        if (!propertySetting.isMultiValued() || systemParentAndMultivaluedFields.contains(field)) continue;
                        userImportResultEntity.addWarnMessage("ALL", "CUSTOM_FIELD_MULTIVALUED:" + field);
                        unauthorizedFields.add(field);
                        continue;
                    }
                    String[] fieldNames = field.split("\\.");
                    ProfilePropertySetting parentProperty = this.profilePropertyService.getProfileSettingByName(fieldNames[0]);
                    if (fieldNames.length > 2) {
                        userImportResultEntity.addWarnMessage("ALL", "PROPERTY_HAS_MORE_THAN_ONE_PARENT:" + field);
                        unauthorizedFields.add(field);
                        continue;
                    }
                    if (parentProperty == null) {
                        userImportResultEntity.addWarnMessage("ALL", "PROPERTY_HAS_MISSING_PARENT_PROPERTY:" + field);
                        unauthorizedFields.add(field);
                        continue;
                    }
                    if (!parentProperty.isMultiValued() || systemParentAndMultivaluedFields.contains(parentProperty.getPropertyName())) continue;
                    userImportResultEntity.addWarnMessage("ALL", "CUSTOM_PARENT_FIELD:" + field);
                    unauthorizedFields.add(field);
                }
            }
            finally {
                RequestLifeCycle.end();
            }
            String userCSVLine = reader.readLine();
            while (userCSVLine != null) {
                block27: {
                    ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
                    RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                    String userName = null;
                    try {
                        userImportResultEntity.incrementProcessed();
                        if (StringUtils.isBlank((CharSequence)userCSVLine)) {
                            userCSVLine = reader.readLine();
                            continue;
                        }
                        userName = this.importUser(userImportResultEntity, locale, url, fields, unauthorizedFields, userCSVLine);
                    }
                    catch (Throwable e) {
                        LOG.warn("Error importing user data {}", new Object[]{userName, e});
                        if (!StringUtils.isNotBlank((CharSequence)userName)) break block27;
                        userImportResultEntity.addErrorMessage(userName, "CREATE_USER_ERROR:" + e.getMessage());
                    }
                    finally {
                        RequestLifeCycle.end();
                        continue;
                    }
                }
                userCSVLine = reader.readLine();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while importing CSV file", (Throwable)e);
        }
    }

    private String importUser(UserImportResultEntity userImportResultEntity, Locale locale, StringBuilder url, List<String> fields, List<String> fieldsToRemove, String userCSVLine) throws Exception {
        List<String> userProperties = Arrays.asList(userCSVLine.split(","));
        JSONObject userObject = new JSONObject();
        for (int i = 0; i < fields.size(); ++i) {
            if (i >= userProperties.size()) continue;
            userObject.put(fields.get(i), (Object)userProperties.get(i));
        }
        UserImpl user = EntityBuilder.fromJsonString(userObject.toString(), UserImpl.class);
        String userName = user.getUserName();
        if (StringUtils.isBlank((CharSequence)userName)) {
            userImportResultEntity.addErrorMessage(userName, "BAD_LINE_FORMAT:MISSING_USERNAME");
            return userName;
        }
        if (userProperties.size() < fields.size()) {
            userImportResultEntity.addErrorMessage(userName, "BAD_LINE_FORMAT");
            return userName;
        }
        Object errorMessage = null;
        try {
            errorMessage = this.validateUser(userObject, locale);
        }
        catch (Exception e) {
            errorMessage = "USER_VALIDATION_ERROR:" + e.getMessage();
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            userImportResultEntity.addErrorMessage(userName, (String)errorMessage);
            return userName;
        }
        boolean onboardUser = !userObject.isNull("onboardUser") && userObject.getString("onboardUser").equals("true");
        boolean userStatus = !userObject.isNull("enabled") && ("true".equalsIgnoreCase(userObject.getString("enabled")) || "false".equalsIgnoreCase(userObject.getString("enabled")));
        User existingUser = this.organizationService.getUserHandler().findUserByName(userName, UserStatus.ANY);
        if (existingUser != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping password update for: {}", new Object[]{userName});
            }
            user.setPassword(null);
            if (userStatus) {
                this.organizationService.getUserHandler().setEnabled(userName, Boolean.parseBoolean(userObject.getString("enabled")), true);
                user.setEnabled(Boolean.valueOf(true));
            }
            this.organizationService.getUserHandler().saveUser((User)user, true);
            onboardUser = onboardUser && existingUser.isEnabled() && existingUser.getLastLoginTime().getTime() == existingUser.getCreatedDate().getTime();
        } else {
            if (this.isEmailAlreadyExists(user.getUserName(), user.getEmail())) {
                userImportResultEntity.addErrorMessage(userName, "EMAIL:ALREADY_EXISTS");
                return userName;
            }
            try {
                this.organizationService.getUserHandler().createUser((User)user, true);
            }
            catch (Exception e) {
                LOG.warn("Error importing user {}", new Object[]{userName, e});
                userImportResultEntity.addErrorMessage(userName, "CREATE_USER_ERROR:" + e.getMessage());
                return userName;
            }
        }
        if (!userObject.isNull("groups")) {
            String groups = userObject.getString("groups");
            if (StringUtils.isNotBlank((CharSequence)groups)) {
                String[] groupsList;
                for (String groupMembershipExpression : groupsList = groups.split(";")) {
                    String groupId;
                    String membershipType = groupMembershipExpression.contains(":") ? StringUtils.trim((String)groupMembershipExpression.split(":")[0]) : "member";
                    String string = groupId = groupMembershipExpression.contains(":") ? StringUtils.trim((String)groupMembershipExpression.split(":")[1]) : groupMembershipExpression;
                    if (groupId.equals("/platform/externals")) continue;
                    Group groupObject = this.organizationService.getGroupHandler().findGroupById(groupId);
                    if (groupObject == null) {
                        userImportResultEntity.addWarnMessage(userName, "GROUP_NOT_EXISTS:" + groupId);
                        continue;
                    }
                    MembershipType membershipTypeObject = this.organizationService.getMembershipTypeHandler().findMembershipType(membershipType);
                    if (membershipTypeObject == null) {
                        userImportResultEntity.addWarnMessage(userName, "MEMBERSHIP_TYPE_NOT_EXISTS:" + membershipType);
                        continue;
                    }
                    try {
                        this.organizationService.getMembershipHandler().linkMembership((User)user, groupObject, membershipTypeObject, true);
                    }
                    catch (Exception e) {
                        userImportResultEntity.addWarnMessage(userName, "IMPORT_MEMBERSHIP_ERROR:" + e.getMessage());
                    }
                }
            } else {
                userImportResultEntity.addWarnMessage(userName, "GROUP_NOT_EXISTS:");
            }
        }
        if (onboardUser) {
            this.sendOnBoardingEmail(user, url);
        }
        if (userStatus) {
            this.organizationService.getUserHandler().setEnabled(userName, Boolean.parseBoolean(userObject.getString("enabled")), true);
        }
        userObject.remove("userName");
        userObject.remove("firstName");
        userObject.remove("lastName");
        userObject.remove("password");
        userObject.remove("email");
        userObject.remove("groups");
        userObject.remove("enabled");
        fieldsToRemove.forEach(arg_0 -> ((JSONObject)userObject).remove(arg_0));
        HashMap<String, Object> userProfileProperties = new HashMap<String, Object>();
        Iterator properties = userObject.keys();
        while (properties.hasNext()) {
            ArrayList values;
            ProfilePropertySetting propertySetting;
            String propertyName = (String)properties.next();
            String propertyValue = userObject.getString(propertyName);
            ProfilePropertySetting parentPropertySetting = null;
            if (propertyName.contains(".")) {
                String[] propertyNames = propertyName.split("\\.");
                String childProperty = propertyNames[1];
                propertySetting = this.profilePropertyService.getProfileSettingByName(propertyName) != null ? this.profilePropertyService.getProfileSettingByName(propertyName) : this.profilePropertyService.getProfileSettingByName(childProperty);
            } else {
                propertySetting = this.profilePropertyService.getProfileSettingByName(propertyName);
            }
            if (propertySetting != null && propertySetting.getParentId() != null) {
                parentPropertySetting = this.profilePropertyService.getProfileSettingById(propertySetting.getParentId());
            }
            HashMap<String, String> childPropertyMap = new HashMap<String, String>();
            childPropertyMap.put("value", propertyValue);
            if (propertySetting != null && propertySetting.isMultiValued()) {
                userProfileProperties.computeIfAbsent(propertySetting.getPropertyName(), k -> new ArrayList());
                values = (ArrayList)userProfileProperties.get(propertySetting.getPropertyName());
                values.add(childPropertyMap);
                userProfileProperties.put(propertySetting.getPropertyName(), values);
                continue;
            }
            if (parentPropertySetting != null) {
                childPropertyMap.put("key", propertySetting.getPropertyName());
                userProfileProperties.computeIfAbsent(parentPropertySetting.getPropertyName(), k -> new ArrayList());
                values = (ArrayList)userProfileProperties.get(parentPropertySetting.getPropertyName());
                values.add(childPropertyMap);
                userProfileProperties.put(parentPropertySetting.getPropertyName(), values);
                continue;
            }
            userProfileProperties.put(propertyName, propertyValue);
        }
        Object warnMessage = null;
        try {
            this.saveProfile(userName, userProfileProperties);
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User Identity profile {} wasn't found, ignore processing", new Object[]{userName});
        }
        catch (IdentityStorageException e) {
            LOG.warn("Error saving user profile {}", new Object[]{userName, e});
            warnMessage = e.getMessageKey();
        }
        catch (Exception e) {
            LOG.warn("Error saving user profile {}", new Object[]{userName, e});
            warnMessage = "CREATE_USER_PROFILE_ERROR:" + e.getMessage();
        }
        if (warnMessage != null) {
            userImportResultEntity.addWarnMessage(userName, (String)warnMessage);
        }
        return userName;
    }

    private String validateUser(JSONObject userObject, Locale locale) throws Exception {
        String errorMessage = null;
        Iterator<UserFieldValidator> iterator = USER_FIELD_VALIDATORS.iterator();
        while (iterator.hasNext() && errorMessage == null) {
            UserFieldValidator userFieldValidator = iterator.next();
            String fieldName = userFieldValidator.getField();
            String fieldValue = userObject.getString(fieldName);
            errorMessage = userFieldValidator.validate(locale, fieldValue);
        }
        return errorMessage;
    }

    private boolean isEmailAlreadyExists(String username, String email) throws Exception {
        Query query = new Query();
        query.setEmail(email);
        ListAccess users = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
        int usersLength = users.getSize();
        return usersLength > 1 || usersLength == 1 && !StringUtils.equals((CharSequence)((User[])users.load(0, 1))[0].getUserName(), (CharSequence)username);
    }

    private void saveProfile(String username, Map<String, Object> profileProperties) throws Exception {
        org.exoplatform.social.core.identity.model.Identity userIdentity = RestUtils.getUserIdentity(username);
        if (userIdentity == null) {
            throw new ObjectNotFoundException("User identity of " + username + " wasn't found. It can be due to a disabled user.");
        }
        Profile profile = userIdentity.getProfile();
        Set<Map.Entry<String, Object>> profileEntries = profileProperties.entrySet();
        for (Map.Entry<String, Object> entry : profileEntries) {
            String name = entry.getKey();
            Object value = entry.getValue();
            String fieldName = ProfileEntity.getFieldName(name);
            this.updateProfileField(profile, fieldName, value, false);
        }
        this.identityManager.updateProfile(profile, RestUtils.getCurrentUser(), true);
    }

    private void fillUserFromModel(User user, UserEntity model) {
        if (model.getFirstname() != null && !model.getFirstname().isEmpty()) {
            user.setFirstName(model.getFirstname());
        }
        if (model.getLastname() != null && !model.getLastname().isEmpty()) {
            user.setLastName(model.getLastname());
        }
        if (model.getEmail() != null && !model.getEmail().isEmpty()) {
            user.setEmail(model.getEmail());
        }
        if (model.getPassword() != null && !model.getPassword().isEmpty()) {
            user.setPassword(model.getPassword());
        }
    }

    private User getUserByEmail(String email) {
        if (email == null) {
            return null;
        }
        try {
            Query query = new Query();
            query.setEmail(email);
            User[] users = (User[])this.organizationService.getUserHandler().findUsersByQuery(query).load(0, 10);
            return users[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    private Response.ResponseBuilder getDefaultAvatarBuilder() throws IOException {
        if (this.defaultUserAvatar == null) {
            InputStream is = PortalContainer.getInstance().getPortalContext().getResourceAsStream(PROFILE_DEFAULT_AVATAR_URL);
            if (is == null) {
                LOG.warn("Can't find default user avatar file in location {}", new Object[]{PROFILE_DEFAULT_AVATAR_URL});
                this.defaultUserAvatar = new byte[0];
            } else {
                this.defaultUserAvatar = IOUtil.getStreamContentAsBytes((InputStream)is);
            }
        }
        Response.ResponseBuilder builder = Response.ok((Object)new ByteArrayInputStream(this.defaultUserAvatar), (String)"image/png");
        builder.lastModified(DEFAULT_IMAGES_LAST_MODIFED);
        EntityTag eTag = new EntityTag(String.valueOf(DEFAULT_IMAGES_HASH));
        builder.tag(eTag);
        return builder;
    }

    private Response.ResponseBuilder getDefaultBannerBuilder() throws IOException {
        if (this.defaultUserBanner == null) {
            InputStream is = PortalContainer.getInstance().getPortalContext().getResourceAsStream(PROFILE_DEFAULT_BANNER_URL);
            if (is == null) {
                LOG.warn("Can't find default user banner file in location {}", new Object[]{PROFILE_DEFAULT_BANNER_URL});
                this.defaultUserBanner = new byte[0];
            } else {
                this.defaultUserBanner = IOUtil.getStreamContentAsBytes((InputStream)is);
            }
        }
        Response.ResponseBuilder builder = Response.ok((Object)new ByteArrayInputStream(this.defaultUserBanner), (String)"image/png");
        builder.lastModified(DEFAULT_IMAGES_LAST_MODIFED);
        EntityTag eTag = new EntityTag(String.valueOf(DEFAULT_IMAGES_HASH));
        builder.tag(eTag);
        return builder;
    }

    private void sendOnBoardingEmail(UserImpl user, StringBuilder url) throws Exception {
        Locale locale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
        boolean onBoardingEmailSent = this.passwordRecoveryService.sendOnboardingEmail((User)user, locale, url);
        if (onBoardingEmailSent) {
            org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", user.getUserName());
            Profile profile = userIdentity.getProfile();
            this.updateProfileField(profile, "enrollmentDate", String.valueOf(Calendar.getInstance().getTimeInMillis()), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateProfileField(Profile profile, String name, Object value, boolean save) throws Exception {
        if ("external".equals(name)) {
            throw new IllegalAccessException("Not allowed to update EXTERNAL field");
        }
        if ("username".equals(name)) {
            throw new IllegalAccessException("Not allowed to update USERNAME field");
        }
        if ("avatar".equals(name) || "banner".equals(name)) {
            UploadResource uploadResource = this.uploadService.getUploadResource(value.toString());
            if (uploadResource == null) {
                throw new IllegalStateException("No uploaded resource found with uploadId = " + String.valueOf(value));
            }
            String storeLocation = uploadResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(storeLocation);){
                AvatarAttachment attachment = null;
                if ("avatar".equals(name)) {
                    attachment = new AvatarAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.AVATAR));
                } else {
                    attachment = new BannerAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.BANNER));
                }
                profile.setProperty(name, (Object)attachment);
                if (!save) return;
                this.identityManager.updateProfile(profile, RestUtils.getCurrentUser(), true);
                return;
            }
            finally {
                this.uploadService.removeUploadResource(value.toString());
            }
        } else {
            profile.setProperty(name, value);
            if (!save) return;
            this.identityManager.updateProfile(profile, RestUtils.getCurrentUser(), true);
        }
    }

    private StringBuilder getUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        if (request != null) {
            url.append(request.getScheme()).append("://").append(request.getServerName());
            if (request.getServerPort() != 80 && request.getServerPort() != 443) {
                url.append(':').append(request.getServerPort());
            }
            PortalContainer container = PortalContainer.getCurrentInstance((ServletContext)request.getServletContext());
            url.append(container.getPortalContext().getContextPath());
        }
        return url;
    }

    static {
        UserRestResourcesV1.ajc$preClinit();
        CACHE_CONTROL = new CacheControl();
        DEFAULT_IMAGES_LAST_MODIFED = new Date();
        DEFAULT_IMAGES_HASH = DEFAULT_IMAGES_LAST_MODIFED.getTime();
        USERNAME_VALIDATOR = new UserFieldValidator("userName", true, false);
        EMAIL_VALIDATOR = new UserFieldValidator("email", false, false);
        LASTNAME_VALIDATOR = new UserFieldValidator("lastName", false, true);
        FIRSTNAME_VALIDATOR = new UserFieldValidator("firstName", false, true);
        PASSWORD_VALIDATOR = new UserFieldValidator("password", false, false, 8, 255);
        USER_FIELD_VALIDATORS = Arrays.asList(USERNAME_VALIDATOR, EMAIL_VALIDATOR, LASTNAME_VALIDATOR, FIRSTNAME_VALIDATOR, PASSWORD_VALIDATOR);
        importUsersProcessing = new HashMap<String, UserImportResultEntity>();
        LOG = ExoLogger.getLogger(UserRestResourcesV1.class);
    }

    static /* synthetic */ Response addActivityByUser_aroundBody0(UserRestResourcesV1 ajc$this, UriInfo uriInfo, String id, String expand, ActivityEntity model, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.postActivity(uriInfo, null, expand, model);
    }

    static /* synthetic */ Response getActivitiesOfUser_aroundBody2(UserRestResourcesV1 ajc$this, UriInfo uriInfo, String id, String type, int offset, int limit, String before, String after, boolean returnSize, String expand, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.getActivities(uriInfo, null, before, after, offset, limit, returnSize, expand, null);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserRestResourcesV1.java", UserRestResourcesV1.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addActivityByUser", "org.exoplatform.social.rest.impl.user.UserRestResourcesV1", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String:org.exoplatform.social.rest.entity.ActivityEntity", "uriInfo:id:expand:model", "java.lang.Exception", "javax.ws.rs.core.Response"), 1511);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActivitiesOfUser", "org.exoplatform.social.rest.impl.user.UserRestResourcesV1", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String:int:int:java.lang.String:java.lang.String:boolean:java.lang.String", "uriInfo:id:type:offset:limit:before:after:returnSize:expand", "java.lang.Exception", "javax.ws.rs.core.Response"), 1534);
    }
}

