/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.script.BaseScriptResource;
import org.gatein.portal.controller.resource.script.FetchMode;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptGraph;
import org.gatein.portal.controller.resource.script.ScriptGroup;

public class ScriptResource
extends BaseScriptResource<ScriptResource>
implements Comparable<ScriptResource> {
    private final Log log = ExoLogger.getLogger(ScriptResource.class);
    private final List<Module> modules = new ArrayList<Module>();
    final HashMap<ResourceId, Set<DepInfo>> dependencies;
    final HashSet<ResourceId> closure = new HashSet();
    FetchMode fetchMode;
    final String alias;
    final ScriptGroup group;

    ScriptResource(ScriptGraph graph, ResourceId id, FetchMode fetchMode) {
        this(graph, id, fetchMode, null, null);
    }

    ScriptResource(ScriptGraph graph, ResourceId id, FetchMode fetchMode, String alias, ScriptGroup group) {
        super(graph, id);
        Matcher validMatcher;
        this.dependencies = new LinkedHashMap<ResourceId, Set<DepInfo>>();
        this.fetchMode = fetchMode;
        if (alias == null) {
            String resName = id.getName();
            alias = resName.substring(resName.lastIndexOf("/") + 1);
        }
        if (FetchMode.ON_LOAD.equals((Object)fetchMode) && !(validMatcher = JavascriptConfigService.JS_ID_PATTERN.matcher(alias)).matches()) {
            this.log.warn("alias {} is not valid JS identifier", new Object[]{alias});
        }
        this.alias = alias;
        this.group = group;
    }

    public boolean isEmpty() {
        return this.modules.isEmpty();
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public void addDependency(ResourceId dependencyId) {
        this.addDependency(dependencyId, null, null);
    }

    public void addDependency(ResourceId dependencyId, String alias, String pluginRS) {
        ScriptResource dependency = this.graph.getResource(dependencyId);
        if (dependency != null) {
            if (!this.fetchMode.equals((Object)dependency.getFetchMode())) {
                throw new IllegalStateException("ScriptResource " + String.valueOf(this.id) + " can't depend on " + String.valueOf(dependency.getId()) + ". They have difference fetchMode");
            }
            if (dependency.closure.contains(this.id)) {
                throw new IllegalStateException("Adding script dependency " + String.valueOf(dependency.id) + " to " + String.valueOf(this.id) + " would introduce a circle");
            }
        }
        if (dependency != null) {
            this.closure.addAll(dependency.getClosure());
        }
        this.closure.add(dependencyId);
        for (Map<String, ScriptResource> resources : this.graph.resources.values()) {
            for (ScriptResource resource : resources.values()) {
                if (!resource.closure.contains(this.id)) continue;
                resource.closure.addAll(this.closure);
            }
        }
        Set<DepInfo> infos = this.dependencies.get(dependencyId);
        if (infos == null) {
            infos = new LinkedHashSet<DepInfo>();
            this.dependencies.put(dependencyId, infos);
        }
        infos.add(new DepInfo(alias, pluginRS));
    }

    public Set<ResourceId> getClosure() {
        return this.closure;
    }

    public Module.Local addLocalModule(String contextPath, String path, String resourceBundle, int priority) {
        return this.addLocalModule(contextPath, new Module.Local.Content[]{new Module.Local.Content(path)}, resourceBundle, priority);
    }

    public Module.Local addLocalModule(String contextPath, Module.Local.Content[] contents, String resourceBundle, int priority) {
        return this.addLocalModule(contextPath, contents, resourceBundle, priority, true);
    }

    public Module.Local addLocalModule(String contextPath, Module.Local.Content[] contents, String resourceBundle, int priority, boolean minify) {
        Module.Local module = new Module.Local(this, contextPath, contents, resourceBundle, priority, minify);
        this.modules.add(module);
        return module;
    }

    public Module.Remote addRemoteModule(String contextPath, String path, int priority) {
        Module.Remote module = new Module.Remote(this, contextPath, path, priority);
        this.modules.add(module);
        return module;
    }

    @Override
    public void addSupportedLocale(Locale locale) {
        super.addSupportedLocale(locale);
        if (this.group != null) {
            this.group.addSupportedLocale(locale);
        }
    }

    public List<Module> removeModuleByContextPath(String contextPath) {
        ArrayList<Module> removed = new ArrayList<Module>();
        Iterator<Module> i = this.modules.iterator();
        while (i.hasNext()) {
            Module module = i.next();
            if (!module.getContextPath().equals(contextPath)) continue;
            removed.add(module);
            i.remove();
        }
        return removed;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    @Override
    public int compareTo(ScriptResource o) {
        if (this.closure.contains(o.id)) {
            return 1;
        }
        if (o.closure.contains(this.id)) {
            return -1;
        }
        return 0;
    }

    @Override
    public Set<ResourceId> getDependencies() {
        return this.dependencies.keySet();
    }

    public Set<DepInfo> getDepInfo(ResourceId id) {
        return this.dependencies.get(id);
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        return "ScriptResource[id=" + String.valueOf(this.id) + "]";
    }

    public ScriptGroup getGroup() {
        return this.group;
    }

    public class DepInfo {
        final String alias;
        final String pluginRS;

        DepInfo(String alias, String pluginRS) {
            this.alias = alias;
            this.pluginRS = pluginRS;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getPluginRS() {
            return this.pluginRS;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
            result = 31 * result + (this.pluginRS == null ? 0 : this.pluginRS.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof DepInfo)) {
                return false;
            }
            DepInfo other = (DepInfo)obj;
            return (this.alias == other.alias || this.alias != null && this.alias.equals(other.alias)) && (this.pluginRS == other.pluginRS || this.pluginRS != null && this.pluginRS.equals(other.pluginRS));
        }
    }
}

