/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.annotation.XmlRootElement;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.provider.JAXBContextResolver;
import org.exoplatform.services.rest.provider.EntityProvider;

@Provider
@Consumes(value={"application/xml", "text/xml", "application/xhtml+xml"})
@Produces(value={"application/xml", "text/xml", "application/xhtml+xml", "application/vnd.sun.wadl+xml"})
public class JAXBObjectEntityProvider
implements EntityProvider<Object> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.JAXBObjectEntityProvider");
    @Context
    Providers providers;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.getAnnotation(XmlRootElement.class) != null;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, final InputStream entityStream) throws IOException {
        try {
            final JAXBContext jaxbctx = this.getJAXBContext(type, mediaType);
            return SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return jaxbctx.createUnmarshaller().unmarshal(entityStream);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof UnmarshalException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)cause.getLocalizedMessage(), cause);
                }
                return null;
            }
            if (cause instanceof JAXBException) {
                throw new IOException("Can't read from input stream " + String.valueOf(cause), cause);
            }
            if (cause instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (JAXBException e) {
            throw new IOException("Can't read from input stream " + String.valueOf((Object)e), e);
        }
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.getAnnotation(XmlRootElement.class) != null;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            JAXBContext jaxbctx = this.getJAXBContext(type, mediaType);
            Marshaller m = jaxbctx.createMarshaller();
            String charset = (String)mediaType.getParameters().get("charset");
            if (charset != null) {
                m.setProperty("jaxb.encoding", (Object)charset);
            }
            m.marshal(t, entityStream);
        }
        catch (JAXBException e) {
            throw new IOException("Can't write to output stream " + String.valueOf((Object)e), e);
        }
    }

    protected JAXBContext getJAXBContext(Class<?> type, MediaType mediaType) throws JAXBException {
        ContextResolver resolver = this.providers.getContextResolver(JAXBContextResolver.class, mediaType);
        if (resolver == null) {
            throw new RuntimeException("Not found any JAXBContextResolver for media type " + String.valueOf(mediaType));
        }
        JAXBContextResolver jaxbres = (JAXBContextResolver)resolver.getContext(type);
        return jaxbres.getJAXBContext(type);
    }
}

