/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.service.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.perkstore.entity.ProductEntity;
import org.exoplatform.perkstore.entity.ProductOrderEntity;
import org.exoplatform.perkstore.exception.PerkStoreException;
import org.exoplatform.perkstore.model.FileDetail;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.model.Profile;
import org.exoplatform.perkstore.model.constant.PerkStoreError;
import org.exoplatform.perkstore.model.constant.ProductOrderPeriodType;
import org.exoplatform.perkstore.model.constant.ProductOrderStatus;
import org.exoplatform.perkstore.model.constant.ProductOrderTransactionStatus;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.json.JsonGenerator;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.JsonParser;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    public static final String COMETD_CHANNEL = "/eXo/Application/Addons/PerkStore";
    public static final String SPACE_GROUP_PREFIX = "/spaces/";
    public static final JsonParser JSON_PARSER = new JsonParserImpl();
    public static final JsonGenerator JSON_GENERATOR = new JsonGeneratorImpl();
    public static final String SCOPE_NAME = "ADDONS_PERKSTORE";
    public static final String SETTINGS_KEY_NAME = "ADDONS_PERKSTORE_SETTINGS";
    public static final Context PERKSTORE_CONTEXT = Context.GLOBAL;
    public static final String REWARDING_GROUP = "/platform/rewarding";
    public static final Scope PERKSTORE_SCOPE = Scope.APPLICATION.id("ADDONS_PERKSTORE");
    public static final String ERROR_SUFFIX_GLOBAL_SETTINGS_ACCESS = "settings.access";
    public static final String ERROR_SUFFIX_GLOBAL_SETTINGS_MODIFICATION = "settings.modification";
    public static final String ERROR_SUFFIX_ORDER_CREATION = "order.creation";
    public static final String ERROR_SUFFIX_ORDER_MODIFICATION = "order.modification";
    public static final String ERROR_SUFFIX_ORDER_FRAUD = "order.fraud";
    public static final String ERROR_SUFFIX_ORDER_NOT_EXISTS = "order.existance";
    public static final String ERROR_SUFFIX_ORDER_ACCESS_DENIED = "order.access";
    public static final String ERROR_SUFFIX_PRODUCT_ACCESS_DENIED = "product.access";
    public static final String ERROR_SUFFIX_PRODUCT_CREATION = "product.creation";
    public static final String ERROR_SUFFIX_PRODUCT_MODIFICATION = "product.modification";
    public static final String ERROR_SUFFIX_PRODUCT_NOT_EXISTS = "product.existance";
    public static final String ERROR_SUFFIX_PRODUCT_IS_DISABLED = "product.disabled";
    public static final String SPACE_ACCOUNT_TYPE = "space";
    public static final String USER_ACCOUNT_TYPE = "user";
    public static final String GROUP_ACCOUNT_TYPE = "group";
    public static final String FAKE_TRANSACTION_HASH = "0x0000000000000000000000000000000000000000000000000000000000000000";
    public static final String SETTINGS_MODIFIED_EVENT = "exo.perkstore.settings.modified";
    public static final String PRODUCT_CREATE_OR_MODIFY_EVENT = "exo.perkstore.product.createOrModify";
    public static final String ORDER_CREATE_OR_MODIFY_EVENT = "exo.perkstore.order.createOrModify";

    private Utils() {
    }

    public static <T> T fromString(Class<T> type, String value) throws JsonException {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
        JSON_PARSER.parse((InputStream)new ByteArrayInputStream(value.getBytes()), (JsonHandler)jsonDefaultHandler);
        return (T)ObjectBuilder.createObject(type, (JsonValue)jsonDefaultHandler.getJsonObject());
    }

    public static String transformToString(Object object) {
        try {
            return JSON_GENERATOR.createJsonObject(object).toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't transform object to string", e);
        }
    }

    public static long timeToMilliseconds(LocalDateTime time) {
        return time.atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
    }

    public static final void addIdentityMembersFromProfiles(Collection<Profile> profiles, Collection<String> profilesRemoteIds) {
        if (profiles == null) {
            return;
        }
        for (Profile profile : profiles) {
            if (Utils.isSpaceType(profile.getType())) {
                Space space = Utils.getSpace(profile.getId());
                if (space == null) {
                    LOG.warn((Object)("Can't find a space with id " + profile.getId()));
                    continue;
                }
                if (space.getMembers() == null) continue;
                profilesRemoteIds.addAll(Arrays.asList(space.getMembers()));
                continue;
            }
            profilesRemoteIds.add(profile.getId());
        }
    }

    public static void addIdentityIdsFromProfiles(List<Profile> permissionsProfiles, List<Long> permissions) {
        if (permissionsProfiles != null) {
            for (Profile profile : permissionsProfiles) {
                if (profile == null || profile.getTechnicalId() == 0L && (StringUtils.isBlank((CharSequence)profile.getId()) || StringUtils.isBlank((CharSequence)profile.getType()))) continue;
                long identityId = profile.getTechnicalId();
                if (identityId == 0L) {
                    org.exoplatform.social.core.identity.model.Identity identity = Utils.getIdentityByTypeAndId(profile.getType(), profile.getId());
                    identityId = Long.parseLong(identity.getId());
                }
                permissions.add(identityId);
            }
        }
    }

    public static String getIdentityIdByType(org.exoplatform.social.core.identity.model.Identity receiverIdentity) {
        Space space;
        if (receiverIdentity == null) {
            throw new IllegalArgumentException("Identity is null");
        }
        if (Utils.isSpaceType(receiverIdentity.getProviderId()) && (space = Utils.getSpace(receiverIdentity.getRemoteId())) != null) {
            return space.getId();
        }
        return receiverIdentity.getId();
    }

    public static org.exoplatform.social.core.identity.model.Identity getIdentityById(long identityId) {
        return Utils.getIdentityById(String.valueOf(identityId));
    }

    public static org.exoplatform.social.core.identity.model.Identity getIdentityById(String identityId) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return identityManager.getIdentity(identityId, true);
    }

    public static org.exoplatform.social.core.identity.model.Identity getIdentityByTypeAndId(String type, String remoteId) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return identityManager.getOrCreateIdentity(Utils.getIdentityProviderIdByType(type), remoteId, true);
    }

    public static boolean isSpaceType(String type) {
        return SPACE_ACCOUNT_TYPE.equals(type);
    }

    public static boolean isUserType(String type) {
        return USER_ACCOUNT_TYPE.equals(type) || "organization".equals(type);
    }

    public static boolean isGroupType(String type) {
        return GROUP_ACCOUNT_TYPE.equals(type) || GROUP_ACCOUNT_TYPE.equals(type);
    }

    public static String getIdentityTypeByProviderId(String providerId) {
        if (providerId == null) {
            throw new IllegalArgumentException("Provider id is null");
        }
        if (Utils.isSpaceType(providerId)) {
            return SPACE_ACCOUNT_TYPE;
        }
        if (Utils.isUserType(providerId)) {
            return USER_ACCOUNT_TYPE;
        }
        if (Utils.isGroupType(providerId)) {
            return GROUP_ACCOUNT_TYPE;
        }
        return providerId;
    }

    public static String getIdentityProviderIdByType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Type is null");
        }
        if (Utils.isSpaceType(type)) {
            return SPACE_ACCOUNT_TYPE;
        }
        if (Utils.isUserType(type)) {
            return "organization";
        }
        if (Utils.isGroupType(type)) {
            return GROUP_ACCOUNT_TYPE;
        }
        return type;
    }

    public static Space getSpace(String id) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        if (id.indexOf("/spaces") >= 0) {
            return spaceService.getSpaceByGroupId(id);
        }
        Space space = spaceService.getSpaceById(id);
        if (space == null && (space = spaceService.getSpaceByPrettyName(id)) == null && (space = spaceService.getSpaceByGroupId(SPACE_GROUP_PREFIX + id)) == null && (space = spaceService.getSpaceByDisplayName(id)) == null) {
            space = spaceService.getSpaceByUrl(id);
        }
        return space;
    }

    public static ProductOrder fromEntity(ProductOrderEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Order entity is null");
        }
        ProductOrder order = new ProductOrder();
        order.setId(entity.getId());
        order.setProductId(entity.getProduct().getId());
        order.setTransactionHash(entity.getTransactionHash());
        order.setRefundTransactionHash(entity.getRefundTransactionHash());
        order.setQuantity(entity.getQuantity());
        order.setAmount(entity.getAmount());
        order.setRefundedAmount(entity.getRefundedAmount());
        order.setSender(Utils.toProfile(entity.getSenderId()));
        order.setReceiver(Utils.toProfile(entity.getReceiverId()));
        order.setDeliveredQuantity(entity.getDeliveredQuantity());
        order.setRefundedQuantity(entity.getRefundedQuantity());
        order.setCreatedDate(entity.getCreatedDate());
        order.setDeliveredDate(entity.getDeliveredDate());
        order.setRefundedDate(entity.getRefundedDate());
        order.setTransactionStatus(entity.getTransactionStatus().name());
        order.setRefundTransactionStatus(entity.getRefundTransactionStatus().name());
        order.setStatus(entity.getStatus().name());
        order.setRemainingQuantityToProcess(entity.getRemainingQuantity());
        order.setError(entity.getErrorCode() > 0 ? PerkStoreError.values()[entity.getErrorCode()] : null);
        return order;
    }

    public static ProductOrderEntity toEntity(ProductEntity productEntity, ProductOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Product order is null");
        }
        ProductOrderEntity entity = new ProductOrderEntity();
        entity.setId(order.getId());
        entity.setProduct(productEntity);
        entity.setTransactionHash(Utils.formatTransactionHash(order.getTransactionHash()));
        entity.setRefundTransactionHash(Utils.formatTransactionHash(order.getRefundTransactionHash()));
        entity.setQuantity(order.getQuantity());
        entity.setAmount(order.getAmount());
        entity.setRefundedAmount(order.getRefundedAmount());
        entity.setSenderId(Utils.getTechnicalId(order.getSender()));
        entity.setReceiverId(Utils.getTechnicalId(order.getReceiver()));
        entity.setDeliveredQuantity(order.getDeliveredQuantity());
        entity.setRefundedQuantity(order.getRefundedQuantity());
        entity.setCreatedDate(order.getCreatedDate());
        entity.setDeliveredDate(order.getDeliveredDate());
        entity.setRefundedDate(order.getRefundedDate());
        entity.setErrorCode(order.getError() == null ? 0 : order.getError().ordinal());
        entity.setTransactionStatus(order.getTransactionStatus() == null ? ProductOrderTransactionStatus.NONE : ProductOrderTransactionStatus.valueOf(order.getTransactionStatus()));
        entity.setRefundTransactionStatus(order.getRefundTransactionStatus() == null ? ProductOrderTransactionStatus.NONE : ProductOrderTransactionStatus.valueOf(order.getRefundTransactionStatus()));
        entity.setStatus(ProductOrderStatus.valueOf(StringUtils.upperCase((String)order.getStatus())));
        entity.setRemainingQuantity(order.getRemainingQuantityToProcess());
        return entity;
    }

    public static final String formatTransactionHash(String transactionHash) {
        if (transactionHash == null) {
            return null;
        }
        if (((String)(transactionHash = ((String)transactionHash).trim().toLowerCase())).length() == 64 && !((String)transactionHash).startsWith("0x")) {
            transactionHash = "0x" + (String)transactionHash;
        }
        if (((String)transactionHash).length() != 66) {
            throw new IllegalStateException("Transaction hash " + (String)transactionHash + " isn't well formatted. It should be of length 66");
        }
        if (!((String)transactionHash).startsWith("0x")) {
            throw new IllegalStateException("Transaction hash " + (String)transactionHash + " isn't well formatted. It should starts with 0x");
        }
        return transactionHash;
    }

    public static Product fromEntity(ProductEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Product entity is null");
        }
        Product product = new Product();
        product.setId(entity.getId());
        product.setTitle(entity.getTitle());
        product.setDescription(entity.getDescription());
        product.setPrice(entity.getPrice());
        product.setIllustrationURL(entity.getIllustrationURL());
        product.setEnabled(entity.isEnabled());
        product.setUnlimited(entity.isUnlimited());
        product.setAllowFraction(entity.isAllowFraction());
        product.setTotalSupply(entity.getTotalSupply());
        product.setMaxOrdersPerUser(entity.getMaxOrdersPerUser());
        product.setCreator(Utils.toProfile(entity.getCreator()));
        product.setLastModifier(Utils.toProfile(entity.getLastModifier()));
        product.setCreatedDate(entity.getCreatedDate());
        product.setLastModifiedDate(entity.getLastModifiedDate());
        product.setReceiverMarchand(Utils.toProfile(entity.getReceiverId()));
        product.setDeleted(entity.isDeleted());
        if (entity.getMarchands() == null) {
            product.setMarchands(Collections.emptyList());
        } else {
            product.setMarchands(entity.getMarchands().stream().map(Utils::toProfile).collect(Collectors.toList()));
        }
        if (entity.getAccessPermissions() == null) {
            product.setAccessPermissions(Collections.emptyList());
        } else {
            product.setAccessPermissions(entity.getAccessPermissions().stream().map(Utils::toProfile).collect(Collectors.toList()));
        }
        ProductOrderPeriodType orderPeriodicity = entity.getOrderPeriodicity();
        if (orderPeriodicity == null || orderPeriodicity == ProductOrderPeriodType.NONE) {
            product.setOrderPeriodicity(null);
        } else {
            product.setOrderPeriodicity(orderPeriodicity.getName());
            product.setOrderPeriodicityLabel(orderPeriodicity.getLabel());
        }
        return product;
    }

    public static ProductEntity toEntity(Product product) {
        if (product == null) {
            throw new IllegalArgumentException("Entity is null");
        }
        ProductEntity entity = new ProductEntity();
        entity.setId(product.getId());
        entity.setTitle(product.getTitle());
        entity.setPrice(product.getPrice());
        entity.setDescription(product.getDescription());
        entity.setIllustrationURL(product.getIllustrationURL());
        entity.setEnabled(product.isEnabled());
        entity.setUnlimited(product.isUnlimited());
        entity.setAllowFraction(product.isAllowFraction());
        entity.setTotalSupply(product.getTotalSupply());
        entity.setMaxOrdersPerUser(product.getMaxOrdersPerUser());
        entity.setCreatedDate(product.getCreatedDate());
        entity.setCreator(product.getCreator() == null ? 0L : product.getCreator().getTechnicalId());
        entity.setLastModifier(product.getLastModifier() == null ? 0L : product.getLastModifier().getTechnicalId());
        entity.setLastModifiedDate(product.getLastModifiedDate());
        entity.setReceiverId(Utils.getTechnicalId(product.getReceiverMarchand()));
        entity.setDeleted(product.isDeleted());
        if (product.getMarchands() == null || product.getMarchands().isEmpty()) {
            entity.setMarchands(Collections.emptyList());
        } else {
            entity.setMarchands(product.getMarchands().stream().map(Utils::getTechnicalId).collect(Collectors.toList()));
        }
        if (product.getAccessPermissions() == null || product.getAccessPermissions().isEmpty()) {
            entity.setAccessPermissions(Collections.emptyList());
        } else {
            entity.setAccessPermissions(product.getAccessPermissions().stream().map(Utils::getTechnicalId).collect(Collectors.toList()));
        }
        entity.setImages(Utils.getImageIds(product));
        entity.setOrderPeriodicity(Utils.getOrderPeriodicity(product.getOrderPeriodicity()));
        return entity;
    }

    public static ProductOrderPeriodType getOrderPeriodicity(String orderPeriodicity) {
        ProductOrderPeriodType productOrderPeriodType = null;
        if (StringUtils.isNotBlank((CharSequence)orderPeriodicity)) {
            productOrderPeriodType = ProductOrderPeriodType.valueOf(orderPeriodicity.toUpperCase());
        }
        if (productOrderPeriodType == null) {
            productOrderPeriodType = ProductOrderPeriodType.NONE;
        }
        return productOrderPeriodType;
    }

    public static long getTechnicalId(Profile profile) {
        if (profile == null) {
            return 0L;
        }
        if (profile.getTechnicalId() == 0L) {
            org.exoplatform.social.core.identity.model.Identity identity = Utils.getIdentityByTypeAndId(profile.getType(), profile.getId());
            if (identity != null) {
                return Long.parseLong(identity.getId());
            }
        } else {
            return profile.getTechnicalId();
        }
        return 0L;
    }

    public static void refreshProfile(Profile profile) {
        if (profile == null) {
            return;
        }
        org.exoplatform.social.core.identity.model.Identity identity = Utils.getIdentityByTypeAndId(profile.getType(), profile.getId());
        Utils.toProfile(identity, profile);
    }

    public static Profile toProfile(String type, String id) {
        if (StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        org.exoplatform.social.core.identity.model.Identity identity = Utils.getIdentityByTypeAndId(type, id);
        return Utils.toProfile(identity, null);
    }

    public static Profile toProfile(long identityId) {
        if (identityId > 0L) {
            org.exoplatform.social.core.identity.model.Identity identity = Utils.getIdentityById(identityId);
            return Utils.toProfile(identity, null);
        }
        return null;
    }

    private static Profile toProfile(org.exoplatform.social.core.identity.model.Identity identity, Profile profileToRefresh) {
        if (identity == null) {
            return null;
        }
        Profile profile = profileToRefresh;
        if (profile == null) {
            profile = new Profile();
        }
        String fullName = identity.getProfile().getFullName();
        if (Utils.isSpaceType(identity.getProviderId())) {
            Space space = Utils.getSpace(identity.getRemoteId());
            fullName = space.getDisplayName();
            profile.setSpaceId(Long.parseLong(space.getId()));
            profile.setSpaceURLId(space.getGroupId().replace(SPACE_GROUP_PREFIX, ""));
        }
        profile.setDisplayName(fullName);
        profile.setTechnicalId(Long.parseLong(identity.getId()));
        profile.setId(identity.getRemoteId());
        profile.setType(Utils.getIdentityTypeByProviderId(identity.getProviderId()));
        return profile;
    }

    public static final String getCurrentUserId() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null) {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        return null;
    }

    public static final Locale getCurrentUserLocale() throws Exception {
        String username = Utils.getCurrentUserId();
        LocalePolicy localePolicy = (LocalePolicy)CommonsUtils.getService(LocalePolicy.class);
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((HttpServletRequest)null);
        localeCtx.setUserProfileLocale(Utils.getUserLocale(username));
        localeCtx.setRemoteUser(username);
        Set supportedLocales = LocaleContextInfoUtils.getSupportedLocales();
        Locale locale = localePolicy.determineLocale(localeCtx);
        boolean supported = supportedLocales.contains(locale);
        if (!supported && !"".equals(locale.getCountry())) {
            locale = new Locale(locale.getLanguage());
            supported = supportedLocales.contains(locale);
        }
        if (!supported) {
            LOG.warn((Object)("Unsupported locale returned by LocalePolicy: " + String.valueOf(localePolicy) + ". Falling back to 'en'."));
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public static final String getI18NMessage(String messageKey) throws Exception {
        ResourceBundle resourceBundle;
        ResourceBundleService resourceBundleService = (ResourceBundleService)CommonsUtils.getService(ResourceBundleService.class);
        Locale userLocale = Utils.getCurrentUserLocale();
        if (userLocale == null) {
            userLocale = Locale.ENGLISH;
        }
        if ((resourceBundle = resourceBundleService.getResourceBundle("locale.addon.PerkStoreError", userLocale)) == null) {
            throw new IllegalStateException("Resource bundle not found");
        }
        String message = resourceBundle.getString(messageKey);
        if (StringUtils.isBlank((CharSequence)message)) {
            throw new IllegalStateException("Resource bundle key " + messageKey + "not found");
        }
        return message;
    }

    public static final Locale getUserLocale(String username) throws Exception {
        OrganizationService organizationService = Utils.getOrganizationService();
        UserProfile profile = organizationService.getUserProfileHandler().findUserProfileByName(username);
        String lang = null;
        if (profile != null) {
            lang = profile.getAttribute("user.language");
        }
        if (StringUtils.isNotBlank(lang)) {
            return LocaleUtils.toLocale((String)lang);
        }
        return null;
    }

    public static final void computeOrderDeliverStatus(ProductOrder order, double refundedQuantity, double deliveredQuantity) {
        if (order.getQuantity() == refundedQuantity) {
            order.setStatus(ProductOrderStatus.REFUNDED.name());
        } else if (order.getQuantity() == refundedQuantity + deliveredQuantity) {
            order.setStatus(ProductOrderStatus.DELIVERED.name());
        } else {
            order.setStatus(ProductOrderStatus.PARTIAL.name());
        }
    }

    public static final void computeOrderPaymentStatus(ProductOrder order, boolean transactionSuccess) {
        if (transactionSuccess) {
            String oldStatus = order.getStatus();
            if (StringUtils.equals((CharSequence)ProductOrderStatus.ORDERED.name(), (CharSequence)oldStatus) || StringUtils.equals((CharSequence)ProductOrderStatus.CANCELED.name(), (CharSequence)oldStatus) || StringUtils.equals((CharSequence)ProductOrderStatus.ERROR.name(), (CharSequence)oldStatus)) {
                order.setStatus(ProductOrderStatus.PAID.name());
            }
        } else {
            order.setStatus(ProductOrderStatus.ERROR.name());
        }
    }

    public static final Response computeErrorResponse(Log log, PerkStoreException e, String operationDescription, String username, Object objectToDisplay) {
        Utils.displayErrorLog(log, operationDescription, username, objectToDisplay, e);
        try {
            String errorJSONFormat = Utils.getErrorJSONFormat(e);
            return Response.status((int)500).type("application/json").entity((Object)errorJSONFormat).build();
        }
        catch (Exception exception) {
            LOG.error((Object)"Error computing error message", (Throwable)exception);
            return Response.status((int)500).build();
        }
    }

    public static final void displayErrorLog(Log log, String operationDescription, String username, Object objectToDisplay, PerkStoreException e) {
        if (log.isDebugEnabled()) {
            if (objectToDisplay == null) {
                log.warn("{} denied for user {}.", new Object[]{operationDescription, username, e});
            } else {
                log.warn("{} denied for user {}: Object = {}", new Object[]{operationDescription, username, objectToDisplay, e});
            }
        } else if (objectToDisplay == null) {
            log.info("{} denied for user {}. Message = {}", new Object[]{operationDescription, username, e.getMessage()});
        } else {
            log.info("{} denied for user {}: Message = {} Object = {}", new Object[]{operationDescription, username, e.getMessage(), objectToDisplay});
        }
    }

    public static final String getErrorJSONFormat(PerkStoreException e) throws JSONException {
        JSONObject errorObject = new JSONObject();
        errorObject.put("code", e.getErrorType().getCode());
        errorObject.put("suffix", (Object)e.getErrorType().getSuffix());
        errorObject.put("message", (Object)e.getLocalizedMessage());
        return errorObject.toString();
    }

    public static final boolean getApplicationAccessUsersList(Set<String> recipientUsers, GlobalSettings globalSettings) {
        List<Profile> applicationAccessPermissions = globalSettings.getAccessPermissionsProfiles();
        if (applicationAccessPermissions == null || applicationAccessPermissions.isEmpty()) {
            applicationAccessPermissions = null;
        }
        boolean accessibleToAll = false;
        if (applicationAccessPermissions != null) {
            Utils.addIdentityMembersFromProfiles(applicationAccessPermissions, recipientUsers);
        } else {
            accessibleToAll = true;
        }
        return accessibleToAll;
    }

    public static final boolean getProductAccessUsersList(Set<String> recipientUsers, Product product, GlobalSettings globalSettings) {
        List<Profile> applicationAccessPermissions;
        List<Profile> productAccessPermissions = product.getAccessPermissions();
        if (productAccessPermissions == null || productAccessPermissions.isEmpty()) {
            productAccessPermissions = null;
        }
        if ((applicationAccessPermissions = globalSettings.getAccessPermissionsProfiles()) == null || applicationAccessPermissions.isEmpty()) {
            applicationAccessPermissions = null;
        }
        boolean accessibleToAll = false;
        if (productAccessPermissions != null && applicationAccessPermissions != null) {
            Utils.addIdentityMembersFromProfiles(productAccessPermissions, recipientUsers);
            ArrayList<String> applicationRecipientList = new ArrayList<String>();
            Utils.addIdentityMembersFromProfiles(applicationAccessPermissions, applicationRecipientList);
            recipientUsers.retainAll(applicationRecipientList);
        } else if (productAccessPermissions != null) {
            Utils.addIdentityMembersFromProfiles(productAccessPermissions, recipientUsers);
        } else if (applicationAccessPermissions != null) {
            Utils.addIdentityMembersFromProfiles(applicationAccessPermissions, recipientUsers);
        } else {
            accessibleToAll = true;
        }
        return accessibleToAll;
    }

    public static final void getProductManagersUsersList(Set<String> adminUsers, Product product, GlobalSettings globalSettings) throws Exception {
        List<Profile> perkstoreManagers;
        List<Profile> productMarchands = product.getMarchands();
        if (productMarchands != null) {
            Utils.addIdentityMembersFromProfiles(productMarchands, adminUsers);
        }
        if ((perkstoreManagers = globalSettings.getManagersProfiles()) != null) {
            Utils.addIdentityMembersFromProfiles(perkstoreManagers, adminUsers);
        } else {
            Group rewardingGroup = Utils.getOrganizationService().getGroupHandler().findGroupById(REWARDING_GROUP);
            if (rewardingGroup != null) {
                Membership[] members;
                ListAccess rewardingMembers = Utils.getOrganizationService().getMembershipHandler().findAllMembershipsByGroup(rewardingGroup);
                for (Membership membership : members = (Membership[])rewardingMembers.load(0, rewardingMembers.getSize())) {
                    adminUsers.add(membership.getUserName());
                }
            }
        }
    }

    public static final boolean isUserAdmin(String username) throws Exception {
        return Utils.isUserMemberOf(username, REWARDING_GROUP);
    }

    public static final boolean hasPermission(String username, List<Long> identityIds) throws Exception {
        if (identityIds == null || identityIds.isEmpty()) {
            return true;
        }
        org.exoplatform.social.core.identity.model.Identity userIdentity = Utils.getIdentityByTypeAndId(USER_ACCOUNT_TYPE, username);
        if (userIdentity == null) {
            return false;
        }
        for (Long identityId : identityIds) {
            String permissionExpression;
            org.exoplatform.social.core.identity.model.Identity identity = Utils.getIdentityById(identityId);
            if (identity == null || !Utils.isUserMemberOf(username, permissionExpression = Utils.getPermissionExpression(identity))) continue;
            return true;
        }
        return false;
    }

    public static final String getPermissionExpression(org.exoplatform.social.core.identity.model.Identity identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity is null");
        }
        if (Utils.isSpaceType(identity.getProviderId())) {
            String spacePrettyName = identity.getRemoteId();
            Space space = Utils.getSpace(spacePrettyName);
            return space == null ? null : space.getGroupId();
        }
        return identity.getRemoteId();
    }

    public static final boolean isUserMemberOf(String username, List<Profile> permittedProfiles) {
        if (permittedProfiles == null || permittedProfiles.isEmpty()) {
            return true;
        }
        for (Profile profile : permittedProfiles) {
            if (profile == null) continue;
            if (Utils.isSpaceType(profile.getType())) {
                Space space = Utils.getSpace(profile.getId());
                if (space == null) {
                    LOG.warn("Can't check identity permission on space '{}' because the space wasn't found", new Object[]{profile.getId()});
                    continue;
                }
                if (!((SpaceService)CommonsUtils.getService(SpaceService.class)).isMember(space, username)) continue;
                return true;
            }
            if (!profile.getId().equals(username)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isUserMemberOf(String username, String permissionExpression) throws Exception {
        if (StringUtils.isBlank((CharSequence)permissionExpression)) {
            throw new IllegalArgumentException("Permission expression is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        if (permissionExpression.contains(":")) {
            throw new UnsupportedOperationException("Permission check with role/membershipType isn't implemented ");
        }
        if (permissionExpression.contains("/")) {
            Collection groupsOfUser;
            Identity identity = ((IdentityRegistry)CommonsUtils.getService(IdentityRegistry.class)).getIdentity(username);
            if (identity != null) {
                return identity.isMemberOf(permissionExpression);
            }
            try {
                groupsOfUser = Utils.getOrganizationService().getGroupHandler().findGroupsOfUser(username);
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting groups of user " + username));
                throw e;
            }
            if (groupsOfUser == null || groupsOfUser.isEmpty()) {
                return false;
            }
            for (Group group : groupsOfUser) {
                if (!permissionExpression.equals(group.getId())) continue;
                return true;
            }
            return false;
        }
        return StringUtils.equals((CharSequence)username, (CharSequence)permissionExpression);
    }

    private static OrganizationService getOrganizationService() {
        return (OrganizationService)CommonsUtils.getService(OrganizationService.class);
    }

    private static Set<Long> getImageIds(Product product) {
        Set<FileDetail> imageFiles = product.getImageFiles();
        HashSet<Long> imageIds = new HashSet<Long>();
        if (imageFiles != null && !imageFiles.isEmpty()) {
            for (FileDetail fileDetail : imageFiles) {
                if (fileDetail == null || fileDetail.getId() <= 0L) continue;
                imageIds.add(fileDetail.getId());
            }
        }
        return imageIds;
    }
}

