/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.replication.ApplicationState;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.ConfigurationManager;
import org.exoplatform.webui.application.StateManager;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;

public class PortalStateManager
extends StateManager {
    private static final String APPLICATION_ATTRIBUTE_PREFIX = "psm.";
    private static final Log log = ExoLogger.getLogger(PortalStateManager.class);

    public UIApplication restoreUIRootComponent(WebuiRequestContext context) throws Exception {
        context.setStateManager((StateManager)this);
        WebuiApplication app = (WebuiApplication)context.getApplication();
        ApplicationState appState = null;
        HttpSession session = this.getSession(context);
        String key = this.getKey(context);
        if (session != null) {
            appState = (ApplicationState)session.getAttribute(APPLICATION_ATTRIBUTE_PREFIX + key);
        }
        UIApplication uiapp = null;
        if (appState != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found application " + key + " :" + String.valueOf(appState.getApplication())));
            }
            if (Safe.equals((Object)context.getRemoteUser(), (Object)appState.getUserName())) {
                uiapp = appState.getApplication();
            }
        } else {
            log.debug((Object)("Application " + key + " not found"));
        }
        if (uiapp == null) {
            ConfigurationManager cmanager = app.getConfigurationManager();
            String uirootClass = cmanager.getApplication().getUIRootComponent().trim();
            Class<?> type = Class.forName(uirootClass, true, Thread.currentThread().getContextClassLoader());
            uiapp = (UIApplication)app.createUIComponent(type, null, null, context);
        }
        return uiapp;
    }

    public void storeUIRootComponent(WebuiRequestContext context) throws Exception {
        HttpSession session;
        UIApplication uiapp = context.getUIApplication();
        if (uiapp != null && (session = this.getSession(context)) != null) {
            String key = this.getKey(context);
            log.debug((Object)("Storing application " + key));
            session.setAttribute(APPLICATION_ATTRIBUTE_PREFIX + key, (Object)new ApplicationState(uiapp, context.getRemoteUser()));
        }
    }

    public void expire(String sessionId, WebuiApplication app) {
    }

    private String getKey(WebuiRequestContext webuiRC) {
        if (webuiRC instanceof PortletRequestContext) {
            PortletRequestContext portletRC = (PortletRequestContext)webuiRC;
            return portletRC.getApplication().getApplicationId() + "/" + portletRC.getWindowId();
        }
        return "PortalApplication";
    }

    private HttpSession getSession(WebuiRequestContext webuiRC) {
        PortalRequestContext portalRC;
        if (webuiRC instanceof PortletRequestContext) {
            PortletRequestContext portletRC = (PortletRequestContext)webuiRC;
            portalRC = (PortalRequestContext)portletRC.getParentAppRequestContext();
        } else {
            portalRC = (PortalRequestContext)webuiRC;
        }
        HttpServletRequest req = portalRC.getRequest();
        return req.getSession(false);
    }
}

