/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.entity;

import io.meeds.gamification.entity.AbstractAuditingEntity;
import io.meeds.gamification.entity.ProgramEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;

@Entity(name="GamificationBadge")
@Table(name="GAMIFICATION_BADGES")
@NamedQueries(value={@NamedQuery(name="GamificationBadge.getAllBadges", query="SELECT badge FROM GamificationBadge badge   WHERE badge.isDeleted = false ORDER BY badge.iconFileId ASC "), @NamedQuery(name="GamificationBadge.findBadgeByDomain", query="SELECT badge FROM GamificationBadge badge WHERE badge.domainEntity.id = :domainId  ORDER BY badge.neededScore ASC"), @NamedQuery(name="GamificationBadge.findEnabledBadgeByDomain", query="SELECT badge FROM GamificationBadge badge WHERE (badge.domainEntity.id = :domainId) AND (badge.enabled = true) AND badge.isDeleted = false ORDER BY badge.neededScore ASC"), @NamedQuery(name="GamificationBadge.getEnabledBadges", query="SELECT badge FROM GamificationBadge badge where badge.enabled = :isEnabled AND badge.isDeleted = false"), @NamedQuery(name="GamificationBadge.findBadgeByNeededScore", query="SELECT badge FROM GamificationBadge badge where badge.neededScore = :neededScore  AND badge.isDeleted = false"), @NamedQuery(name="GamificationBadge.findBadgeByTitle", query="SELECT badge FROM GamificationBadge badge where badge.title = :badgeTitle"), @NamedQuery(name="GamificationBadge.findBadgeByTitleAndDomain", query="SELECT badge FROM GamificationBadge badge where badge.title = :badgeTitle and badge.domainEntity.id = :domainId"), @NamedQuery(name="GamificationBadge.deleteBadgeByTitle", query="DELETE FROM GamificationBadge badge WHERE badge.title = :badgeTitle"), @NamedQuery(name="GamificationBadge.deleteBadgeById", query="DELETE FROM GamificationBadge badge WHERE badge.id = :badgeId")})
public class BadgeEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 8412261859526217944L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_BADGE_ID", sequenceName="SEQ_GAMIFICATION_BADGE_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_BADGE_ID")
    @Column(name="BADGE_ID")
    protected Long id;
    @Column(name="TITLE", unique=true, nullable=false)
    protected String title;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="NEEDED_SCORE")
    protected int neededScore;
    @Column(name="ICON_FILE_ID")
    private long iconFileId;
    @Column(name="VALIDITY_DATE_START")
    protected Date startValidityDate;
    @Column(name="VALIDITY_DATE_END")
    protected Date endValidityDate;
    @Column(name="ENABLED", nullable=false)
    protected boolean enabled;
    @ManyToOne
    @JoinColumn(name="DOMAIN_ID")
    private ProgramEntity domainEntity;
    @Column(name="DELETED", nullable=false)
    protected boolean isDeleted;

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getNeededScore() {
        return this.neededScore;
    }

    public long getIconFileId() {
        return this.iconFileId;
    }

    public Date getStartValidityDate() {
        return this.startValidityDate;
    }

    public Date getEndValidityDate() {
        return this.endValidityDate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ProgramEntity getDomainEntity() {
        return this.domainEntity;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNeededScore(int neededScore) {
        this.neededScore = neededScore;
    }

    public void setIconFileId(long iconFileId) {
        this.iconFileId = iconFileId;
    }

    public void setStartValidityDate(Date startValidityDate) {
        this.startValidityDate = startValidityDate;
    }

    public void setEndValidityDate(Date endValidityDate) {
        this.endValidityDate = endValidityDate;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDomainEntity(ProgramEntity domainEntity) {
        this.domainEntity = domainEntity;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public String toString() {
        return "BadgeEntity(id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", neededScore=" + this.getNeededScore() + ", iconFileId=" + this.getIconFileId() + ", startValidityDate=" + this.getStartValidityDate() + ", endValidityDate=" + this.getEndValidityDate() + ", enabled=" + this.isEnabled() + ", domainEntity=" + this.getDomainEntity() + ", isDeleted=" + this.isDeleted() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BadgeEntity)) {
            return false;
        }
        BadgeEntity other = (BadgeEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getNeededScore() != other.getNeededScore()) {
            return false;
        }
        if (this.getIconFileId() != other.getIconFileId()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Date this$startValidityDate = this.getStartValidityDate();
        Date other$startValidityDate = other.getStartValidityDate();
        if (this$startValidityDate == null ? other$startValidityDate != null : !((Object)this$startValidityDate).equals(other$startValidityDate)) {
            return false;
        }
        Date this$endValidityDate = this.getEndValidityDate();
        Date other$endValidityDate = other.getEndValidityDate();
        if (this$endValidityDate == null ? other$endValidityDate != null : !((Object)this$endValidityDate).equals(other$endValidityDate)) {
            return false;
        }
        ProgramEntity this$domainEntity = this.getDomainEntity();
        ProgramEntity other$domainEntity = other.getDomainEntity();
        return !(this$domainEntity == null ? other$domainEntity != null : !((Object)this$domainEntity).equals(other$domainEntity));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BadgeEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getNeededScore();
        long $iconFileId = this.getIconFileId();
        result = result * 59 + (int)($iconFileId >>> 32 ^ $iconFileId);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Date $startValidityDate = this.getStartValidityDate();
        result = result * 59 + ($startValidityDate == null ? 43 : ((Object)$startValidityDate).hashCode());
        Date $endValidityDate = this.getEndValidityDate();
        result = result * 59 + ($endValidityDate == null ? 43 : ((Object)$endValidityDate).hashCode());
        ProgramEntity $domainEntity = this.getDomainEntity();
        result = result * 59 + ($domainEntity == null ? 43 : ((Object)$domainEntity).hashCode());
        return result;
    }
}

