/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.register;

import io.meeds.portal.security.service.SecuritySettingService;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import nl.captcha.Captcha;
import nl.captcha.servlet.CaptchaServletUtil;
import nl.captcha.text.producer.DefaultTextProducer;
import nl.captcha.text.renderer.DefaultWordRenderer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.JspBasedWebHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.json.JSONObject;

public class ExternalRegisterHandler
extends JspBasedWebHandler {
    public static final String REQUIRE_EMAIL_VALIDATION = "requireEmailValidation";
    private static final String ADMINISTRATORS_GROUP = "/platform/administrators";
    private static final Log LOG = ExoLogger.getLogger(ExternalRegisterHandler.class);
    private static final QualifiedName SERVER_CAPTCHA = QualifiedName.create((String)"gtn", (String)"serveCaptcha");
    public static final String USERNAME_PARAM = "username";
    public static final String EMAIL_PARAM = "email";
    public static final String LASTNAME_PARAM = "lastName";
    public static final String FIRSTNAME_PARAM = "firstName";
    public static final String PASSWORD_PARAM = "password";
    public static final String PASSWORD_CONFIRM_PARAM = "password2";
    public static final UserFieldValidator PASSWORD_VALIDATOR = new UserFieldValidator("password", false, false, 8, 255);
    public static final UserFieldValidator LASTNAME_VALIDATOR = new UserFieldValidator("lastName", false, true);
    public static final UserFieldValidator FIRSTNAME_VALIDATOR = new UserFieldValidator("firstName", false, true);
    public static final UserFieldValidator EMAIL_VALIDATOR = new UserFieldValidator("email", false, false);
    public static final String NAME = "external-registration";
    public static final QualifiedName TOKEN = QualifiedName.create((String)"gtn", (String)"token");
    public static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");
    public static final QualifiedName INIT_URL = QualifiedName.create((String)"gtn", (String)"initURL");
    public static final String REQ_PARAM_ACTION = "action";
    public static final String LOGIN = "/login";
    public static final String USERS_GROUP = "/platform/users";
    public static final String EXTERNAL_USERS_GROUP = "/platform/externals";
    public static final String CAPTCHA_PARAM = "captcha";
    public static final String ACTION_PARAM = "action";
    public static final String VALIDATE_EXTERNAL_EMAIL_ACTION = "validateEmail";
    public static final String SAVE_EXTERNAL_ACTION = "saveExternal";
    public static final String EXPIRED_ACTION_NAME = "expired";
    public static final String SUCCESS_MESSAGE_PARAM = "success";
    public static final String ERROR_MESSAGE_PARAM = "error";
    public static final String ERROR_FIELD_PARAM = "errorField";
    public static final String ALREADY_AUTHENTICATED_MESSAGE_PARAM = "authenticated";
    public static final String EMAIL_VERIFICATION_SENT = "emailVerificationSent";
    public static final String TOKEN_ID_PARAM = "tokenId";
    public static final int CAPTCHA_WIDTH = 200;
    public static final int CAPTCHA_HEIGHT = 50;
    public static final String EXTERNAL_REGISTRATION_JSP_PATH = "/WEB-INF/jsp/externalRegistration/init_account.jsp";
    private static final String MEMBER = "member";
    public static final String USERNAME_REQUEST_PARAM = "username";
    public static final String PASSWORD_REQUEST_PARAM = "password";
    public static final String INITIAL_URI_PARAM = "initialURI";
    private PortalContainer container;
    private ServletContext servletContext;
    private RemindPasswordTokenService remindPasswordTokenService;
    private PasswordRecoveryService passwordRecoveryService;
    private ResourceBundleService resourceBundleService;
    private OrganizationService organizationService;
    private SecuritySettingService securitySettingService;

    public ExternalRegisterHandler(PortalContainer container, RemindPasswordTokenService remindPasswordTokenService, PasswordRecoveryService passwordRecoveryService, ResourceBundleService resourceBundleService, OrganizationService organizationService, LocaleConfigService localeConfigService, BrandingService brandingService, SecuritySettingService securitySettingService, JavascriptConfigService javascriptConfigService, SkinService skinService) {
        super(localeConfigService, brandingService, javascriptConfigService, skinService);
        this.container = container;
        this.servletContext = container.getPortalContext();
        this.remindPasswordTokenService = remindPasswordTokenService;
        this.passwordRecoveryService = passwordRecoveryService;
        this.resourceBundleService = resourceBundleService;
        this.organizationService = organizationService;
        this.securitySettingService = securitySettingService;
    }

    public String getHandlerName() {
        return NAME;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpServletRequest request = controllerContext.getRequest();
        HttpServletResponse response = controllerContext.getResponse();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (request.getRemoteUser() != null) {
            parameters.put(ALREADY_AUTHENTICATED_MESSAGE_PARAM, "true");
            return this.dispatch(controllerContext, request, response, parameters);
        }
        Locale locale = request.getLocale();
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle(this.resourceBundleService.getSharedResourceBundleNames(), locale);
        String serveCaptcha = controllerContext.getParameter(SERVER_CAPTCHA);
        if ("true".equals(serveCaptcha)) {
            return this.serveCaptchaImage(request, response);
        }
        String requestAction = request.getParameter("action");
        String initialUri = request.getParameter(INITIAL_URI_PARAM);
        String token = controllerContext.getParameter(TOKEN);
        String username = this.getStoredCredentials(token, requestAction);
        if (username == null) {
            return this.dispatch(controllerContext, request, response, Collections.singletonMap("action", EXPIRED_ACTION_NAME));
        }
        if (VALIDATE_EXTERNAL_EMAIL_ACTION.equalsIgnoreCase(requestAction)) {
            User user = this.generateUserFromCredential(username);
            username = this.createUser(user);
            this.passwordRecoveryService.sendAccountCreatedConfirmationEmail(username, locale, this.getBaseUrl(request));
            this.remindPasswordTokenService.deleteToken(token);
            this.wrapForAutomaticLogin(request, response, initialUri, user.getUserName(), user.getPassword());
        } else if (SAVE_EXTERNAL_ACTION.equalsIgnoreCase(requestAction)) {
            if (this.findUser(username) != null) {
                this.redirectToLoginPage(request, response, username);
                return true;
            }
            String requestUsername = request.getParameter("username");
            String requestEmail = request.getParameter(EMAIL_PARAM);
            String firstName = request.getParameter(FIRSTNAME_PARAM);
            String lastName = request.getParameter(LASTNAME_PARAM);
            String password = request.getParameter("password");
            String confirmPass = request.getParameter(PASSWORD_CONFIRM_PARAM);
            String captcha = request.getParameter(CAPTCHA_PARAM);
            HttpSession session = request.getSession();
            if (!this.isValidCaptch(session, captcha)) {
                parameters.put(ERROR_MESSAGE_PARAM, resourceBundle.getString("gatein.forgotPassword.captchaError"));
                parameters.put(ERROR_FIELD_PARAM, CAPTCHA_PARAM);
            } else if (this.isValidUserAndPassword(username, requestUsername, requestEmail, password, confirmPass, parameters, resourceBundle, locale) && this.isValidUserFullName(firstName, lastName, parameters, locale)) {
                try {
                    if (session.getAttribute(REQUIRE_EMAIL_VALIDATION) == null) {
                        username = this.createUser(requestUsername, requestEmail, firstName, lastName, password);
                        this.passwordRecoveryService.sendAccountCreatedConfirmationEmail(username, locale, this.getBaseUrl(request));
                        this.remindPasswordTokenService.deleteToken(token);
                        this.wrapForAutomaticLogin(request, response, initialUri, username, password);
                        return true;
                    }
                    if (session.getAttribute(REQUIRE_EMAIL_VALIDATION).equals("true")) {
                        User user = this.organizationService.getUserHandler().createUserInstance(requestUsername);
                        user.setFirstName(firstName);
                        user.setLastName(lastName);
                        user.setEmail(requestEmail);
                        user.setPassword(password);
                        String data = this.generateUserDetailCredential(user);
                        this.passwordRecoveryService.sendAccountVerificationEmail(data, requestUsername, firstName, lastName, requestEmail, locale, this.getBaseUrl(request));
                        parameters.put(SUCCESS_MESSAGE_PARAM, EMAIL_VERIFICATION_SENT);
                        session.setAttribute(REQUIRE_EMAIL_VALIDATION, (Object)"false");
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error while registering external user", (Throwable)e);
                    parameters.put(ERROR_MESSAGE_PARAM, resourceBundle.getString("external.registration.fail.create.user"));
                }
            }
            parameters.put(EMAIL_PARAM, requestEmail);
            parameters.put(FIRSTNAME_PARAM, firstName);
            parameters.put(LASTNAME_PARAM, lastName);
            parameters.put("password", password);
            parameters.put(PASSWORD_CONFIRM_PARAM, confirmPass);
        }
        if (StringUtils.contains((CharSequence)username, (CharSequence)"@")) {
            parameters.put(EMAIL_PARAM, this.escapeXssCharacters(username));
        } else {
            parameters.put("username", this.escapeXssCharacters(username));
        }
        parameters.put(TOKEN_ID_PARAM, token);
        parameters.put(INITIAL_URI_PARAM, initialUri);
        return this.dispatch(controllerContext, request, response, parameters);
    }

    private String getStoredCredentials(String token, String requestAction) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        if (StringUtils.equals((CharSequence)VALIDATE_EXTERNAL_EMAIL_ACTION, (CharSequence)requestAction)) {
            return this.passwordRecoveryService.verifyToken(token, "email-validation");
        }
        return this.passwordRecoveryService.verifyToken(token, NAME);
    }

    private boolean isValidUserFullName(String firstName, String lastName, Map<String, Object> parameters, Locale locale) {
        String errorMessage = FIRSTNAME_VALIDATOR.validate(locale, firstName);
        if (StringUtils.isBlank((CharSequence)errorMessage)) {
            errorMessage = LASTNAME_VALIDATOR.validate(locale, lastName);
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                parameters.put(ERROR_MESSAGE_PARAM, errorMessage);
                parameters.put(ERROR_FIELD_PARAM, LASTNAME_PARAM);
            }
        } else {
            parameters.put(ERROR_MESSAGE_PARAM, errorMessage);
            parameters.put(ERROR_FIELD_PARAM, FIRSTNAME_PARAM);
        }
        return StringUtils.isBlank((CharSequence)errorMessage);
    }

    private boolean isValidUserAndPassword(String tokenUsernameOrEmail, String username, String email, String password, String confirmPass, Map<String, Object> parameters, ResourceBundle bundle, Locale locale) {
        boolean notSameUser;
        boolean isEmailToken = StringUtils.contains((CharSequence)tokenUsernameOrEmail, (CharSequence)"@");
        boolean bl = notSameUser = StringUtils.isBlank((CharSequence)tokenUsernameOrEmail) || StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)email) || isEmailToken && !StringUtils.equals((CharSequence)tokenUsernameOrEmail, (CharSequence)email) || !isEmailToken && !StringUtils.equals((CharSequence)tokenUsernameOrEmail, (CharSequence)username);
        if (notSameUser) {
            String errorMessage = bundle.getString("gatein.forgotPassword.usernameChanged");
            errorMessage = errorMessage.replace("{0}", tokenUsernameOrEmail);
            parameters.put(ERROR_MESSAGE_PARAM, errorMessage);
        } else {
            String errorMessage = PASSWORD_VALIDATOR.validate(locale, password);
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                parameters.put(ERROR_MESSAGE_PARAM, errorMessage);
                parameters.put(ERROR_FIELD_PARAM, "password");
            } else if (!isEmailToken) {
                errorMessage = EMAIL_VALIDATOR.validate(locale, email);
                if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                    parameters.put(ERROR_MESSAGE_PARAM, errorMessage);
                    parameters.put(ERROR_FIELD_PARAM, EMAIL_PARAM);
                }
            } else if (!StringUtils.equals((CharSequence)password, (CharSequence)confirmPass)) {
                parameters.put(ERROR_MESSAGE_PARAM, bundle.getString("gatein.forgotPassword.confirmPasswordNotMatch"));
                parameters.put(ERROR_FIELD_PARAM, PASSWORD_CONFIRM_PARAM);
            }
        }
        return !parameters.containsKey(ERROR_MESSAGE_PARAM);
    }

    private String createUser(String username, String email, String firstName, String lastName, String password) throws Exception {
        User user = this.organizationService.getUserHandler().createUserInstance(username);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setPassword(password);
        user.setEmail(email);
        return this.createUser(user);
    }

    private String createUser(User user) throws Exception {
        String login = user.getUserName();
        if (StringUtils.isBlank((CharSequence)login)) {
            login = this.generateUsername(user.getFirstName(), user.getLastName());
            user.setUserName(login);
        }
        this.organizationService.getUserHandler().createUser(user, true);
        Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(login, ADMINISTRATORS_GROUP);
        boolean isAdministrator = CollectionUtils.isNotEmpty((Collection)memberships);
        if (!isAdministrator && this.securitySettingService.isRegistrationExternalUser()) {
            this.deleteFromInternalUsersGroup(login);
            this.addToExternalUsersGroup(login);
        }
        return login;
    }

    private void deleteFromInternalUsersGroup(String username) throws Exception {
        Collection usersMemberhips = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(username, USERS_GROUP);
        if (CollectionUtils.isNotEmpty((Collection)usersMemberhips)) {
            for (Membership usersMemberhip : usersMemberhips) {
                this.organizationService.getMembershipHandler().removeMembership(usersMemberhip.getId(), true);
            }
        }
    }

    private void addToExternalUsersGroup(String username) throws Exception {
        Collection externalsUsersMemberhips = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(username, EXTERNAL_USERS_GROUP);
        if (CollectionUtils.isNotEmpty((Collection)externalsUsersMemberhips)) {
            for (Membership usersMemberhip : externalsUsersMemberhips) {
                this.organizationService.getMembershipHandler().removeMembership(usersMemberhip.getId(), true);
            }
        }
        this.organizationService.getMembershipHandler().linkMembership(this.organizationService.getUserHandler().findUserByName(username), this.organizationService.getGroupHandler().findGroupById(EXTERNAL_USERS_GROUP), this.organizationService.getMembershipTypeHandler().findMembershipType(MEMBER), true);
    }

    private StringBuilder getBaseUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        url.append(request.getScheme()).append("://").append(request.getServerName());
        if (request.getServerPort() != 80 && request.getServerPort() != 443) {
            url.append(':').append(request.getServerPort());
        }
        url.append(this.servletContext.getContextPath());
        return url;
    }

    private boolean isValidCaptch(HttpSession session, String captchaValue) {
        Captcha captcha = (Captcha)session.getAttribute(NAME);
        return captcha != null && captcha.isCorrect(captchaValue);
    }

    protected void extendApplicationParameters(JSONObject applicationParameters, Map<String, Object> additionalParameters) {
        additionalParameters.forEach((arg_0, arg_1) -> ((JSONObject)applicationParameters).put(arg_0, arg_1));
    }

    private boolean dispatch(ControllerContext controllerContext, HttpServletRequest request, HttpServletResponse response, Map<String, Object> parameters) throws Exception {
        request.getSession().removeAttribute(NAME);
        super.prepareDispatch(controllerContext, "PORTLET/social-portlet/ExternalOnboarding", Collections.emptyList(), Collections.singletonList("portal/login"), params -> this.extendApplicationParameters((JSONObject)params, parameters));
        this.servletContext.getRequestDispatcher(EXTERNAL_REGISTRATION_JSP_PATH).include((ServletRequest)request, (ServletResponse)response);
        return true;
    }

    private void redirectToLoginPage(HttpServletRequest request, HttpServletResponse response, String initialUri) throws IOException {
        request.getSession().removeAttribute(NAME);
        Object path = !StringUtils.startsWith((CharSequence)initialUri, (CharSequence)"/") ? this.servletContext.getContextPath() + LOGIN : response.encodeRedirectURL(initialUri);
        response.sendRedirect((String)path);
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    private String escapeXssCharacters(String message) {
        message = message == null ? null : message.replace("&", "&amp").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
        return message;
    }

    private User findUser(String usernameOrEmail) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(usernameOrEmail, UserStatus.ANY);
        if (user == null && usernameOrEmail.contains("@")) {
            Query query = new Query();
            query.setEmail(usernameOrEmail);
            ListAccess list = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
            if (list != null && list.getSize() > 0) {
                user = ((User[])list.load(0, 1))[0];
            }
        }
        return user;
    }

    private boolean serveCaptchaImage(HttpServletRequest req, HttpServletResponse resp) {
        Captcha captcha;
        HttpSession session = req.getSession();
        if (session.getAttribute(NAME) == null) {
            List<Font> textFonts = Arrays.asList(new Font("Arial", 1, 40), new Font("Courier", 1, 40));
            captcha = new Captcha.Builder(200, 50).addText(new DefaultTextProducer(5), new DefaultWordRenderer(Color.WHITE, textFonts)).gimp().addNoise().addBackground().build();
            session.setAttribute(NAME, (Object)captcha);
            this.writeImage(resp, captcha.getImage());
        }
        captcha = (Captcha)session.getAttribute(NAME);
        this.writeImage(resp, captcha.getImage());
        return true;
    }

    private void writeImage(HttpServletResponse response, BufferedImage bi) {
        response.setHeader("Cache-Control", "private,no-cache,no-store");
        response.setContentType("image/png");
        try {
            CaptchaServletUtil.writeImage((OutputStream)response.getOutputStream(), bi);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String generateUsername(String firstname, String lastname) throws Exception {
        String userNameBase = new StringBuffer(firstname.replaceAll("\\s", "")).append(".").append(lastname.replaceAll("\\s", "")).toString().toLowerCase();
        userNameBase = this.unAccent(userNameBase);
        Object username = userNameBase;
        Random rand = new Random();
        while (this.findUser((String)username) != null) {
            int num = rand.nextInt(89) + 10;
            username = userNameBase + String.valueOf(num);
        }
        return username;
    }

    private String unAccent(String src) {
        return Normalizer.normalize(src, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replace("'", "");
    }

    private void wrapForAutomaticLogin(HttpServletRequest request, HttpServletResponse response, String initialUri, String username, String password) throws ServletException, IOException {
        this.restartTransaction();
        HttpServletRequestWrapper wrappedRequestForLogin = this.wrapRequestForLogin(request, username, password, initialUri);
        request.getRequestDispatcher(this.servletContext.getContextPath() + LOGIN).include((ServletRequest)wrappedRequestForLogin, (ServletResponse)response);
        this.redirectToLoginPage(request, response, initialUri);
    }

    private HttpServletRequestWrapper wrapRequestForLogin(HttpServletRequest request, final String username, final String password, final String initialUri) {
        return new HttpServletRequestWrapper(request){

            public String getParameter(String name) {
                if (StringUtils.equals((CharSequence)name, (CharSequence)"username")) {
                    return username;
                }
                if (StringUtils.equals((CharSequence)name, (CharSequence)"password")) {
                    return password;
                }
                if (StringUtils.equals((CharSequence)name, (CharSequence)ExternalRegisterHandler.INITIAL_URI_PARAM)) {
                    return initialUri;
                }
                return super.getParameter(name);
            }

            public String getRequestURI() {
                return ExternalRegisterHandler.this.servletContext.getContextPath() + ExternalRegisterHandler.LOGIN;
            }
        };
    }

    private void restartTransaction() {
        int i = 0;
        boolean success = true;
        do {
            try {
                RequestLifeCycle.end();
                ++i;
            }
            catch (IllegalStateException e) {
                success = false;
            }
        } while (success);
        for (int j = 0; j < i; ++j) {
            RequestLifeCycle.begin((ExoContainer)this.container);
        }
    }

    private String generateUserDetailCredential(User user) {
        return user.getUserName() + "::" + user.getFirstName() + "::" + user.getLastName() + "::" + user.getEmail() + "::" + user.getPassword();
    }

    private User generateUserFromCredential(String data) {
        String[] dataParts = StringUtils.split((String)data, (String)"::");
        User user = this.organizationService.getUserHandler().createUserInstance(dataParts[0]);
        user.setFirstName(dataParts[1]);
        user.setLastName(dataParts[2]);
        user.setEmail(dataParts[3]);
        String firstPart = dataParts[0] + "::" + dataParts[1] + "::" + dataParts[2] + "::" + dataParts[3] + "::";
        String password = data.substring(firstPart.length());
        user.setPassword(password);
        return user;
    }
}

