/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class SpanOrQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final List<SpanQuery> clauses;
    public static final JsonpDeserializer<SpanOrQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanOrQuery::setupSpanOrQueryDeserializer);

    private SpanOrQuery(Builder builder) {
        super(builder);
        this.clauses = ApiTypeHelper.unmodifiableRequired(builder.clauses, (Object)this, "clauses");
    }

    public static SpanOrQuery of(Function<Builder, ObjectBuilder<SpanOrQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanOr;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SpanOr;
    }

    public final List<SpanQuery> clauses() {
        return this.clauses;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.clauses)) {
            generator.writeKey("clauses");
            generator.writeStartArray();
            for (SpanQuery item0 : this.clauses) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSpanOrQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::clauses, JsonpDeserializer.arrayDeserializer(SpanQuery._DESERIALIZER), "clauses");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanOrQuery> {
        private List<SpanQuery> clauses;

        public final Builder clauses(List<SpanQuery> list) {
            this.clauses = Builder._listAddAll(this.clauses, list);
            return this;
        }

        public final Builder clauses(SpanQuery value, SpanQuery ... values) {
            this.clauses = Builder._listAdd(this.clauses, value, values);
            return this;
        }

        public final Builder clauses(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.clauses(fn.apply(new SpanQuery.Builder()).build(), new SpanQuery[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanOrQuery build() {
            this._checkSingleUse();
            return new SpanOrQuery(this);
        }
    }
}

