/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.SiteBody;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.BodyData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.ModelData;
import org.exoplatform.portal.pom.data.PageData;

public abstract class ModelObject {
    protected String storageId;
    protected String storageName;
    protected String width;
    protected String height;
    protected String cssClass;
    protected String borderColor;

    public ModelObject(String storageId) {
        this.storageId = storageId;
    }

    protected ModelObject() {
        this.storageId = null;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public void resetStorage() {
        this.storageId = null;
        this.storageName = null;
    }

    public abstract ModelData build();

    public static ModelObject build(ModelData data) {
        ApplicationData applicationData;
        ApplicationType type;
        if (data instanceof ContainerData) {
            return new Container((ContainerData)data);
        }
        if (data instanceof PageData) {
            return new Page((PageData)data);
        }
        if (data instanceof BodyData) {
            BodyData bodyData = (BodyData)data;
            switch (bodyData.getType()) {
                case PAGE: {
                    return new PageBody(data.getStorageId());
                }
                case SITE: {
                    return new SiteBody(data.getStorageId());
                }
            }
            throw new AssertionError();
        }
        if (data instanceof ApplicationData && ApplicationType.PORTLET == (type = (applicationData = (ApplicationData)data).getType())) {
            return Application.createPortletApplication(applicationData);
        }
        return null;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }
}

