/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.PageCreateModel;
import io.meeds.layout.model.PermissionUpdateModel;
import io.meeds.layout.rest.model.LayoutModel;
import io.meeds.layout.rest.util.RestEntityBuilder;
import io.meeds.layout.service.PageLayoutService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"pages"})
@Tag(name="pages", description="Managing site pages")
public class PageLayoutRest {
    @Autowired
    private PageLayoutService pageLayoutService;
    @Autowired
    private LayoutService layoutService;

    @GetMapping
    @Operation(summary="Retrieve pages", method="GET", description="This retrieves pages")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public List<PageContext> getPages(HttpServletRequest request, @Parameter(description="Portal site type, possible values: PORTAL, GROUP or USER", required=false) @RequestParam(name="siteType", required=false) String siteType, @Parameter(description="Portal site name", required=false) @RequestParam(name="siteName", required=false) String siteName, @Parameter(description="page display name", required=false) @RequestParam(name="pageDisplayName", required=false) String pageDisplayName, @Parameter(description="Results offset", required=false) @RequestParam(name="offset", required=false, defaultValue="0") int offset, @Parameter(description="Results limit", required=false) @RequestParam(name="limit", required=false, defaultValue="10") int limit) {
        return this.pageLayoutService.getPages(siteType, siteName, pageDisplayName, offset, limit, request.getRemoteUser());
    }

    @GetMapping(value={"layout"})
    @Operation(summary="Retrieve page layout by reference", method="GET", description="This retrieves page by reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public LayoutModel getPageLayout(HttpServletRequest request, @Parameter(description="page reference", required=true) @RequestParam(value="pageRef") String pageRef, @Parameter(description="expand options", required=true) @RequestParam(value="expand") String expand) {
        try {
            Page page = this.pageLayoutService.getPageLayout(PageKey.parse((String)pageRef), request.getRemoteUser());
            return RestEntityBuilder.toLayoutModel(page, this.layoutService, expand);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @GetMapping(value={"byRef"})
    @Operation(summary="Retrieve page by reference", method="GET", description="This retrieves page by reference")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public PageContext getPage(HttpServletRequest request, @Parameter(description="page reference", required=true) @RequestParam(value="pageRef") String pageRef) {
        try {
            return this.pageLayoutService.getPage(PageKey.parse((String)pageRef), request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Create a page", method="POST", description="This creates the page")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="page created"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public PageContext createPage(HttpServletRequest request, @RequestBody PageCreateModel createModel) {
        try {
            return this.pageLayoutService.createPage(createModel, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PutMapping(value={"layout"})
    @Secured(value={"users"})
    @Operation(summary="Updates an existing page layout", method="PUT", description="This updates the designated page layout")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="page created"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public LayoutModel updatePageLayout(HttpServletRequest request, @Parameter(description="page display name", required=true) @RequestParam(value="pageRef") String pageRef, @Parameter(description="Whether the page layout update is a draft page publication or not", required=false) @RequestParam(name="publish", required=false) Optional<Boolean> publish, @Parameter(description="expand options", required=true) @RequestParam(value="expand") String expand, @RequestBody LayoutModel layoutModel) {
        try {
            this.pageLayoutService.updatePageLayout(pageRef, RestEntityBuilder.fromLayoutModel(layoutModel), publish.orElse(false), request.getRemoteUser());
            return this.getPageLayout(request, pageRef, expand);
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PatchMapping(name="link", consumes={"application/x-www-form-urlencoded"})
    @Secured(value={"users"})
    @Operation(summary="Update page link", method="GET", description="This updates page link")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void updatePageLink(HttpServletRequest request, @Parameter(description="page display name", required=true) @RequestParam(value="pageRef") String pageRef, @Parameter(description="page new Link") @RequestParam(value="link") String link) {
        try {
            this.pageLayoutService.updatePageLink(PageKey.parse((String)pageRef), link, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PatchMapping(value={"permissions"})
    @Secured(value={"users"})
    @Operation(summary="Update a page access and edit permission", method="PATCH", description="This updates the given page access and edit permission")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page permissions updated"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Page not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void updatePagePermissions(HttpServletRequest request, @Parameter(description="Page reference", required=true) @RequestParam(value="pageRef") String pageRef, @RequestBody PermissionUpdateModel permissionUpdateModel) {
        try {
            this.pageLayoutService.updatePagePermissions(PageKey.parse((String)pageRef), permissionUpdateModel, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }
}

