/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.PortalHttpServletResponseWrapper;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.RouterConfigException;
import org.gatein.common.http.QueryStringParser;
import org.gatein.common.util.ParameterMap;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="The portal controller")
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="controller")})
@RESTEndpoint(path="portalcontroller")
public class WebAppController
implements Startable {
    public static final QualifiedName HANDLER_PARAM = QualifiedName.create("gtn", "handler");
    protected static Log log = ExoLogger.getLogger(WebAppController.class);
    private final HashMap<String, Object> attributes_;
    private volatile HashMap<String, Application> applications_;
    private final HashMap<String, WebRequestHandler> handlers;
    private final AtomicReference<Router> routerRef;
    private final AtomicReference<String> configurationPathRef;

    public WebAppController(InitParams params) throws Exception {
        ValueParam routerConfig = params.getValueParam("controller.config");
        if (routerConfig == null) {
            throw new IllegalArgumentException("No router param defined");
        }
        String configurationPath = routerConfig.getValue();
        this.applications_ = new HashMap();
        this.attributes_ = new HashMap();
        this.handlers = new HashMap();
        this.routerRef = new AtomicReference();
        this.configurationPathRef = new AtomicReference<String>(configurationPath);
        this.reloadConfiguration();
    }

    public Object getAttribute(String name, Object value) {
        return this.attributes_.get(name);
    }

    public <T extends Application> T getApplication(String appId) {
        return (T)((Object)this.applications_.get(appId));
    }

    public List<Application> getApplicationByType(String type) {
        ArrayList<Application> applications = new ArrayList<Application>();
        for (Application app : this.applications_.values()) {
            if (!app.getApplicationType().equals(type)) continue;
            applications.add(app);
        }
        return applications;
    }

    public synchronized void removeApplication(String appId) {
        this.applications_.remove(appId);
    }

    @Managed
    @ManagedDescription(value="The configuration path")
    public String getConfigurationPath() {
        return String.valueOf(this.configurationPathRef.get());
    }

    @Managed
    @ManagedDescription(value="Load the controller configuration")
    @Impact(value=ImpactType.WRITE)
    public void loadConfiguration(@ManagedDescription(value="The configuration path") @ManagedName(value="path") String path) throws IOException, RouterConfigException {
        File f = new File(path);
        if (!f.exists()) {
            throw new MalformedURLException("Could not resolve path " + path);
        }
        if (!f.isFile()) {
            throw new MalformedURLException("Could not resolve path " + path + " to a valid file");
        }
        this.loadConfiguration(f.toURI().toURL());
        this.configurationPathRef.set(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfiguration(URL url) throws RouterConfigException, IOException {
        log.info((Object)("Loading router configuration " + url));
        InputStream in = url.openStream();
        try {
            ControllerDescriptor routerDesc = new DescriptorBuilder().build(in);
            Router router = new Router(routerDesc);
            this.routerRef.set(router);
        }
        finally {
            Safe.close((Closeable)in);
        }
    }

    @Managed
    @ManagedDescription(value="Reload the controller configuration")
    @Impact(value=ImpactType.WRITE)
    public void reloadConfiguration() throws RouterConfigException, IOException {
        log.info((Object)("Loading router configuration " + this.configurationPathRef.get()));
        this.loadConfiguration(this.configurationPathRef.get());
    }

    @Managed
    @ManagedDescription(value="Enumerates the routes found for the specified request")
    @Impact(value=ImpactType.READ)
    public String findRoutes(@ManagedDescription(value="The request uri relative to the web application") @ManagedName(value="uri") String uri) {
        Router router = this.routerRef.get();
        if (router != null) {
            String path;
            ParameterMap parameters;
            int pos = uri.indexOf(63);
            if (pos != -1) {
                parameters = QueryStringParser.getInstance().parseQueryString(uri.substring(pos + 1));
                path = uri.substring(0, pos);
            } else {
                parameters = Collections.emptyMap();
                path = uri;
            }
            ArrayList<Map<QualifiedName, String>> results = new ArrayList<Map<QualifiedName, String>>();
            Iterator<Map<QualifiedName, String>> matcher = router.matcher(path, (Map<String, String[]>)parameters);
            while (matcher.hasNext()) {
                Map<QualifiedName, String> match = matcher.next();
                results.add(match);
            }
            return ((Object)results).toString();
        }
        throw new IllegalStateException("No route currently configured");
    }

    public WebRequestHandler getHandler(String handlerName) {
        return this.handlers.get(handlerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Application> T addApplication(T app) {
        T result = this.getApplication(app.getApplicationId());
        if (result == null) {
            WebAppController webAppController = this;
            synchronized (webAppController) {
                result = this.getApplication(app.getApplicationId());
                if (result == null) {
                    HashMap<String, Application> temporalApplicationsMap = new HashMap<String, Application>(this.applications_);
                    temporalApplicationsMap.put(app.getApplicationId(), app);
                    this.applications_ = temporalApplicationsMap;
                    result = app;
                }
            }
        }
        return result;
    }

    public void register(WebRequestHandler handler) {
        this.handlers.put(handler.getHandlerName(), handler);
    }

    public void unregister(String[] paths) {
        for (String path : paths) {
            WebRequestHandler handler = this.handlers.remove(path);
            handler.onDestroy(this);
        }
    }

    public void onHandlersInit(ServletConfig config) throws Exception {
        Collection<WebRequestHandler> hls = this.handlers.values();
        for (WebRequestHandler handler : hls) {
            handler.onInit(this, config);
        }
    }

    public Router getRouter() {
        return this.routerRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse res) throws Exception {
        boolean debug = log.isDebugEnabled();
        try {
            req.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Encoding not supported", (Throwable)e);
        }
        String portalPath = req.getRequestURI().substring(req.getContextPath().length());
        Router router = this.routerRef.get();
        if (router != null) {
            Iterator<Map<QualifiedName, String>> matcher = router.matcher(portalPath, req.getParameterMap());
            boolean started = false;
            boolean processed = false;
            try {
                while (matcher.hasNext() && !processed) {
                    Map<QualifiedName, String> parameters = matcher.next();
                    String handlerKey = parameters.get(HANDLER_PARAM);
                    if (handlerKey == null) continue;
                    WebRequestHandler handler = this.handlers.get(handlerKey);
                    if (handler != null) {
                        if (debug) {
                            log.debug((Object)("Serving request path=" + portalPath + ", parameters=" + parameters + " with handler " + handler));
                        }
                        if (!started && handler.getRequiresLifeCycle()) {
                            started = true;
                            ExoContainer container = ExoContainerContext.getCurrentContainer();
                            if (debug) {
                                log.debug((Object)("Starting RequestLifeCycle for handler " + handler));
                                if (!(container instanceof PortalContainer)) {
                                    log.debug((Object)("current container is " + container + ", it should be a PortalContainer instance to start a portal request lifecycle"));
                                }
                            }
                            RequestLifeCycle.begin((ExoContainer)container);
                        }
                        PortalHttpServletResponseWrapper httpServletResponseWrapper = new PortalHttpServletResponseWrapper(res);
                        processed = handler.execute(new ControllerContext(this, router, req, (HttpServletResponse)httpServletResponseWrapper, parameters));
                        continue;
                    }
                    if (!debug) continue;
                    log.debug((Object)("No handler " + handlerKey + " for request path=" + portalPath + ", parameters=" + parameters));
                }
            }
            finally {
                if (started) {
                    if (debug) {
                        log.debug((Object)"Finishing RequestLifeCycle for current request");
                    }
                    RequestLifeCycle.end();
                }
            }
            if (!processed) {
                log.error((Object)("Could not associate the request path=" + portalPath + " with an handler"));
                res.sendError(404);
            }
        } else {
            log.error((Object)("Missing valid router configuration " + this.configurationPathRef.get()));
            res.sendError(500);
        }
    }

    public void start() {
    }

    public void stop() {
        for (WebRequestHandler handler : this.handlers.values()) {
            handler.onDestroy(this);
        }
    }
}

