/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.core.activity.ActivityFilter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ActivityDAOImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.entity.ActivityEntity;
import org.exoplatform.social.core.jpa.storage.entity.StreamType;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.ActivityStorageException;

public class ActivityDAOImpl
extends GenericDAOJPAImpl<ActivityEntity, Long>
implements ActivityDAO {
    private static final String STREAM_TYPE = "streamType";
    private static final String QUERY_FILTER_FIND_PREFIX = "SocActivity.findAllActivities";
    private static final String QUERY_FILTER_COUNT_PREFIX = "SocActivity.countAllActivities";
    private final Map<String, Boolean> filterNamedQueries = new HashMap<String, Boolean>();
    private final ConnectionDAO connectionDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ActivityDAOImpl(ConnectionDAO connectionDAO) {
        this.connectionDAO = connectionDAO;
    }

    @Override
    public List<Long> getActivities(Identity owner, Identity viewer, long offset, long limit) throws ActivityStorageException {
        long ownerId = Long.parseLong(owner.getId());
        TypedQuery query = null;
        if (viewer != null && !viewer.getId().equals(owner.getId())) {
            query = this.getEntityManager().createNamedQuery("SocActivity.getActivityByOwnerAndProviderId", Tuple.class);
            query.setParameter("providerId", (Object)"organization");
        } else {
            query = this.getEntityManager().createNamedQuery("SocActivity.getActivityByOwner", Tuple.class);
        }
        query.setParameter("owners", Collections.singleton(ownerId));
        if (limit > 0L) {
            query.setFirstResult(offset > 0L ? (int)offset : 0);
            query.setMaxResults((int)limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public List<String> getUserIdsActivities(Identity owner, long offset, long limit) throws ActivityStorageException {
        long ownerId = Long.parseLong(owner.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getActivityIdsByOwner", Tuple.class);
        query.setParameter("owner", (Object)ownerId);
        if (limit > 0L) {
            query.setFirstResult(offset > 0L ? (int)offset : 0);
            query.setMaxResults((int)limit);
        }
        return this.convertActivityEntitiesToIdsString(query.getResultList());
    }

    @Override
    public List<Long> getActivityFeed(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        Object queryName = "SocActivity.getActivityFeed";
        if (connections.isEmpty()) {
            queryName = (String)queryName + "NoConnections";
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery((String)queryName, Tuple.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("owners", owners);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public List<Long> getActivityByFilter(ActivityFilter activityFilter, List<String> spaceIdentityIds, int offset, int limit) {
        TypedQuery<Tuple> query = this.buildQueryFromFilter(activityFilter, spaceIdentityIds, Tuple.class, false);
        if (limit > 0) {
            query.setFirstResult(Math.max(offset, 0));
            query.setMaxResults(limit);
        }
        if (limit > 0) {
            query.setFirstResult(Math.max(offset, 0));
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public List<String> getActivityIdsByFilter(ActivityFilter activityFilter, List<String> spaceIdentityIds, int offset, int limit) {
        TypedQuery<Tuple> query = this.buildQueryFromFilter(activityFilter, spaceIdentityIds, Tuple.class, false);
        if (limit > 0) {
            query.setFirstResult(Math.max(offset, 0));
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIdsString(resultList);
    }

    @Override
    public int getActivitiesCountByFilter(ActivityFilter activityFilter, List<String> spaceIdentityIds) {
        TypedQuery<Long> query = this.buildQueryFromFilter(activityFilter, spaceIdentityIds, Long.class, true);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<String> getActivityIdsFeed(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        Object queryName = "SocActivity.getActivityIdsFeed";
        if (connections.isEmpty()) {
            queryName = (String)queryName + "NoConnections";
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery((String)queryName, Tuple.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter(STREAM_TYPE, (Object)StreamType.POSTER);
        }
        query.setParameter("owners", owners);
        query.setParameter("streamTypes", Arrays.asList(StreamType.POSTER, StreamType.SPACE));
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return this.convertActivityEntitiesToIdsString(query.getResultList());
    }

    @Override
    public int getNumberOfActivitesOnActivityFeed(Identity ownerIdentity, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        Object queryName = "SocActivity.getNumberOfActivitesOnActivityFeed";
        if (connections.isEmpty()) {
            queryName = (String)queryName + "NoConnections";
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        for (String id : spaceIds) {
            owners.add(Long.parseLong(id));
        }
        owners.add(ownerId);
        TypedQuery query = this.getEntityManager().createNamedQuery((String)queryName, Long.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getNewerOnActivityFeed(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        Object queryName = "SocActivity.getNewerActivityFeed";
        if (connections.isEmpty()) {
            queryName = (String)queryName + "NoConnections";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery((String)queryName, Tuple.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public int getNumberOfNewerOnActivityFeed(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        Object queryName = "SocActivity.getNumberOfNewerOnActivityFeed";
        if (connections.isEmpty()) {
            queryName = (String)queryName + "NoConnections";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery((String)queryName, Long.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getOlderOnActivityFeed(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.parseLong(id));
            }
        }
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        Object queryName = "SocActivity.getOlderActivityFeed";
        if (connections.isEmpty()) {
            queryName = (String)queryName + "NoConnections";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery((String)queryName, Tuple.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public int getNumberOfOlderOnActivityFeed(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        Object queryName = "SocActivity.getNumberOfOlderOnActivityFeed";
        if (connections.isEmpty()) {
            queryName = (String)queryName + "NoConnections";
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        owners.add(ownerId);
        if (spaceIds != null && !spaceIds.isEmpty()) {
            for (String id : spaceIds) {
                owners.add(Long.valueOf(id));
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery((String)queryName, Long.class);
        if (!connections.isEmpty()) {
            query.setParameter("connections", connections);
            query.setParameter("connStreamType", (Object)StreamType.POSTER);
        }
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getUserActivities(Identity owner, long offset, long limit) throws ActivityStorageException {
        return this.getOwnerActivities(Arrays.asList(owner.getId()), -1L, -1L, offset, limit);
    }

    @Override
    public int getNumberOfUserActivities(Identity ownerIdentity) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfActivitiesByOwner", Long.class);
        query.setParameter("owner", (Object)ownerId);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getNewerOnUserActivities(Identity ownerIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(ownerIdentity.getId()), sinceTime, -1L, 0L, limit);
    }

    @Override
    public int getNumberOfNewerOnUserActivities(Identity ownerIdentity, long sinceTime) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfNewerActivityByOwner", Long.class);
        query.setParameter("owner", (Object)ownerId);
        query.setParameter("sinceTime", (Object)sinceTime);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getOlderOnUserActivities(Identity ownerIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(ownerIdentity.getId()), -1L, sinceTime, 0L, limit);
    }

    @Override
    public int getNumberOfOlderOnUserActivities(Identity ownerIdentity, long sinceTime) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfOlderActivityByOwner", Long.class);
        query.setParameter("owner", (Object)ownerId);
        query.setParameter("sinceTime", (Object)sinceTime);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getSpaceActivities(Identity spaceOwner, long offset, long limit) throws ActivityStorageException {
        return this.getOwnerActivities(Arrays.asList(spaceOwner.getId()), -1L, -1L, offset, limit);
    }

    @Override
    public List<String> getSpaceActivityIds(Identity spaceIdentity, long offset, long limit) throws ActivityStorageException {
        long ownerId = Long.parseLong(spaceIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getSpacesActivityIds", Tuple.class);
        query.setParameter("owners", Collections.singleton(ownerId));
        query.setParameter(STREAM_TYPE, (Object)StreamType.SPACE);
        if (limit > 0L) {
            query.setFirstResult(offset > 0L ? (int)offset : 0);
            query.setMaxResults((int)limit);
        }
        return this.convertActivityEntitiesToIdsString(query.getResultList());
    }

    @Override
    public int getNumberOfSpaceActivities(Identity spaceIdentity) {
        long ownerId = Long.parseLong(spaceIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfActivitiesByOwner", Long.class);
        query.setParameter("owner", (Object)ownerId);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getNewerOnSpaceActivities(Identity spaceIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(spaceIdentity.getId()), sinceTime, -1L, 0L, limit);
    }

    @Override
    public int getNumberOfNewerOnSpaceActivities(Identity spaceIdentity, long sinceTime) {
        long ownerId = Long.parseLong(spaceIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfNewerOnActivityFeedNoConnections", Long.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", Collections.singleton(ownerId));
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getOlderOnSpaceActivities(Identity spaceIdentity, long sinceTime, int limit) {
        return this.getOwnerActivities(Arrays.asList(spaceIdentity.getId()), -1L, sinceTime, 0L, limit);
    }

    @Override
    public int getNumberOfOlderOnSpaceActivities(Identity spaceIdentity, long sinceTime) {
        long ownerId = Long.parseLong(spaceIdentity.getId());
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfOlderOnActivityFeedNoConnections", Long.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", Collections.singleton(ownerId));
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getUserSpacesActivities(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return this.getOwnerActivities(spaceIds, -1L, -1L, offset, limit);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getUserSpacesActivityIds(Identity ownerIdentity, int offset, int limit, List<String> spaceIds) {
        if (spaceIds.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String id : spaceIds) {
            ids.add(Long.parseLong(id));
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getSpacesActivityIds", Tuple.class);
        query.setParameter("owners", ids);
        query.setParameter(STREAM_TYPE, (Object)StreamType.SPACE);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return this.convertActivityEntitiesToIdsString(query.getResultList());
    }

    @Override
    public int getNumberOfUserSpacesActivities(Identity ownerIdentity, List<String> spaceIds) {
        if (spaceIds.size() == 0) {
            return 0;
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        for (String id : spaceIds) {
            owners.add(Long.parseLong(id));
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfActivitesOnActivityFeedNoConnections", Long.class);
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getNewerOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return this.getOwnerActivities(spaceIds, sinceTime, -1L, 0L, limit);
        }
        return Collections.emptyList();
    }

    @Override
    public int getNumberOfNewerOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        if (spaceIds.size() == 0) {
            return 0;
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        for (String id : spaceIds) {
            owners.add(Long.parseLong(id));
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfNewerOnActivityFeedNoConnections", Long.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getOlderOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, int limit, List<String> spaceIds) {
        if (spaceIds.size() > 0) {
            return this.getOwnerActivities(spaceIds, -1L, sinceTime, 0L, limit);
        }
        return Collections.emptyList();
    }

    @Override
    public int getNumberOfOlderOnUserSpacesActivities(Identity ownerIdentity, long sinceTime, List<String> spaceIds) {
        if (spaceIds.size() == 0) {
            return 0;
        }
        ArrayList<Long> owners = new ArrayList<Long>();
        for (String id : spaceIds) {
            owners.add(Long.parseLong(id));
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfOlderOnActivityFeedNoConnections", Long.class);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("owners", owners);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getActivitiesOfConnections(Identity ownerIdentity, int offset, int limit) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        if (connections.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getActivityOfConnection", Tuple.class);
        query.setParameter("connections", connections);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public List<String> getActivityIdsOfConnections(Identity ownerIdentity, int offset, int limit) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        if (connections.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getActivityIdsOfConnections", Tuple.class);
        query.setParameter("connections", connections.stream().map(id -> id.toString()).collect(Collectors.toSet()));
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        if (limit > 0) {
            query.setFirstResult(offset > 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return this.convertActivityEntitiesToIdsString(query.getResultList());
    }

    @Override
    public int getNumberOfActivitiesOfConnections(Identity ownerIdentity) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        if (connections.isEmpty()) {
            return 0;
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.numberOfActivitiesOfConnections", Long.class);
        query.setParameter("connections", connections.stream().map(id -> id.toString()).collect(Collectors.toSet()));
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getNewerOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime, long limit) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        if (connections.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNewerActivityOfConnection", Tuple.class);
        query.setParameter("connections", connections);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        query.setParameter("sinceTime", (Object)sinceTime);
        if (limit > 0L) {
            query.setFirstResult(0);
            query.setMaxResults((int)limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public int getNumberOfNewerOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        if (connections.isEmpty()) {
            return 0;
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfNewerOnActivitiesOfConnections", Long.class);
        query.setParameter("connections", connections);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getOlderOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime, int limit) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        if (connections.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getOlderActivityOfConnection", Tuple.class);
        query.setParameter("connections", connections);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        query.setParameter("sinceTime", (Object)sinceTime);
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public int getNumberOfOlderOnActivitiesOfConnections(Identity ownerIdentity, long sinceTime) {
        long ownerId = Long.parseLong(ownerIdentity.getId());
        Set<Long> connections = this.connectionDAO.getConnectionIds(ownerId, Relationship.Type.CONFIRMED);
        if (connections.isEmpty()) {
            return 0;
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getNumberOfOlderOnActivitiesOfConnections", Long.class);
        query.setParameter("connections", connections);
        query.setParameter("sinceTime", (Object)sinceTime);
        query.setParameter("connStreamType", (Object)StreamType.POSTER);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<Long> getActivitiesByPoster(Identity posterIdentity, int offset, int limit, String ... activityTypes) {
        Object queryName = "SocActivity.getActivitiesByPoster";
        ArrayList<String> types = new ArrayList<String>();
        if (activityTypes != null && activityTypes.length > 0) {
            types.addAll(Arrays.asList(activityTypes));
        } else {
            queryName = (String)queryName + "NoTypes";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery((String)queryName, Tuple.class);
        if (!types.isEmpty()) {
            query.setParameter("types", types);
        }
        query.setParameter("owner", (Object)posterIdentity.getId());
        if (limit > 0) {
            query.setFirstResult(0);
            query.setMaxResults(limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public int getNumberOfActivitiesByPoster(Identity posterIdentity, String ... activityTypes) {
        Object queryName = "SocActivity.getNumberOfActivitiesByPoster";
        ArrayList<String> types = new ArrayList<String>();
        if (activityTypes != null && activityTypes.length > 0) {
            types.addAll(Arrays.asList(activityTypes));
        } else {
            queryName = (String)queryName + "NoTypes";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery((String)queryName, Long.class);
        if (!types.isEmpty()) {
            query.setParameter("types", types);
        }
        query.setParameter("owner", (Object)posterIdentity.getId());
        return ((Long)query.getSingleResult()).intValue();
    }

    private List<Long> convertActivityEntitiesToIds(List<Tuple> list) {
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
        if (list == null) {
            return Collections.emptyList();
        }
        for (Tuple t : list) {
            ids.add((Long)t.get(0));
        }
        return new LinkedList<Long>(ids);
    }

    private List<String> convertActivityEntitiesToIdsString(List<Tuple> list) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        if (list == null) {
            return Collections.emptyList();
        }
        for (Tuple t : list) {
            ids.add(String.valueOf(t.get(0)));
        }
        return new LinkedList<String>(ids);
    }

    @Override
    public long getNumberOfComments(long activityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.numberCommentsOfActivity", Long.class);
        query.setParameter("activityId", (Object)activityId);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<ActivityEntity> findCommentsOfActivities(List<Long> ids) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findCommentsOfActivities", ActivityEntity.class);
        query.setParameter("ids", ids);
        return query.getResultList();
    }

    @Override
    public List<ActivityEntity> findCommentsAndSubCommentsOfActivity(Long activityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findCommentsAndSubCommentsOfActivity", ActivityEntity.class);
        query.setParameter("activityId", (Object)activityId);
        return query.getResultList();
    }

    @Override
    public List<ActivityEntity> getComments(long activityId, int offset, int limit, boolean sortDescending) {
        String queryString = sortDescending ? "SocActivity.findLastCommentsOfActivity" : "SocActivity.findCommentsOfActivity";
        TypedQuery query = this.getEntityManager().createNamedQuery(queryString, ActivityEntity.class);
        query.setParameter("activityId", (Object)activityId);
        if (limit > 0) {
            query.setFirstResult(offset >= 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<ActivityEntity> getNewerComments(long activityId, Date sinceTime, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findNewerCommentsOfActivity", ActivityEntity.class);
        query.setParameter("activityId", (Object)activityId);
        query.setParameter("sinceTime", (Object)(sinceTime != null ? sinceTime.getTime() : 0L));
        if (limit > 0) {
            query.setFirstResult(offset >= 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<ActivityEntity> getOlderComments(long activityId, Date sinceTime, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findOlderCommentsOfActivity", ActivityEntity.class);
        query.setParameter("activityId", (Object)activityId);
        query.setParameter("sinceTime", (Object)(sinceTime != null ? sinceTime.getTime() : 0L));
        if (limit > 0) {
            query.setFirstResult(offset >= 0 ? offset : 0);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public ActivityEntity getParentActivity(long commentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getParentActivity", ActivityEntity.class);
        query.setParameter("commentId", (Object)commentId);
        query.setMaxResults(1);
        try {
            return (ActivityEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<ActivityEntity> getAllActivities() {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.getAllActivities", ActivityEntity.class);
        return query.getResultList();
    }

    @Override
    @ExoTransactional
    public void deleteActivitiesByOwnerId(String ownerId) {
        String string = ownerId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ActivityDAOImpl$AjcClosure1 activityDAOImpl$AjcClosure1 = new ActivityDAOImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(activityDAOImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public List<Long> getOwnerActivities(List<String> owners, long newerTime, long olderTime, long offset, long limit) throws ActivityStorageException {
        TypedQuery query;
        if (newerTime > 0L) {
            query = this.getEntityManager().createNamedQuery("SocActivity.getNewerActivityByOwner", Tuple.class);
            query.setParameter("sinceTime", (Object)newerTime);
        } else if (olderTime > 0L) {
            query = this.getEntityManager().createNamedQuery("SocActivity.getOlderActivityByOwner", Tuple.class);
            query.setParameter("sinceTime", (Object)olderTime);
        } else {
            query = this.getEntityManager().createNamedQuery("SocActivity.getActivityByOwner", Tuple.class);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String id : owners) {
            ids.add(Long.parseLong(id));
        }
        query.setParameter("owners", ids);
        if (limit > 0L) {
            query.setFirstResult(offset > 0L ? (int)offset : 0);
            query.setMaxResults((int)limit);
        }
        List resultList = query.getResultList();
        return this.convertActivityEntitiesToIds(resultList);
    }

    @Override
    public List<ActivityEntity> findActivities(List<Long> activityIds) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocActivity.findActivities", ActivityEntity.class);
        query.setParameter("ids", activityIds);
        return query.getResultList();
    }

    private <T> TypedQuery<T> buildQueryFromFilter(ActivityFilter activityFilter, List<String> spaceIdentityIds, Class<T> clazz, boolean count) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        this.buildPredicates(activityFilter, spaceIdentityIds, suffixes, predicates);
        String queryName = this.getQueryFilterName(suffixes, count);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, clazz);
        } else {
            String queryContent = this.getQueryFilterContent(predicates, activityFilter.isShowPinned(), count);
            query = this.getEntityManager().createQuery(queryContent, clazz);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(activityFilter, spaceIdentityIds, query);
        return query;
    }

    private <T> void addQueryFilterParameters(ActivityFilter activityFilter, List<String> spaceIdentityIds, TypedQuery<T> query) {
        if (activityFilter.getUserId() != null) {
            query.setParameter("posterId", (Object)activityFilter.getUserId());
        }
        if (activityFilter.getSpaceId() != null) {
            long ownerId = Long.parseLong(activityFilter.getSpaceId());
            query.setParameter(STREAM_TYPE, (Object)StreamType.SPACE);
            query.setParameter("ownerIds", Collections.singleton(ownerId));
        }
        if (CollectionUtils.isNotEmpty(spaceIdentityIds)) {
            ArrayList<Long> owners = new ArrayList<Long>();
            for (String id : spaceIdentityIds) {
                owners.add(Long.parseLong(id));
            }
            query.setParameter(STREAM_TYPE, (Object)StreamType.SPACE);
            query.setParameter("ownerIds", owners);
        }
    }

    private void buildPredicates(ActivityFilter activityFilter, List<String> spaceIdentityIds, List<String> suffixes, List<String> predicates) {
        if (activityFilter.getUserId() != null) {
            suffixes.add("Poster");
            predicates.add("item.activity.posterId = :posterId");
        }
        if (CollectionUtils.isNotEmpty(spaceIdentityIds) || activityFilter.getSpaceId() != null) {
            suffixes.add("StreamType");
            predicates.add("item.streamType = :streamType");
            predicates.add("item.ownerId in (:ownerIds)");
        }
        if (activityFilter.isPinned()) {
            suffixes.add("Pinned");
            predicates.add("item.activity.pinned = true");
        }
    }

    private String getQueryFilterName(List<String> suffixes, boolean count) {
        Object queryName = suffixes.isEmpty() ? (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) : (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) + "By" + StringUtils.join(suffixes, (String)"By");
        return queryName;
    }

    private String getQueryFilterContent(List<String> predicates, boolean showPinned, boolean count) {
        Object querySelect = count ? "SELECT COUNT(item.activity.id)" : "SELECT DISTINCT(item.activity.id), item.activity.pinDate, item.updatedDate";
        querySelect = (String)querySelect + " FROM SocStreamItem item WHERE item.activity.hidden = false";
        String orderBy = showPinned ? " ORDER BY item.activity.pinDate DESC NULLS LAST, item.updatedDate DESC" : " ORDER BY item.updatedDate DESC";
        Object queryContent = predicates.isEmpty() ? querySelect : (String)querySelect + " AND " + StringUtils.join(predicates, (String)" AND ");
        if (!count) {
            queryContent = (String)queryContent + orderBy;
        }
        return queryContent;
    }

    static {
        ActivityDAOImpl.ajc$preClinit();
    }

    static /* synthetic */ void deleteActivitiesByOwnerId_aroundBody0(ActivityDAOImpl ajc$this, String ownerId, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("SocActivity.deleteActivityByOwner");
        query.setParameter("ownerId", (Object)ownerId);
        query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ActivityDAOImpl.java", ActivityDAOImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteActivitiesByOwnerId", "org.exoplatform.social.core.jpa.storage.dao.jpa.ActivityDAOImpl", "java.lang.String", "ownerId", "", "void"), 880);
    }
}

