/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.rest;

import io.meeds.tenant.hub.model.HubReportLocalStatus;
import io.meeds.tenant.hub.service.HubReportService;
import io.meeds.wom.api.constant.WomException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"reports"})
@Tag(name="reports", description="An endpoint to manage current Hub as a WoM member")
public class HubReportController {
    private static final Log LOG = ExoLogger.getLogger(HubReportController.class);
    @Autowired
    private HubReportService reportService;

    @GetMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Retrieves the list of Hub Reward reports", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request")})
    public List<HubReportLocalStatus> getReports(@Parameter(description="Offset of query results", required=true) @RequestParam(value="offset") int offset, @Parameter(description="Limit of query results", required=true) @RequestParam(value="limit") int limit) {
        return this.reportService.getReports(offset, limit);
    }

    @GetMapping(value={"{periodId}"})
    @Secured(value={"rewarding"})
    @Operation(summary="Retrieve a Hub Reward report identified by its id", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request")})
    public HubReportLocalStatus getReport(@Parameter(description="Report period identifier key", required=true) @PathVariable(value="periodId") long periodId, @Parameter(description="Whether refresh from the WoM or not", required=false) @RequestParam(value="refresh") boolean refresh) {
        try {
            return this.reportService.getReport(periodId, refresh);
        }
        catch (WomException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }

    @PutMapping(value={"{periodId}"})
    @Secured(value={"rewarding"})
    @Operation(summary="Send manually Hub reward report to the UEM engine", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request")})
    public HubReportLocalStatus sendReport(@Parameter(description="Report period identifier key", required=true) @PathVariable(value="periodId") long periodId) {
        try {
            return this.reportService.sendReport(periodId);
        }
        catch (WomException e) {
            LOG.warn("Error sending Report for period {} Transaction. Message: {}", new Object[]{periodId, e.getMessage()});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }
}

