/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.dao;

import io.meeds.gamification.twitter.entity.TwitterTweetEntity;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class TwitterTweetDAO
extends GenericDAOJPAImpl<TwitterTweetEntity, Long> {
    public static final String TWEET_LINK = "tweetLink";

    public List<Long> getTweetsIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("TwitterTweets.getTweetsIds", Long.class);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public TwitterTweetEntity getTweetByLink(String tweetLink) {
        TypedQuery query = this.getEntityManager().createNamedQuery("TwitterTweets.getTweetByLink", TwitterTweetEntity.class);
        query.setParameter(TWEET_LINK, (Object)tweetLink);
        try {
            return (TwitterTweetEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

