/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.service.impl;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.twitter.model.RemoteTwitterAccount;
import io.meeds.gamification.twitter.model.Tweet;
import io.meeds.gamification.twitter.model.TwitterAccount;
import io.meeds.gamification.twitter.model.TwitterTrigger;
import io.meeds.gamification.twitter.service.TwitterConsumerService;
import io.meeds.gamification.twitter.service.TwitterService;
import io.meeds.gamification.twitter.storage.TwitterAccountStorage;
import io.meeds.gamification.twitter.storage.TwitterTweetStorage;
import io.meeds.gamification.utils.Utils;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;

public class TwitterServiceImpl
implements TwitterService {
    private static final Log LOG = ExoLogger.getLogger(TwitterServiceImpl.class);
    private static final Scope TWITTER_CONNECTOR_SCOPE = Scope.APPLICATION.id("twitterConnector");
    private static final String BEARER_TOKEN_KEY = "BEARER_TOKEN";
    private final SettingService settingService;
    private final TwitterConsumerService twitterConsumerService;
    private final TwitterAccountStorage twitterAccountStorage;
    private final TwitterTweetStorage twitterTweetStorage;
    private final RuleService ruleService;
    private final CodecInitializer codecInitializer;

    public TwitterServiceImpl(SettingService settingService, TwitterConsumerService twitterConsumerService, TwitterAccountStorage twitterAccountStorage, TwitterTweetStorage twitterTweetStorage, RuleService ruleService, CodecInitializer codecInitializer) {
        this.settingService = settingService;
        this.twitterConsumerService = twitterConsumerService;
        this.twitterAccountStorage = twitterAccountStorage;
        this.twitterTweetStorage = twitterTweetStorage;
        this.ruleService = ruleService;
        this.codecInitializer = codecInitializer;
    }

    @Override
    public List<TwitterAccount> getTwitterAccounts(String currentUser, int offset, int limit, boolean forceUpdate) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access Twitter watched accounts");
        }
        if (forceUpdate) {
            this.twitterConsumerService.clearCache();
        }
        return this.getTwitterAccounts(offset, limit);
    }

    @Override
    public TwitterAccount getTwitterAccountById(long accountId) {
        if (accountId <= 0L) {
            throw new IllegalArgumentException("Twitter account id is mandatory");
        }
        return this.twitterAccountStorage.getTwitterAccountById(accountId);
    }

    @Override
    public TwitterAccount getTwitterAccountById(long accountId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)username)) {
            throw new IllegalAccessException("The user is not authorized to access Twitter watched account");
        }
        TwitterAccount twitterAccount = this.getTwitterAccountById(accountId);
        if (twitterAccount == null) {
            throw new ObjectNotFoundException("Twitter account doesn't exist");
        }
        return twitterAccount;
    }

    @Override
    public List<TwitterAccount> getTwitterAccounts(int offset, int limit) {
        List<Long> hooksIds = this.twitterAccountStorage.getTwitterAccountIds(offset, limit);
        return hooksIds.stream().map(this.twitterAccountStorage::getTwitterAccountById).toList();
    }

    @Override
    public int countTwitterAccounts(String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access Twitter watched accounts");
        }
        return this.twitterAccountStorage.countTwitterAccounts();
    }

    @Override
    public TwitterAccount addTwitterAccount(String twitterUsername, String currentUser) throws ObjectAlreadyExistsException, IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to add a twitter watched account");
        }
        if (this.twitterAccountStorage.countTwitterAccounts() >= 2) {
            throw new IllegalStateException("The maximum number of watched twitter accounts has been reached");
        }
        RemoteTwitterAccount remoteTwitterAccount = this.twitterConsumerService.retrieveTwitterAccount(twitterUsername, this.getTwitterBearerToken(currentUser));
        if (remoteTwitterAccount != null) {
            TwitterAccount existsAccount = this.twitterAccountStorage.getTwitterAccountByRemoteId(remoteTwitterAccount.getId());
            if (existsAccount != null) {
                throw new ObjectAlreadyExistsException((Object)existsAccount);
            }
            TwitterAccount twitterAccount = new TwitterAccount();
            twitterAccount.setIdentifier(remoteTwitterAccount.getUsername());
            twitterAccount.setRemoteId(remoteTwitterAccount.getId());
            twitterAccount.setName(remoteTwitterAccount.getName());
            twitterAccount.setIdentifier(remoteTwitterAccount.getUsername());
            twitterAccount.setWatchedBy(currentUser);
            List<TwitterTrigger> mentionTriggers = this.twitterConsumerService.getMentionEvents(twitterAccount, 0L, this.getTwitterBearerToken());
            if (CollectionUtils.isNotEmpty(mentionTriggers)) {
                twitterAccount.setLastMentionTweetId(mentionTriggers.get(0).getTweetId());
            }
            return this.twitterAccountStorage.addTwitterAccount(twitterAccount);
        }
        return null;
    }

    @Override
    public void deleteTwitterAccount(long twitterAccountId, String currentUser) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to delete Twitter account");
        }
        TwitterAccount twitterAccount = this.twitterAccountStorage.getTwitterAccountById(twitterAccountId);
        if (twitterAccount == null) {
            throw new ObjectNotFoundException("Twitter account with remote id : " + twitterAccountId + " wasn't found");
        }
        this.twitterAccountStorage.deleteTwitterAccount(twitterAccountId);
        this.twitterConsumerService.clearCache(twitterAccount, this.getTwitterBearerToken());
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setEventType("twitter");
        ruleFilter.setIncludeDeleted(true);
        List rules = this.ruleService.getRules(ruleFilter, 0, -1);
        rules.stream().filter(r -> !r.getEvent().getProperties().isEmpty() && r.getEvent().getProperties().get("accountId") != null && ((String)r.getEvent().getProperties().get("accountId")).equals(String.valueOf(twitterAccount.getRemoteId()))).map(RuleDTO::getId).forEach(arg_0 -> ((RuleService)this.ruleService).deleteRuleById(arg_0));
    }

    @Override
    public Tweet addTweetToWatch(String tweetLink) {
        Tweet existsTweet = this.twitterTweetStorage.getTweetByLink(tweetLink);
        if (existsTweet != null) {
            return null;
        }
        Tweet tweet = new Tweet();
        tweet.setTweetLink(tweetLink);
        Set<String> tweetLikers = this.twitterConsumerService.retrieveTweetLikers(tweetLink, this.getTwitterBearerToken());
        if (CollectionUtils.isNotEmpty(tweetLikers)) {
            tweet.setLikers(tweetLikers);
        }
        Set<String> tweetRetweeters = this.twitterConsumerService.retrieveTweetRetweeters(tweetLink, this.getTwitterBearerToken());
        if (CollectionUtils.isNotEmpty(tweetLikers)) {
            tweet.setRetweeters(tweetRetweeters);
        }
        return this.twitterTweetStorage.addTweetToWatch(tweet);
    }

    @Override
    public List<Tweet> getTweets(int offset, int limit) {
        List<Long> tweetsIds = this.twitterTweetStorage.getTweets(offset, limit);
        return tweetsIds.stream().map(this.twitterTweetStorage::getTweetById).toList();
    }

    @Override
    public int countTweets() {
        return this.twitterTweetStorage.countTweets();
    }

    @Override
    public Tweet getTweetByLink(String tweetLink) {
        if (StringUtils.isBlank((CharSequence)tweetLink)) {
            throw new IllegalArgumentException("Tweet link is mandatory");
        }
        return this.twitterTweetStorage.getTweetByLink(tweetLink);
    }

    @Override
    public void deleteTweet(long tweetId) throws ObjectNotFoundException {
        Tweet tweet = this.twitterTweetStorage.getTweetById(tweetId);
        if (tweet == null) {
            throw new ObjectNotFoundException("Tweet with id : " + tweetId + " wasn't found");
        }
        this.twitterTweetStorage.deleteTweet(tweetId);
    }

    @Override
    public void deleteTweetById(long tweetId) {
        try {
            this.deleteTweet(tweetId);
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("Tweet with id {} not found. Continue processing without interrupting current operation.", new Object[]{tweetId, e});
        }
    }

    @Override
    public void saveTwitterBearerToken(String bearerToken, String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to save or update Twitter Bearer Token");
        }
        String encodedBearerToken = this.encode(bearerToken);
        this.settingService.set(Context.GLOBAL, TWITTER_CONNECTOR_SCOPE, BEARER_TOKEN_KEY, SettingValue.create((String)encodedBearerToken));
    }

    @Override
    public void deleteTwitterBearerToken(String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to delete Twitter Bearer Token");
        }
        this.settingService.remove(Context.GLOBAL, TWITTER_CONNECTOR_SCOPE, BEARER_TOKEN_KEY);
    }

    @Override
    public String getTwitterBearerToken(String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to check Twitter Bearer Token status");
        }
        return this.getTwitterBearerToken();
    }

    @Override
    public String getTwitterBearerToken() {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, TWITTER_CONNECTOR_SCOPE, BEARER_TOKEN_KEY);
        if (settingValue != null && settingValue.getValue() != null && StringUtils.isNotBlank((CharSequence)settingValue.getValue().toString())) {
            return this.decode(settingValue.getValue().toString());
        }
        return null;
    }

    @Override
    public void updateAccountLastMentionTweetId(long accountId, long lastMentionTweetId) throws ObjectNotFoundException {
        if (accountId <= 0L) {
            throw new IllegalArgumentException("Account id must be positive");
        }
        TwitterAccount account = this.twitterAccountStorage.getTwitterAccountById(accountId);
        if (account == null) {
            throw new ObjectNotFoundException("Twitter account with id : " + accountId + " wasn't found");
        }
        this.twitterAccountStorage.updateAccountLastMentionTweetId(accountId, lastMentionTweetId);
    }

    @Override
    public void updateTweetReactions(long tweetId, Set<String> likers, Set<String> retweeters) throws ObjectNotFoundException {
        if (tweetId <= 0L) {
            throw new IllegalArgumentException("Tweet id must be positive");
        }
        Tweet tweet = this.twitterTweetStorage.getTweetById(tweetId);
        if (tweet == null) {
            throw new ObjectNotFoundException("Tweet with id : " + tweetId + " wasn't found");
        }
        this.twitterTweetStorage.updateTweetReactions(tweetId, likers, retweeters);
    }

    private String encode(String token) {
        try {
            return this.codecInitializer.getCodec().encode(token);
        }
        catch (TokenServiceInitializationException e) {
            throw new IllegalStateException("Error encrypting token", e);
        }
    }

    private String decode(String encryptedToken) {
        try {
            return this.codecInitializer.getCodec().decode(encryptedToken);
        }
        catch (TokenServiceInitializationException e) {
            throw new IllegalStateException("Error decrypting token", e);
        }
    }
}

