/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ProfilePropertySettingEntity;

@Path(value="v1/social/profile/settings")
@Tag(name="v1/social/profile/settings\"", description="Operations on profile settings")
public class ProfileSettingsRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ProfileSettingsRest.class);
    private static final String GROUP_ADMINISTRATORS = "/platform/administrators";
    private final ProfilePropertyService profilePropertyService;

    public ProfileSettingsRest(ProfilePropertyService profilePropertyService) {
        this.profilePropertyService = profilePropertyService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets all profile settings", method="GET", description="This returns a list of profile settings")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response getPropertySettings(@Context UriInfo uriInfo, @Context Request request) {
        long currentIdentityId = RestUtils.getCurrentUserIdentityId();
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            List<ProfilePropertySetting> properties = this.profilePropertyService.getPropertySettings();
            if (!ConversationState.getCurrent().getIdentity().isMemberOf(GROUP_ADMINISTRATORS)) {
                properties = properties.stream().filter(prop -> prop.isVisible() || prop.isEditable()).toList();
            }
            List unHiddenbaleProperties = this.profilePropertyService.getUnhiddenableProfileProperties();
            List excludedQuickSearchProperties = this.profilePropertyService.getExcludedQuickSearchProperties();
            List<ProfilePropertySettingEntity> propertySettingEntities = EntityBuilder.buildEntityProfilePropertySettingList(properties, this.profilePropertyService, "profileProperty", currentIdentityId);
            HashMap<String, List> settings = new HashMap<String, List>();
            settings.put("settings", propertySettingEntities);
            settings.put("unHiddenableProperties", unHiddenbaleProperties);
            settings.put("excludedQuickSearchProperties", excludedQuickSearchProperties);
            return Response.ok(settings).build();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while getting list of settings", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Operation(summary="Creates a Profile property setting", method="POST", description="\"Creates a Profile property setting.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="409", description="Conflict"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response createPropertySetting(@Context UriInfo uriInfo, @RequestBody(description="Profile property setting object to be created", required=true) ProfilePropertySettingEntity profilePropertySettingEntity) {
        if (profilePropertySettingEntity == null || profilePropertySettingEntity.getPropertyName() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Profile property setting is null or property name not provided").build();
        }
        try {
            ProfilePropertySetting newProperty = this.profilePropertyService.createPropertySetting(EntityBuilder.buildProfilePropertySettingFromEntity(profilePropertySettingEntity, this.profilePropertyService));
            return Response.ok((Object)EntityBuilder.buildEntityProfilePropertySetting(newProperty, this.profilePropertyService, "profileProperty")).build();
        }
        catch (ObjectAlreadyExistsException ex) {
            LOG.warn("Cannot add a property named {}, this name is already used", new Object[]{profilePropertySettingEntity.getPropertyName(), ex});
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to create a new Property setting named {}", new Object[]{profilePropertySettingEntity.getPropertyName(), ex});
            return Response.status((int)500).build();
        }
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Update a Profile property setting", method="PUT", description="\"update a Profile property setting.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response updatePropertySetting(@Context UriInfo uriInfo, @RequestBody(description="Profile property setting object to be updated", required=true) ProfilePropertySettingEntity profilePropertySettingEntity) {
        if (profilePropertySettingEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Profile property setting is null").build();
        }
        try {
            this.profilePropertyService.updatePropertySetting(EntityBuilder.buildProfilePropertySettingFromEntity(profilePropertySettingEntity, this.profilePropertyService));
            return Response.noContent().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to update the Property setting", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }

    @DELETE
    @RolesAllowed(value={"administrators"})
    @Operation(summary="delete a Profile property setting", method="DELETE", description="\"delete a Profile property setting.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response deletePropertySetting(@Context UriInfo uriInfo, @RequestBody(description="Profile property setting object to be updated", required=true) ProfilePropertySettingEntity profilePropertySettingEntity) {
        if (profilePropertySettingEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Profile property setting is null").build();
        }
        try {
            this.profilePropertyService.deleteProfilePropertySetting(profilePropertySettingEntity.getId());
            return Response.noContent().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to update the Property setting", (Throwable)ex);
            return Response.status((int)500).build();
        }
    }
}

