/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO$AjcClosure5;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO$AjcClosure7;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO$AjcClosure9;
import org.exoplatform.social.core.jpa.storage.entity.MetadataItemEntity;
import org.exoplatform.social.metadata.MetadataFilter;

public class MetadataItemDAO
extends GenericDAOJPAImpl<MetadataItemEntity, Long> {
    private static final String PROPERTY_VALUE_PARAM = "propertyValue";
    private static final String PROPERTY_KEY_PARAM = "propertyKey";
    private static final String OBJECT_TYPE_PARAM = "objectType";
    private static final String METADATA_NAME_PARAM = "metadataName";
    private static final String METADATA_TYPE_PARAM = "metadataType";
    private static final String METADATA_ID = "metadataId";
    private static final String METADATA_NAME = "metadataName";
    private static final String METADATA_TYPE = "metadataType";
    private static final String PARENT_OBJECT_ID = "parentObjectId";
    private static final String OBJECT_ID = "objectId";
    private static final String SPACE_ID = "spaceId";
    private static final String SPACE_IDS = "spaceIds";
    private static final String OBJECT_TYPE = "objectType";
    private static final String CREATOR_ID = "creatorId";
    private static final String AUDIENCE_ID = "audienceId";
    private static final String METADATA = "metadata";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String PROPERTIES = "properties";
    private static final String CREATED_DATE = "createdDate";
    private static final String ID = "id";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public List<MetadataItemEntity> getMetadataItemsByObject(String objectType, String objectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByObject", MetadataItemEntity.class);
        query.setParameter("objectType", (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        return query.getResultList();
    }

    public Set<String> getMetadataNamesByObject(String objectType, String objectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataNamesByObject", String.class);
        query.setParameter("objectType", (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptySet() : new HashSet(resultList);
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataAndObject(long metadataId, String objectType, String objectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataAndObject", MetadataItemEntity.class);
        query.setParameter(METADATA_ID, (Object)metadataId);
        query.setParameter("objectType", (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        return query.getResultList();
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataTypeAndObject(long metadataType, String objectType, String objectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndObject", MetadataItemEntity.class);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter("objectType", (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        return query.getResultList();
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(String metadataName, long metadataType, String objectType, String propertyKey, String propertyValue, long offset, long limit) {
        try {
            TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty", MetadataItemEntity.class);
            query.setParameter("metadataType", (Object)metadataType);
            query.setParameter("metadataName", (Object)metadataName);
            query.setParameter("objectType", (Object)objectType);
            query.setParameter(PROPERTY_KEY_PARAM, (Object)propertyKey);
            query.setParameter(PROPERTY_VALUE_PARAM, (Object)propertyValue);
            if (offset > 0L) {
                query.setFirstResult((int)offset);
            }
            if (limit > 0L) {
                query.setMaxResults((int)limit);
            }
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataNameAndTypeAndObject(String metadataName, long metadataType, String objectType, long offset, long limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndNameAndObject", MetadataItemEntity.class);
        query.setParameter("metadataName", (Object)metadataName);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter("objectType", (Object)objectType);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataNameAndTypeAndObject(String metadataName, long metadataType, String objectType, String objectId, long offset, long limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndNameAndObjectTypeAndId", MetadataItemEntity.class);
        query.setParameter("metadataName", (Object)metadataName);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter("objectType", (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataNameAndTypeAndSpaceIds(String metadataName, long metadataType, List<Long> spaceIds, long offset, long limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataNameAndTypeAndSpaceIds", MetadataItemEntity.class);
        query.setParameter("metadataName", (Object)metadataName);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter(SPACE_IDS, spaceIds);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceIds(String metadataName, long metadataType, String objectType, List<Long> spaceIds, long offset, long limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndNameAndObjectAndSpaceIds", MetadataItemEntity.class);
        query.setParameter("metadataName", (Object)metadataName);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter("objectType", (Object)objectType);
        query.setParameter(SPACE_IDS, spaceIds);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    public List<MetadataItemEntity> getMetadataItemsByFilter(MetadataFilter filter, long metadataType, long offset, long limit) {
        List resultList;
        Query query = this.buildMetadataFilterQuery(filter, metadataType);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<MetadataItemEntity> getMetadataItemsByTypeAndSpaceIdAndCreatorId(long metadataType, long spaceId, long creatorId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByTypeAndSpaceIdAndCreatorId", MetadataItemEntity.class);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter(CREATOR_ID, (Object)creatorId);
        query.setParameter(SPACE_ID, (Object)spaceId);
        List result = query.getResultList();
        return result == null ? Collections.emptyList() : result;
    }

    public List<MetadataItemEntity> getMetadataItemsByMetadataTypeAndCreator(long metadataType, long creatorId, long offset, long limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataItemsByMetadataTypeAndCreator", MetadataItemEntity.class);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter(CREATOR_ID, (Object)creatorId);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return query.getResultList();
    }

    public int countMetadataItemsByMetadataTypeAndCreator(long metadataType, long creatorId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.countMetadataItemsByMetadataTypeAndCreator", Long.class);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter(CREATOR_ID, (Object)creatorId);
        return ((Long)query.getSingleResult()).intValue();
    }

    public List<Tuple> countMetadataItemsByMetadataTypeAndAudienceId(long metadataType, long creatorId, long spaceId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.countMetadataItemsByMetadataTypeAndAudienceId", Tuple.class);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter(CREATOR_ID, (Object)creatorId);
        query.setParameter(SPACE_ID, (Object)spaceId);
        List result = query.getResultList();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return Collections.emptyList();
        }
        return result;
    }

    public Map<Long, Long> countMetadataItemsByMetadataTypeAndSpacesIdAndCreatorId(long metadataType, long creatorId, List<Long> spaceIds) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.countMetadataItemsByMetadataTypeAndSpacesIdAndCreatorId", Tuple.class);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter(AUDIENCE_ID, (Object)creatorId);
        query.setParameter(SPACE_IDS, spaceIds);
        Map<Long, Long> result = query.getResultList().stream().collect(Collectors.toMap(t -> (Long)t.get(0, Long.class), t -> (Long)t.get(1, Long.class)));
        if (MapUtils.isEmpty(result)) {
            return Collections.emptyMap();
        }
        return result;
    }

    public List<String> getMetadataObjectIds(long metadataType, String metadataName, String objectType, long offset, long limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataObjectIds", Tuple.class);
        query.setParameter("metadataType", (Object)metadataType);
        query.setParameter("metadataName", (Object)metadataName);
        query.setParameter("objectType", (Object)objectType);
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().map(tuple -> (String)tuple.get(0)).distinct().toList();
    }

    @ExoTransactional
    public int deleteMetadataItemsByObject(String objectType, String objectId) {
        String string = objectType;
        String string2 = objectId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        MetadataItemDAO$AjcClosure1 metadataItemDAO$AjcClosure1 = new MetadataItemDAO$AjcClosure1(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(metadataItemDAO$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public int deleteMetadataItemsByParentObject(String objectType, String parentObjectId) {
        String string = objectType;
        String string2 = parentObjectId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        MetadataItemDAO$AjcClosure3 metadataItemDAO$AjcClosure3 = new MetadataItemDAO$AjcClosure3(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(metadataItemDAO$AjcClosure3.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public int deleteMetadataItemById(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        MetadataItemDAO$AjcClosure5 metadataItemDAO$AjcClosure5 = new MetadataItemDAO$AjcClosure5(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(metadataItemDAO$AjcClosure5.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public int deleteMetadataItemsBySpaceId(long spaceId) {
        long l = spaceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        MetadataItemDAO$AjcClosure7 metadataItemDAO$AjcClosure7 = new MetadataItemDAO$AjcClosure7(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(metadataItemDAO$AjcClosure7.linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public int deleteMetadataItemsBySpaceIdAndAudienceId(long spaceId, long audienceId) {
        long l = spaceId;
        long l2 = audienceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.longObject((long)l), (Object)Conversions.longObject((long)l2));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), Conversions.longObject((long)l2), joinPoint};
        MetadataItemDAO$AjcClosure9 metadataItemDAO$AjcClosure9 = new MetadataItemDAO$AjcClosure9(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(metadataItemDAO$AjcClosure9.linkClosureAndJoinPoint(69648)));
    }

    private Query buildMetadataFilterQuery(MetadataFilter filter, long metadataType) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(MetadataItemEntity.class);
        Root root = criteriaQuery.from(MetadataItemEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(criteriaBuilder.equal((Expression)root.get(METADATA).get(TYPE), (Object)metadataType));
        predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(METADATA).get(NAME), (Object)filter.getMetadataName())}));
        if (!CollectionUtils.isEmpty((Collection)filter.getMetadataObjectTypes())) {
            predicates.add(criteriaBuilder.and(new Predicate[]{root.get("objectType").in((Collection)filter.getMetadataObjectTypes())}));
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getMetadataSpaceIds())) {
            predicates.add(criteriaBuilder.and(new Predicate[]{root.get(SPACE_ID).in((Collection)filter.getMetadataSpaceIds())}));
        }
        if (filter.getCreatorId() != null) {
            predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(CREATOR_ID), (Object)filter.getCreatorId())}));
        }
        if (!MapUtils.isEmpty((Map)filter.getMetadataProperties())) {
            Join metadata = root.join(METADATA, JoinType.INNER);
            MapJoin metadataItemProp = root.joinMap(PROPERTIES, JoinType.INNER);
            predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)metadata.get(TYPE), (Object)metadataType)}));
            predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)metadata.get(NAME), (Object)filter.getMetadataName())}));
            filter.getMetadataProperties().forEach((key, value) -> {
                predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)metadataItemProp.key(), key)}));
                predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)metadataItemProp.value(), value)}));
            });
        }
        criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[0]));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(CREATED_DATE)), criteriaBuilder.desc((Expression)root.get(ID))});
        return this.getEntityManager().createQuery(criteriaQuery);
    }

    static {
        MetadataItemDAO.ajc$preClinit();
    }

    static /* synthetic */ int deleteMetadataItemsByObject_aroundBody0(MetadataItemDAO ajc$this, String objectType, String objectId, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("SocMetadataItemEntity.deleteMetadataItemsByObject");
        query.setParameter("objectType", (Object)objectType);
        query.setParameter(OBJECT_ID, (Object)objectId);
        return query.executeUpdate();
    }

    static /* synthetic */ int deleteMetadataItemsByParentObject_aroundBody2(MetadataItemDAO ajc$this, String objectType, String parentObjectId, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("SocMetadataItemEntity.deleteMetadataItemsByParentObject");
        query.setParameter("objectType", (Object)objectType);
        query.setParameter(PARENT_OBJECT_ID, (Object)parentObjectId);
        return query.executeUpdate();
    }

    static /* synthetic */ int deleteMetadataItemById_aroundBody4(MetadataItemDAO ajc$this, long id, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("SocMetadataItemEntity.deleteMetadataItemById");
        query.setParameter(ID, (Object)id);
        return query.executeUpdate();
    }

    static /* synthetic */ int deleteMetadataItemsBySpaceId_aroundBody6(MetadataItemDAO ajc$this, long spaceId, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("SocMetadataItemEntity.deleteMetadataItemsBySpaceId");
        query.setParameter(SPACE_ID, (Object)spaceId);
        return query.executeUpdate();
    }

    static /* synthetic */ int deleteMetadataItemsBySpaceIdAndAudienceId_aroundBody8(MetadataItemDAO ajc$this, long spaceId, long audienceId, JoinPoint joinPoint) {
        TypedQuery query = ajc$this.getEntityManager().createNamedQuery("SocMetadataItemEntity.getMetadataBySpaceIdAndAudienceId", MetadataItemEntity.class);
        query.setParameter(SPACE_ID, (Object)spaceId);
        query.setParameter(AUDIENCE_ID, (Object)audienceId);
        List items = query.getResultList();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            ajc$this.deleteAll(items);
        }
        return items.size();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MetadataItemDAO.java", MetadataItemDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteMetadataItemsByObject", "org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO", "java.lang.String:java.lang.String", "objectType:objectId", "", "int"), 356);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteMetadataItemsByParentObject", "org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO", "java.lang.String:java.lang.String", "objectType:parentObjectId", "", "int"), 364);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteMetadataItemById", "org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO", "long", ID, "", "int"), 372);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteMetadataItemsBySpaceId", "org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO", "long", SPACE_ID, "", "int"), 379);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteMetadataItemsBySpaceIdAndAudienceId", "org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataItemDAO", "long:long", "spaceId:audienceId", "", "int"), 386);
    }
}

