/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import java.util.Date;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.relationship.model.Relationship;

@Entity(name="SocConnection")
@ExoEntity
@Table(name="SOC_CONNECTIONS", uniqueConstraints={@UniqueConstraint(columnNames={"SENDER_ID", "RECEIVER_ID"})})
@NamedQueries(value={@NamedQuery(name="getRelationships", query="select r from SocConnection r"), @NamedQuery(name="SocConnection.findConnectionsByIdentityIds", query="SELECT c FROM SocConnection c WHERE (c.sender.id = :identityId AND c.receiver.id in (:ids) ) OR (c.receiver.id = :identityId AND c.sender.id in (:ids) )"), @NamedQuery(name="SocConnection.findConnectionBySenderAndReceiver", query="SELECT c FROM SocConnection c WHERE c.sender.id = :sender AND c.receiver.id = :reciver"), @NamedQuery(name="SocConnection.findConnectionBySenderAndReceiverWithStatus", query="SELECT c FROM SocConnection c WHERE c.sender.id = :sender AND c.receiver.id = :reciver AND c.status = :status"), @NamedQuery(name="SocConnection.deleteConnectionByIdentity", query="DELETE FROM SocConnection c WHERE c.sender.id = :identityId OR c.receiver.id = :identityId"), @NamedQuery(name="SocConnection.getConnectionIdsWithStatus", query="SELECT c.sender.id, c.receiver.id FROM SocConnection c WHERE (c.sender.id = :identityId OR c.receiver.id = :identityId) AND c.status = :status"), @NamedQuery(name="SocConnection.getConnectionsWithStatus", query="SELECT c FROM SocConnection c WHERE (c.sender.id = :identityId OR c.receiver.id = :identityId) AND c.status = :status AND c.sender.enabled = true AND c.receiver.enabled = true AND c.sender.deleted = false AND c.receiver.deleted = false order by c.updatedDate DESC"), @NamedQuery(name="SocConnection.countConnectionsWithStatus", query="SELECT count(distinct c.id) from SocConnection c WHERE (c.sender.id = :identityId or c.receiver.id = :identityId) AND c.status = :status"), @NamedQuery(name="SocConnection.getConnectionsWithoutStatus", query="SELECT c AS receiver FROM SocConnection c WHERE (c.sender.id = :identityId OR c.receiver.id = :identityId)"), @NamedQuery(name="SocConnection.countConnectionsWithoutStatus", query="SELECT count(distinct c.id) from SocConnection c WHERE (c.sender.id = :identityId or c.receiver.id = :identityId)"), @NamedQuery(name="SocConnection.getReceiverBySenderWithStatus", query="SELECT c FROM SocConnection c WHERE c.sender.id = :identityId AND c.status = :status"), @NamedQuery(name="SocConnection.getReceiverIdsBySenderWithStatus", query="SELECT c.receiver.id FROM SocConnection c WHERE c.sender.id = :identityId AND c.status = :status"), @NamedQuery(name="SocConnection.getReceiverIdsBySenderWithoutStatus", query="SELECT c.receiver.id FROM SocConnection c WHERE c.sender.id = :identityId"), @NamedQuery(name="SocConnection.getReceiverBySenderWithoutStatus", query="SELECT c FROM SocConnection c WHERE c.sender.id = :identityId"), @NamedQuery(name="SocConnection.getSenderByReceiverWithStatus", query="SELECT c FROM SocConnection c WHERE c.receiver.id = :identityId AND c.status = :status"), @NamedQuery(name="SocConnection.getSenderIdsByReceiverWithStatus", query="SELECT c.sender.id FROM SocConnection c WHERE c.receiver.id = :identityId AND c.status = :status"), @NamedQuery(name="SocConnection.getSenderIdsByReceiverWithoutStatus", query="SELECT c.sender.id FROM SocConnection c WHERE c.receiver.id = :identityId"), @NamedQuery(name="SocConnection.getSenderByReceiverWithoutStatus", query="SELECT c FROM SocConnection c WHERE c.receiver.id = :identityId"), @NamedQuery(name="SocConnection.countReceiverBySenderWithStatus", query="SELECT count(distinct c.receiver.id) FROM SocConnection c WHERE c.sender.id = :identityId AND c.status = :status"), @NamedQuery(name="SocConnection.countReceiverBySenderWithoutStatus", query="SELECT count(distinct c.receiver.id) FROM SocConnection c WHERE c.sender.id = :identityId"), @NamedQuery(name="SocConnection.countSenderByReceiverWithStatus", query="SELECT count(distinct c.sender.id) FROM SocConnection c WHERE c.receiver.id = :identityId AND c.status = :status"), @NamedQuery(name="SocConnection.countSenderByReceiverWithoutStatus", query="SELECT count(distinct c.sender.id) FROM SocConnection c WHERE c.receiver.id = :identityId"), @NamedQuery(name="SocConnection.migrateSenderId", query="UPDATE SocConnection c SET c.sender.id = :newId WHERE c.sender.id = :oldId"), @NamedQuery(name="SocConnection.migrateReceiverId", query="UPDATE SocConnection c SET c.receiver.id = :newId WHERE c.receiver.id = :oldId")})
public class ConnectionEntity {
    @Id
    @SequenceGenerator(name="SEQ_SOC_CONNECTIONS_ID", sequenceName="SEQ_SOC_CONNECTIONS_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_CONNECTIONS_ID")
    @Column(name="CONNECTION_ID")
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="SENDER_ID", referencedColumnName="IDENTITY_ID")
    private IdentityEntity sender;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="RECEIVER_ID", referencedColumnName="IDENTITY_ID")
    private IdentityEntity receiver;
    @Enumerated
    @Column(name="STATUS", nullable=false)
    private Relationship.Type status;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="UPDATED_DATE", nullable=false)
    private Date updatedDate = new Date();

    public ConnectionEntity() {
    }

    public ConnectionEntity(IdentityEntity sender, IdentityEntity receiver) {
        this.sender = sender;
        this.receiver = receiver;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public IdentityEntity getSender() {
        return this.sender;
    }

    public void setSender(IdentityEntity sender) {
        this.sender = sender;
    }

    public IdentityEntity getReceiver() {
        return this.receiver;
    }

    public void setReceiver(IdentityEntity receiver) {
        this.receiver = receiver;
    }

    public Relationship.Type getStatus() {
        return this.status;
    }

    public void setStatus(Relationship.Type status) {
        if (status == Relationship.Type.ALL) {
            throw new IllegalArgumentException("Illegal status [" + String.valueOf(status) + "]");
        }
        this.status = status;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }
}

