/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.rest;

import io.meeds.news.rest.NewsTargetingEntity;
import io.meeds.news.service.NewsTargetingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.metadata.model.Metadata;
import org.picocontainer.Startable;

@Path(value="v1/news/targeting")
@Tag(name="v1/news/targeting", description="Manage news targeting operations")
public class NewsTargetingRestResourcesV1
implements ResourceContainer,
Startable {
    private static final Log LOG = ExoLogger.getLogger(NewsTargetingRestResourcesV1.class);
    private NewsTargetingService newsTargetingService;
    private ScheduledExecutorService scheduledExecutor;
    private PortalContainer container;
    private Map<String, String> newsTargetToDeleteQueue = new HashMap<String, String>();

    public NewsTargetingRestResourcesV1(NewsTargetingService newsTargetingService, PortalContainer container) {
        this.newsTargetingService = newsTargetingService;
        this.container = container;
    }

    public void start() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
    }

    public void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get all news targets", method="GET", description="Get all news targets")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAllTargets(@Context HttpServletRequest request) {
        try {
            List<NewsTargetingEntity> targets = this.newsTargetingService.getAllTargets();
            return Response.ok(targets).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when getting the news targets", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="allowed")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get all allowed news targets of the current user", method="GET", description="Get all allowed news targets of the current user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAllowedTargets(@Context HttpServletRequest request) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            List<NewsTargetingEntity> allowedTargets = this.newsTargetingService.getAllowedTargets(currentIdentity);
            return Response.ok(allowedTargets).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting allowed news targets for the user " + currentIdentity.getUserId()), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{targetName}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete news target", method="DELETE", description="This deletes news target")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="News target deleted"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User not authorized to delete the news target"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteTarget(@Context HttpServletRequest request, @Parameter(description="Target name", required=true) @PathParam(value="targetName") String targetName, @Parameter(description="Time to effectively delete news target", required=false) @QueryParam(value="delay") long delay) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)targetName)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Target name ist mandatory").build();
            }
            if (delay > 0L) {
                this.newsTargetToDeleteQueue.put(targetName, currentIdentity.getUserId());
                this.scheduledExecutor.schedule(() -> {
                    if (this.newsTargetToDeleteQueue.containsKey(targetName)) {
                        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
                        RequestLifeCycle.begin((ExoContainer)this.container);
                        try {
                            this.newsTargetToDeleteQueue.remove(targetName);
                            this.newsTargetingService.deleteTargetByName(targetName, currentIdentity);
                        }
                        catch (IllegalAccessException e) {
                            LOG.warn("User '{}' is not authorized to delete the news target with name " + targetName, new Object[]{currentIdentity.getUserId(), e});
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error when deleting the news target with name " + targetName), (Throwable)e);
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                    }
                }, delay, TimeUnit.SECONDS);
            } else {
                this.newsTargetToDeleteQueue.remove(targetName);
                this.newsTargetingService.deleteTargetByName(targetName, currentIdentity);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting the news target with name " + targetName), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{targetName}/undoDelete")
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="Undo deleting news target if not yet effectively deleted", method="POST", description="Undo deleting news target if not yet effectively deleted")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden operation")})
    public Response undoDeleteTarget(@Context HttpServletRequest request, @Parameter(description="News target name identifier", required=true) @PathParam(value="targetName") String targetName) {
        if (StringUtils.isBlank((CharSequence)targetName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Target name ist mandatory").build();
        }
        if (this.newsTargetToDeleteQueue.containsKey(targetName)) {
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            String authenticatedUser = currentIdentity.getUserId();
            String originalModifierUser = this.newsTargetToDeleteQueue.get(targetName);
            if (!originalModifierUser.equals(authenticatedUser)) {
                LOG.warn("User {} attempts to cancel deletion of a news target deleted by user {}", new Object[]{authenticatedUser, originalModifierUser});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.newsTargetToDeleteQueue.remove(targetName);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("News target with name {} was already deleted or isn't planned to be deleted" + targetName)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Create news target", method="POST", description="Create news target")
    @ApiResponses(value={@ApiResponse(responseCode="401", description="User not authorized to create news target"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="409", description="Conflict operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createNewsTarget(@Context HttpServletRequest request, @RequestBody(description="News target to create", required=true) NewsTargetingEntity newsTargetingEntity) {
        if (newsTargetingEntity.getProperties() == null || newsTargetingEntity.getProperties().get("permissions") == null || newsTargetingEntity.getProperties().get("permissions").isEmpty()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            Metadata addedNewsTarget = this.newsTargetingService.createNewsTarget(newsTargetingEntity, currentIdentity);
            return Response.ok((Object)addedNewsTarget).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not authorized to create a news target with name " + newsTargetingEntity.getName(), new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("User '{}' can't create a news target with the same name " + newsTargetingEntity.getName(), new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when creating a news target with name " + newsTargetingEntity.getName()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{originalTargetName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update an existing news target", method="PUT", description="Update an existing news target")
    @ApiResponses(value={@ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="409", description="Conflict operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateNewsTarget(@Parameter(description="News target to create", required=true) NewsTargetingEntity newsTargetingEntity, @Parameter(description="Original news target name", required=true) @PathParam(value="originalTargetName") String originalTargetName) {
        if (newsTargetingEntity.getProperties() == null || newsTargetingEntity.getProperties().get("permissions") == null || newsTargetingEntity.getProperties().get("permissions").isEmpty()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            Metadata metadata = this.newsTargetingService.updateNewsTargets(originalTargetName, newsTargetingEntity, currentIdentity);
            return Response.ok((Object)metadata).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not authorized to update news target with name '{}'", new Object[]{currentIdentity.getUserId(), originalTargetName, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("User '{}' can't update news target with name '{}'", new Object[]{currentIdentity.getUserId(), originalTargetName, e});
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (IllegalStateException e) {
            LOG.warn("The news target '{}' can't be found", new Object[]{newsTargetingEntity.getName(), e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when updating the news target with name " + newsTargetingEntity.getName()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

