/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.wiki.model.DraftPage;

public class NewsUtils {
    private static final Log LOG = ExoLogger.getLogger(NewsUtils.class);
    public static final String POST_NEWS = "exo.news.postArticle";
    public static final String POST_NEWS_ARTICLE = "exo.news.gamification.postArticle";
    public static final String PUBLISH_NEWS = "exo.news.gamification.PublishArticle";
    public static final String VIEW_NEWS = "exo.news.viewArticle";
    public static final String SHARE_NEWS = "exo.news.shareArticle";
    public static final String ARCHIVE_NEWS = "exo.news.archiveArticle";
    public static final String UNARCHIVE_NEWS = "exo.news.unarchiveArticle";
    public static final String COMMENT_NEWS = "exo.news.commentArticle";
    public static final String LIKE_NEWS = "exo.news.likeArticle";
    public static final String DELETE_NEWS = "exo.news.deleteArticle";
    public static final String UPDATE_NEWS = "exo.news.updateArticle";
    public static final String SCHEDULE_NEWS = "exo.news.scheduleArticle";
    public static final String UNSCHEDULE_NEWS = "exo.news.unscheduleArticle";
    public static final String NEWS_METADATA_OBJECT_TYPE = "news";
    public static final String DISPLAYED_STATUS = "displayed";
    public static final String TARGET_PERMISSIONS = "permissions";
    public static final String SPACE_NEWS_AUDIENCE = "space";
    public static final String ALL_NEWS_AUDIENCE = "all";
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private static final String MANAGER_MEMBERSHIP_NAME = "manager";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";

    public static void broadcastEvent(String eventName, Object source, Object data) {
        try {
            ListenerService listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
            listenerService.broadcast(eventName, source, data);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error broadcasting event '" + eventName + "' using source '" + String.valueOf(source) + "' and data " + String.valueOf(data)), (Throwable)e);
        }
    }

    public static Set<String> processMentions(String content, Space space) {
        HashSet mentions = new HashSet();
        mentions.addAll(MentionUtils.getMentionedUsernames((String)content));
        if (space != null) {
            IdentityStorage identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
            String spaceIdentityId = identityStorage.findIdentityId(SPACE_NEWS_AUDIENCE, space.getPrettyName());
            Set mentionedRoles = MentionUtils.getMentionedRoles((String)content, (String)spaceIdentityId);
            mentionedRoles.forEach(role -> {
                if (StringUtils.equals((CharSequence)"member", (CharSequence)role) && space.getMembers() != null) {
                    mentions.addAll(Arrays.asList(space.getMembers()));
                } else if (StringUtils.equals((CharSequence)MANAGER_MEMBERSHIP_NAME, (CharSequence)role) && space.getManagers() != null) {
                    mentions.addAll(Arrays.asList(space.getManagers()));
                } else if (StringUtils.equals((CharSequence)"redactor", (CharSequence)role) && space.getRedactors() != null) {
                    mentions.addAll(Arrays.asList(space.getRedactors()));
                } else if (StringUtils.equals((CharSequence)PUBLISHER_MEMBERSHIP_NAME, (CharSequence)role) && space.getPublishers() != null) {
                    mentions.addAll(Arrays.asList(space.getPublishers()));
                }
            });
        }
        return mentions.stream().map(remoteId -> {
            IdentityStorage identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
            org.exoplatform.social.core.identity.model.Identity identity = identityStorage.findIdentity("organization", remoteId);
            return identity == null ? null : identity.getId();
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static List<Space> getAllowedDraftNewsSpaces(Identity userIdentity) throws Exception {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        ListAccess memberSpacesListAccess = spaceService.getMemberSpaces(userIdentity.getUserId());
        List<Space> memberSpaces = Arrays.asList((Space[])memberSpacesListAccess.load(0, memberSpacesListAccess.getSize()));
        return memberSpaces.stream().filter(space -> spaceService.canRedactOnSpace(space, userIdentity) || NewsUtils.canPublishNews(space.getId(), userIdentity)).toList();
    }

    public static List<Space> getAllowedScheduledNewsSpaces(Identity currentIdentity) throws Exception {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        ListAccess memberSpacesListAccess = spaceService.getMemberSpaces(currentIdentity.getUserId());
        List<Space> memberSpaces = Arrays.asList((Space[])memberSpacesListAccess.load(0, memberSpacesListAccess.getSize()));
        return memberSpaces.stream().filter(space -> spaceService.isManager(space, currentIdentity.getUserId()) || spaceService.isRedactor(space, currentIdentity.getUserId()) || NewsUtils.canPublishNews(space.getId(), currentIdentity)).toList();
    }

    public static boolean canPublishNews(String spaceId, Identity currentIdentity) {
        if (!StringUtils.isBlank((CharSequence)spaceId)) {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            return currentIdentity != null && space != null && spaceService.isMember(space, currentIdentity.getUserId()) && (currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || spaceService.isPublisher(space, currentIdentity.getUserId()));
        }
        return currentIdentity != null && currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
    }

    public static boolean canManageNewsPublishTargets(Identity currentIdentity) {
        return currentIdentity != null && currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, MANAGER_MEMBERSHIP_NAME);
    }

    public static Identity getUserIdentity(String username) {
        IdentityRegistry identityRegistry = (IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(username);
        if (identity != null) {
            return identity;
        }
        Authenticator authenticator = (Authenticator)ExoContainerContext.getService(Authenticator.class);
        try {
            identity = authenticator.createIdentity(username);
            if (identity != null) {
                identityRegistry.register(identity);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred while retrieving security identity of user " + username);
        }
        return identity;
    }

    public static String buildDraftUrl(DraftPage draftPage) {
        StringBuilder draftArticleUrl = new StringBuilder();
        draftArticleUrl.append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(CommonsUtils.getCurrentPortalOwner()).append("/news/detail?newsId=").append(draftPage.getId()).append(draftPage.getTargetPageId() != null ? "&type=latest_draft" : "&type=draft");
        return draftArticleUrl.toString();
    }

    public static enum NewsUpdateType {
        CONTENT,
        SCHEDULE,
        POSTING_AND_PUBLISHING;

    }

    public static enum NewsObjectType {
        DRAFT,
        LATEST_DRAFT,
        ARTICLE;

    }
}

