/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.listener;

import io.meeds.poll.model.Poll;
import io.meeds.poll.service.PollService;
import io.meeds.poll.utils.PollUtils;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class AnalyticsPollListener
extends Listener<String, Poll> {
    private static final String POLL_ID = "PollId";
    private static final String[] LISTENER_EVENTS = new String[]{"meeds.poll.createPoll", "meeds.poll.votePoll"};
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private PollService pollService;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        for (String eventName : LISTENER_EVENTS) {
            this.listenerService.addListener(eventName, (ListenerBase)this);
        }
    }

    public void onEvent(Event<String, Poll> event) throws Exception {
        if (!ExoContainer.hasProfile((String)"analytics")) {
            return;
        }
        Poll poll = (Poll)event.getData();
        String operation = "";
        if (event.getEventName().equals("meeds.poll.createPoll")) {
            operation = "createPoll";
        } else if (event.getEventName().equals("meeds.poll.votePoll")) {
            operation = "votePoll";
        }
        String userName = (String)event.getSource();
        long userId = 0L;
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(userName);
        if (identity != null) {
            userId = Long.parseLong(identity.getId());
        }
        StatisticData statisticData = new StatisticData();
        Space space = this.spaceService.getSpaceById(String.valueOf(poll.getSpaceId()));
        statisticData.setModule("Poll");
        statisticData.setSubModule("Poll");
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        statisticData.addParameter(POLL_ID, (Object)poll.getId());
        statisticData.addParameter("PollActivityId", (Object)poll.getActivityId());
        statisticData.addParameter("PollOptionsNumber", (Object)this.pollService.getPollOptionsNumber(poll.getId(), new Identity(userName)));
        statisticData.addParameter("PollDuration", (Object)PollUtils.getPollDuration(poll));
        statisticData.addParameter("PollTotalVotes", (Object)this.pollService.getPollTotalVotes(poll.getId(), new Identity(userName)));
        statisticData.addParameter("PollSpaceMembersCount", (Object)AnalyticsPollListener.getSize(space.getMembers()));
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private static int getSize(String[] array) {
        return array == null ? 0 : new HashSet<String>(Arrays.asList(array)).size();
    }
}

