/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

@Serialized
public class UIFormStringInput
extends UIFormInputBase<String> {
    public static final short TEXT_TYPE = 0;
    public static final short PASSWORD_TYPE = 1;
    private short type_ = 0;
    private int maxLength = 0;
    private String placeholder = "";

    public UIFormStringInput() {
    }

    public UIFormStringInput(String name, String bindingExpression, String value, String placeholder) {
        super(name, bindingExpression, String.class);
        this.value_ = value;
        this.placeholder = placeholder;
    }

    public UIFormStringInput(String name, String bindingExpression, String value) {
        super(name, bindingExpression, String.class);
        this.value_ = value;
    }

    public UIFormStringInput(String name, String value) {
        this(name, null, value);
    }

    public UIFormStringInput setType(short type) {
        this.type_ = type;
        return this;
    }

    public UIFormStringInput setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public UIFormStringInput setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) {
        String val = (String)input;
        if ((val == null || val.length() == 0) && this.type_ == 1) {
            return;
        }
        this.value_ = val;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        String value = (String)this.getValue();
        Writer w = context.getWriter();
        w.write("<input name=\"");
        w.write(this.getName());
        w.write("\"");
        if (this.type_ == 1) {
            w.write(" type=\"password\"");
        } else {
            w.write(" type=\"text\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPlaceholder())) {
            w.write(" placeholder=\"");
            w.write(this.getPlaceholder());
            w.write("\"");
        }
        w.write(" id=\"");
        w.write(this.getId());
        w.write("\"");
        if (value != null && value.length() > 0) {
            value = HTMLEntityEncoder.getInstance().encodeHTMLAttribute(value);
            w.write(" value=\"");
            w.write(value);
            w.write("\"");
        }
        if (this.maxLength > 0) {
            w.write(" maxlength=\"" + this.maxLength + "\"");
        }
        if (this.readonly_) {
            w.write(" readonly ");
        }
        if (this.isDisabled()) {
            w.write(" disabled ");
        }
        this.renderHTMLAttributes(w);
        w.write("/>");
        if (this.isMandatory()) {
            w.write(" *");
        }
    }
}

