/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.jpa.web.dao;

import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO$AjcClosure1;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO$AjcClosure11;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO$AjcClosure13;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO$AjcClosure15;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO$AjcClosure17;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO$AjcClosure19;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO$AjcClosure3;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO$AjcClosure5;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO$AjcClosure7;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO$AjcClosure9;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebUsersEntity;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class WebUsersDAO
extends GenericDAOJPAImpl<WebUsersEntity, Long> {
    private static final String QUERY_FILTER_FIND_PREFIX = "NotificationsWebUsersEntity.findFilteredWebNotifs";
    private static final String QUERY_FILTER_COUNT_PREFIX = "NotificationsWebUsersEntity.countFilteredWebNotifs";
    private static final String RECEIVER_PARAM = "receiver";
    private static final String DATE_PARAM = "calendar";
    private static final String PARAM_VALUE = "paramValue";
    private static final String PARAM_NAME = "paramName";
    private static final String PLUGIN_ID_PARAM = "pluginId";
    private static final String IS_ON_POPOVER_PARAM = "isOnPopover";
    private static final String USER_ID_PARAM = "userId";
    private static final String IS_READ_PARAM = "isRead";
    private static final String PLUGIN_IDS_PARAM = "pluginIds";
    private Map<String, Boolean> filterNamedQueries = new HashMap<String, Boolean>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    @ExoTransactional
    public List<WebUsersEntity> findWebNotifsByFilter(List<String> pluginIds, String userId, Boolean isOnPopover, int offset, int limit) {
        List<String> list = pluginIds;
        String string = userId;
        Boolean bl = isOnPopover;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{list, string, bl, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, list, string, bl, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        WebUsersDAO$AjcClosure1 webUsersDAO$AjcClosure1 = new WebUsersDAO$AjcClosure1(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(webUsersDAO$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<WebUsersEntity> findNotificationsByTypeAndParams(List<String> pluginIds, String paramName, String paramValue, String receiver, int offset, int limit) {
        List<String> list = pluginIds;
        String string = paramName;
        String string2 = paramValue;
        String string3 = receiver;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{list, string, string2, string3, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, list, string, string2, string3, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        WebUsersDAO$AjcClosure3 webUsersDAO$AjcClosure3 = new WebUsersDAO$AjcClosure3(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(webUsersDAO$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<WebUsersEntity> findWebNotifsByFilter(String userId, int offset, int limit) {
        String string = userId;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        WebUsersDAO$AjcClosure5 webUsersDAO$AjcClosure5 = new WebUsersDAO$AjcClosure5(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(webUsersDAO$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<WebUsersEntity> findWebNotifsByFilter(String userId, boolean isOnPopover, int offset, int limit) {
        String string = userId;
        boolean bl = isOnPopover;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{string, Conversions.booleanObject((boolean)bl), Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, Conversions.booleanObject((boolean)bl), Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        WebUsersDAO$AjcClosure7 webUsersDAO$AjcClosure7 = new WebUsersDAO$AjcClosure7(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(webUsersDAO$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<WebUsersEntity> findWebNotifsOfUserByLastUpdatedDate(String userId, Calendar calendar) {
        String string = userId;
        Calendar calendar2 = calendar;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)calendar2);
        Object[] objectArray = new Object[]{this, string, calendar2, joinPoint};
        WebUsersDAO$AjcClosure9 webUsersDAO$AjcClosure9 = new WebUsersDAO$AjcClosure9(objectArray);
        return (List)ExoTransactionalAspect.aspectOf().around(webUsersDAO$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<WebUsersEntity> findUnreadNotification(String pluginId, String userId, String paramName, String paramValue) {
        String string = pluginId;
        String string2 = userId;
        String string3 = paramName;
        String string4 = paramValue;
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, joinPoint};
        WebUsersDAO$AjcClosure11 webUsersDAO$AjcClosure11 = new WebUsersDAO$AjcClosure11(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(webUsersDAO$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void markAllRead(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        WebUsersDAO$AjcClosure13 webUsersDAO$AjcClosure13 = new WebUsersDAO$AjcClosure13(objectArray);
        ExoTransactionalAspect.aspectOf().around(webUsersDAO$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<WebUsersEntity> findWebNotifsByLastUpdatedDate(Calendar date) {
        Calendar calendar = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)calendar);
        Object[] objectArray = new Object[]{this, calendar, joinPoint};
        WebUsersDAO$AjcClosure15 webUsersDAO$AjcClosure15 = new WebUsersDAO$AjcClosure15(objectArray);
        return (List)ExoTransactionalAspect.aspectOf().around(webUsersDAO$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public int getNumberOnBadge(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        WebUsersDAO$AjcClosure17 webUsersDAO$AjcClosure17 = new WebUsersDAO$AjcClosure17(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(webUsersDAO$AjcClosure17.linkClosureAndJoinPoint(69648)));
    }

    public Map<String, Integer> countUnreadByPlugin(String userId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.countUnreadByPlugin", Tuple.class).setParameter(USER_ID_PARAM, (Object)userId);
        List result = query.getResultList();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return Collections.emptyMap();
        }
        return result.stream().collect(Collectors.toMap(t -> (String)t.get(0, String.class), t -> ((Long)t.get(1, Long.class)).intValue()));
    }

    @ExoTransactional
    public List<WebUsersEntity> findNotifsWithBadge(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        WebUsersDAO$AjcClosure19 webUsersDAO$AjcClosure19 = new WebUsersDAO$AjcClosure19(objectArray);
        return (List)ExoTransactionalAspect.aspectOf().around(webUsersDAO$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    public List<WebUsersEntity> findNotifsWithBadgeByPlugins(List<String> pluginIds, String username) {
        return this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.findNotifsWithBadgeByPlugins", WebUsersEntity.class).setParameter(USER_ID_PARAM, (Object)username).setParameter(PLUGIN_IDS_PARAM, pluginIds).getResultList();
    }

    public List<WebUsersEntity> findUnreadByUserAndPlugins(List<String> pluginIds, String username) {
        return this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.findUnreadByUserAndPlugins", WebUsersEntity.class).setParameter(USER_ID_PARAM, (Object)username).setParameter(PLUGIN_IDS_PARAM, pluginIds).getResultList();
    }

    public List<WebUsersEntity> findWebNotificationsByFilter(WebNotificationFilter filter, int offset, int limit) {
        List result;
        TypedQuery<WebUsersEntity> query = this.buildQueryFromFilter(filter, WebUsersEntity.class, false);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result;
    }

    public int countWebNotificationsByFilter(WebNotificationFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, true);
        return ((Long)query.getSingleResult()).intValue();
    }

    private <T> TypedQuery<T> buildQueryFromFilter(WebNotificationFilter filter, Class<T> clazz, boolean count) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> joins = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        this.buildPredicates(filter, suffixes, joins, predicates);
        String queryName = this.getQueryFilterName(suffixes, count);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, clazz);
        } else {
            String queryContent = this.getQueryFilterContent(joins, predicates, count);
            query = this.getEntityManager().createQuery(queryContent, clazz);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(filter, query);
        return query;
    }

    private <T> void addQueryFilterParameters(WebNotificationFilter filter, TypedQuery<T> query) {
        if (StringUtils.isNotBlank((CharSequence)filter.getUserId())) {
            query.setParameter(USER_ID_PARAM, (Object)filter.getUserId());
        }
        if (filter.getIsRead() != null) {
            query.setParameter(IS_READ_PARAM, (Object)filter.getIsRead());
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getPluginKeys())) {
            query.setParameter(PLUGIN_IDS_PARAM, filter.getPluginKeys().stream().map(PluginKey::getId).toList());
        }
        if (filter.getLimitDay() > 0) {
            Calendar cal = Calendar.getInstance();
            long delayTime = System.currentTimeMillis() - (long)filter.getLimitDay() * 86400000L;
            cal.setTimeInMillis(delayTime);
            query.setParameter(DATE_PARAM, (Object)delayTime);
        }
        if (filter.isOnPopover()) {
            query.setParameter(IS_ON_POPOVER_PARAM, (Object)filter.isOnPopover());
        }
        if (filter.getParameter() != null) {
            query.setParameter(PARAM_NAME, filter.getParameter().getKey());
            query.setParameter(PARAM_VALUE, filter.getParameter().getValue());
        }
    }

    private String getQueryFilterName(List<String> suffixes, boolean count) {
        Object queryName = suffixes.isEmpty() ? (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) : (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) + "By" + StringUtils.join(suffixes, (String)"And");
        return queryName;
    }

    private String getQueryFilterContent(List<String> joins, List<String> predicates, boolean count) {
        Object queryContent;
        String querySelect;
        String string = querySelect = count ? "SELECT COUNT(u) FROM NotificationsWebUsersEntity u " : "SELECT u FROM NotificationsWebUsersEntity u ";
        if (predicates.isEmpty() && joins.isEmpty()) {
            queryContent = querySelect;
        } else {
            queryContent = querySelect;
            if (!joins.isEmpty()) {
                queryContent = (String)queryContent + " " + StringUtils.join(joins, (String)" ");
            }
            if (!predicates.isEmpty()) {
                queryContent = (String)queryContent + " WHERE " + StringUtils.join(predicates, (String)" AND ");
            }
        }
        if (!count) {
            queryContent = (String)queryContent + " ORDER BY u.updateDate DESC ";
        }
        return queryContent;
    }

    private void buildPredicates(WebNotificationFilter filter, List<String> suffixes, List<String> joins, List<String> predicates) {
        if (filter.getParameter() != null || CollectionUtils.isNotEmpty((Collection)filter.getPluginKeys())) {
            if (CollectionUtils.isNotEmpty((Collection)filter.getPluginKeys())) {
                joins.add("INNER JOIN u.webNotification w ON w.type IN (:pluginIds)");
                suffixes.add("PluginKeys");
            } else {
                joins.add("INNER JOIN u.webNotification w");
            }
            if (filter.getParameter() != null) {
                suffixes.add("Parameter");
                joins.add("INNER JOIN w.parameters p ON p.name = :paramName AND p.value = :paramValue");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getUserId())) {
            suffixes.add("UserId");
            predicates.add("u.receiver = :userId");
        }
        if (filter.getIsRead() != null) {
            suffixes.add("IsRead");
            predicates.add("u.read = :isRead");
        }
        if (filter.getLimitDay() > 0) {
            suffixes.add("LimitDay");
            predicates.add("u.updateDate < calendar");
        }
        if (filter.isOnPopover()) {
            suffixes.add("IsOnPopover");
            predicates.add("u.showPopover = :isOnPopover");
        }
    }

    static {
        WebUsersDAO.ajc$preClinit();
    }

    static /* synthetic */ List findWebNotifsByFilter_aroundBody0(WebUsersDAO ajc$this, List pluginIds, String userId, Boolean isOnPopover, int offset, int limit, JoinPoint joinPoint) {
        TypedQuery query = ajc$this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.findWebNotifsByPluginFilter", WebUsersEntity.class).setParameter(PLUGIN_IDS_PARAM, (Object)pluginIds).setParameter(USER_ID_PARAM, (Object)userId).setParameter(IS_ON_POPOVER_PARAM, (Object)isOnPopover).setFirstResult(offset);
        if (limit >= 0) {
            return query.setMaxResults(limit).getResultList();
        }
        return query.getResultList();
    }

    static /* synthetic */ List findNotificationsByTypeAndParams_aroundBody2(WebUsersDAO ajc$this, List pluginIds, String paramName, String paramValue, String receiver, int offset, int limit, JoinPoint joinPoint) {
        TypedQuery query = ajc$this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.findNotificationsByTypeAndParams", WebUsersEntity.class).setParameter(PLUGIN_IDS_PARAM, (Object)pluginIds).setParameter(PARAM_NAME, (Object)paramName).setParameter(PARAM_VALUE, (Object)paramValue).setParameter(RECEIVER_PARAM, (Object)receiver).setFirstResult(offset);
        if (limit >= 0) {
            return query.setMaxResults(limit).getResultList();
        }
        return query.getResultList();
    }

    static /* synthetic */ List findWebNotifsByFilter_aroundBody4(WebUsersDAO ajc$this, String userId, int offset, int limit, JoinPoint joinPoint) {
        TypedQuery query = ajc$this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.findWebNotifsByUserFilter", WebUsersEntity.class).setParameter(USER_ID_PARAM, (Object)userId).setFirstResult(offset);
        if (limit >= 0) {
            return query.setMaxResults(limit).getResultList();
        }
        return query.getResultList();
    }

    static /* synthetic */ List findWebNotifsByFilter_aroundBody6(WebUsersDAO ajc$this, String userId, boolean isOnPopover, int offset, int limit, JoinPoint joinPoint) {
        TypedQuery query = ajc$this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.findWebNotifsByPopoverFilter", WebUsersEntity.class).setParameter(USER_ID_PARAM, (Object)userId).setParameter(IS_ON_POPOVER_PARAM, (Object)isOnPopover).setFirstResult(offset);
        if (limit >= 0) {
            return query.setMaxResults(limit).getResultList();
        }
        return query.getResultList();
    }

    static /* synthetic */ List findWebNotifsOfUserByLastUpdatedDate_aroundBody8(WebUsersDAO ajc$this, String userId, Calendar calendar, JoinPoint joinPoint) {
        return ajc$this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.findWebNotifsOfUserByLastUpdatedDate", WebUsersEntity.class).setParameter(USER_ID_PARAM, (Object)userId).setParameter(DATE_PARAM, (Object)calendar).getResultList();
    }

    static /* synthetic */ List findUnreadNotification_aroundBody10(WebUsersDAO ajc$this, String pluginId, String userId, String paramName, String paramValue, JoinPoint joinPoint) {
        return ajc$this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.findUnreadNotification", WebUsersEntity.class).setParameter(PLUGIN_ID_PARAM, (Object)pluginId).setParameter(USER_ID_PARAM, (Object)userId).setParameter(PARAM_NAME, (Object)paramName).setParameter(PARAM_VALUE, (Object)paramValue).getResultList();
    }

    static /* synthetic */ void markAllRead_aroundBody12(WebUsersDAO ajc$this, String userId, JoinPoint joinPoint) {
        ajc$this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.markWebNotifsAsReadByUser").setParameter(USER_ID_PARAM, (Object)userId).executeUpdate();
    }

    static /* synthetic */ List findWebNotifsByLastUpdatedDate_aroundBody14(WebUsersDAO ajc$this, Calendar date, JoinPoint joinPoint) {
        return ajc$this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.findWebNotifsByLastUpdatedDate", WebUsersEntity.class).setParameter(DATE_PARAM, (Object)date).getResultList();
    }

    static /* synthetic */ int getNumberOnBadge_aroundBody16(WebUsersDAO ajc$this, String userId, JoinPoint joinPoint) {
        TypedQuery query = ajc$this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.getNumberOnBadge", Long.class).setParameter(USER_ID_PARAM, (Object)userId);
        return ((Long)query.getSingleResult()).intValue();
    }

    static /* synthetic */ List findNotifsWithBadge_aroundBody18(WebUsersDAO ajc$this, String userId, JoinPoint joinPoint) {
        return ajc$this.getEntityManager().createNamedQuery("NotificationsWebUsersEntity.findNotifsWithBadge", WebUsersEntity.class).setParameter(USER_ID_PARAM, (Object)userId).getResultList();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebUsersDAO.java", WebUsersDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findWebNotifsByFilter", "org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO", "java.util.List:java.lang.String:java.lang.Boolean:int:int", "pluginIds:userId:isOnPopover:offset:limit", "", "java.util.List"), 55);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findNotificationsByTypeAndParams", "org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO", "java.util.List:java.lang.String:java.lang.String:java.lang.String:int:int", "pluginIds:paramName:paramValue:receiver:offset:limit", "", "java.util.List"), 76);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findWebNotifsByFilter", "org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO", "java.lang.String:int:int", "userId:offset:limit", "", "java.util.List"), 93);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findWebNotifsByFilter", "org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO", "java.lang.String:boolean:int:int", "userId:isOnPopover:offset:limit", "", "java.util.List"), 107);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findWebNotifsOfUserByLastUpdatedDate", "org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO", "java.lang.String:java.util.Calendar", "userId:calendar", "", "java.util.List"), 122);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findUnreadNotification", "org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "pluginId:userId:paramName:paramValue", "", "java.util.List"), 131);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "markAllRead", "org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO", "java.lang.String", USER_ID_PARAM, "", "void"), 141);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findWebNotifsByLastUpdatedDate", "org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO", "java.util.Calendar", "date", "", "java.util.List"), 148);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNumberOnBadge", "org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO", "java.lang.String", USER_ID_PARAM, "", "int"), 155);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findNotifsWithBadge", "org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO", "java.lang.String", USER_ID_PARAM, "", "java.util.List"), 173);
    }
}

