/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.xml.namespace.QName;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.webui.application.EventsWrapper;
import org.exoplatform.portal.webui.application.ExoPortletInstanceContext;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.application.UIPortletForm;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.HTTPRedirectionResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.api.invocation.response.SecurityErrorResponse;
import org.gatein.pc.api.invocation.response.SecurityResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;

public class UIPortletActionListener {
    public static final String PORTLET_EVENTS = "PortletEvents";
    public static final String CHANGE_WINDOW_STATE_EVENT = "PortletChangeWindowStateEvent";
    public static final String CHANGE_PORTLET_MODE_EVENT = "ChangePortletModeEvent";
    protected static Log log = ExoLogger.getLogger((String)"portal:UIPortletActionListener");

    private static void clearMaximizedUIComponent(UIPage uiPage, UIPortlet uiPortlet) {
        if (uiPage.getMaximizedUIPortlet() != null && uiPage.getMaximizedUIPortlet().getId().equals(uiPortlet.getId())) {
            uiPage.setMaximizedUIPortlet(null);
        }
    }

    public static void setNextState(UIPortlet uiPortlet, WindowState state) {
        if (state != null) {
            UIPage uiPage = (UIPage)uiPortlet.getAncestorOfType(UIPage.class);
            if (WindowState.MAXIMIZED.equals((Object)state)) {
                if (uiPage != null) {
                    uiPage.normalizePortletWindowStates();
                    uiPage.setMaximizedUIPortlet(uiPortlet);
                    uiPortlet.setCurrentWindowState(WindowState.MAXIMIZED);
                }
            } else if (WindowState.MINIMIZED.equals((Object)state)) {
                uiPortlet.setCurrentWindowState(WindowState.MINIMIZED);
                if (uiPage != null) {
                    UIPortletActionListener.clearMaximizedUIComponent(uiPage, uiPortlet);
                }
            } else {
                uiPortlet.setCurrentWindowState(WindowState.NORMAL);
                if (uiPage != null) {
                    UIPortletActionListener.clearMaximizedUIComponent(uiPage, uiPortlet);
                }
            }
        }
    }

    public static void setNextMode(UIPortlet uiPortlet, PortletMode portletMode) {
        if (portletMode != null) {
            if (portletMode.equals((Object)PortletMode.HELP)) {
                uiPortlet.setCurrentPortletMode(PortletMode.HELP);
            } else if (portletMode.equals((Object)PortletMode.EDIT)) {
                uiPortlet.setCurrentPortletMode(PortletMode.EDIT);
            } else {
                uiPortlet.setCurrentPortletMode(PortletMode.VIEW);
            }
        }
    }

    public static <S, C extends Serializable, I> List<javax.portlet.Event> processEvent(UIPortlet<S, C> uiPortlet, javax.portlet.Event event) {
        log.trace((Object)("Process Event: " + event.getName() + " for portlet: " + String.valueOf(uiPortlet.getState())));
        try {
            PortalRequestContext context = (PortalRequestContext)WebuiRequestContext.getCurrentInstance();
            EventInvocation eventInvocation = uiPortlet.create(EventInvocation.class, context);
            eventInvocation.setName(event.getQName());
            eventInvocation.setPayload(event.getValue());
            PortletInvocationResponse piResponse = uiPortlet.invoke((PortletInvocation)eventInvocation);
            ExoPortletInstanceContext instanceCtx = (ExoPortletInstanceContext)eventInvocation.getInstanceContext();
            if (instanceCtx.getModifiedContext() != null) {
                StatefulPortletContext updatedCtx = (StatefulPortletContext)instanceCtx.getModifiedContext();
                Serializable portletState = updatedCtx.getState();
                uiPortlet.update(portletState);
            }
            if (!(piResponse instanceof UpdateNavigationalStateResponse)) {
                if (piResponse instanceof ErrorResponse) {
                    ErrorResponse errorResponse = (ErrorResponse)piResponse;
                    throw (Exception)errorResponse.getCause();
                }
                throw new Exception("Unexpected response type [" + String.valueOf(piResponse) + "]. Expected a UpdateNavigationResponse or an ErrorResponse.");
            }
            UpdateNavigationalStateResponse navResponse = (UpdateNavigationalStateResponse)piResponse;
            WindowState state = new WindowState(UIPortletActionListener.getWindowStateOrDefault(navResponse));
            UIPortletActionListener.setNextState(uiPortlet, state);
            PortletMode mode = new PortletMode(UIPortletActionListener.getPortletModeOrDefault(navResponse));
            UIPortletActionListener.setNextMode(uiPortlet, mode);
            StateString navState = navResponse.getNavigationalState();
            if (navState != null) {
                uiPortlet.setNavigationalState(navResponse.getNavigationalState());
            }
            UIPortletActionListener.setupPublicRenderParams(uiPortlet, navResponse.getPublicNavigationalStateUpdates());
            List nsEvents = navResponse.getEvents();
            ArrayList<javax.portlet.Event> events = new ArrayList<javax.portlet.Event>(nsEvents.size());
            if (nsEvents != null && !nsEvents.isEmpty()) {
                for (UpdateNavigationalStateResponse.Event nsEvent : nsEvents) {
                    class PortletEvent
                    implements javax.portlet.Event {
                        QName qName;
                        Serializable value;

                        public PortletEvent(QName qName, Serializable value) {
                            this.qName = qName;
                            this.value = value;
                        }

                        public String getName() {
                            return this.qName.getLocalPart();
                        }

                        public QName getQName() {
                            return this.qName;
                        }

                        public Serializable getValue() {
                            return this.value;
                        }
                    }
                    PortletEvent portletEvent = new PortletEvent(nsEvent.getName(), nsEvent.getPayload());
                    events.add(portletEvent);
                }
            }
            return events;
        }
        catch (Exception e) {
            log.error((Object)("Problem while processesing event for the portlet: " + String.valueOf(uiPortlet.getState())), (Throwable)e);
            return null;
        }
    }

    private static String getPortletModeOrDefault(UpdateNavigationalStateResponse navResponse) {
        Mode mode = navResponse.getMode();
        if (mode == null) {
            mode = Mode.VIEW;
        }
        return mode.toString();
    }

    private static String getWindowStateOrDefault(UpdateNavigationalStateResponse navResponse) {
        org.gatein.pc.api.WindowState state = navResponse.getWindowState();
        if (state == null) {
            state = org.gatein.pc.api.WindowState.NORMAL;
        }
        return state.toString();
    }

    public static void setupPublicRenderParams(UIPortlet uiPortlet, Map<String, String[]> requestParams) {
        if (ParameterValidation.existsAndIsNotEmpty(requestParams)) {
            UIPortal uiPortal = Util.getUIPortal();
            Map<String, String[]> publicParams = uiPortal.getPublicParameters();
            for (String key : requestParams.keySet()) {
                String[] value = requestParams.get(key);
                if (!uiPortlet.supportsPublicParam(key)) continue;
                if (value.length > 0) {
                    publicParams.put(key, value);
                    continue;
                }
                publicParams.remove(key);
            }
        }
    }

    public static class EditPortletActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPortletForm uiPortletForm = uiMaskWS.createUIComponent(UIPortletForm.class, null, null);
            if (!uiPortletForm.setValues(uiPortlet)) {
                uiMaskWS.setUIComponent(null);
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                context.getUIApplication().addMessage(new ApplicationMessage("UIPortlet.message.portletDeleted", null, 0));
            } else {
                uiMaskWS.setUpdated(true);
                uiMaskWS.setWindowSize(800, -1);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            }
        }
    }

    public static class ChangePortletModeActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            String portletMode = null;
            Object changePortletModeAttribute = event.getRequestContext().getAttribute(UIPortletActionListener.CHANGE_PORTLET_MODE_EVENT);
            if (changePortletModeAttribute != null && changePortletModeAttribute instanceof String) {
                portletMode = (String)changePortletModeAttribute;
            }
            if (portletMode == null) {
                portletMode = event.getRequestContext().getRequestParameter("portal:portletMode");
            }
            if (portletMode == null) {
                portletMode = event.getRequestContext().getRequestParameter("objectId");
            }
            if (portletMode == null) {
                portletMode = uiPortlet.getCurrentPortletMode().toString();
            }
            log.trace((Object)("Change portlet mode of " + uiPortlet.getPortletContext().getId() + " to " + portletMode));
            if (portletMode.equals(PortletMode.HELP.toString())) {
                uiPortlet.setCurrentPortletMode(PortletMode.HELP);
            } else if (portletMode.equals(PortletMode.EDIT.toString())) {
                uiPortlet.setCurrentPortletMode(PortletMode.EDIT);
            } else if (portletMode.equals(PortletMode.VIEW.toString())) {
                uiPortlet.setCurrentPortletMode(PortletMode.VIEW);
            } else {
                PortletMode customMode = new PortletMode(portletMode);
                uiPortlet.setCurrentPortletMode(customMode);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortlet);
        }
    }

    public static class ChangeWindowStateActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortlet.getAncestorOfType(UIPortalApplication.class);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.ignoreAJAXUpdateOnPortlets(true);
            String windowState = null;
            Object changeWindowStateAttribute = event.getRequestContext().getAttribute(UIPortletActionListener.CHANGE_WINDOW_STATE_EVENT);
            if (changeWindowStateAttribute != null && changeWindowStateAttribute instanceof String) {
                windowState = (String)changeWindowStateAttribute;
            }
            if (windowState == null) {
                windowState = event.getRequestContext().getRequestParameter("portal:windowState");
            }
            if (windowState == null && event.getRequestContext().getRequestParameter("objectId") != null) {
                windowState = event.getRequestContext().getRequestParameter("objectId").trim();
            }
            if (windowState == null) {
                windowState = uiPortlet.getCurrentWindowState().toString();
            }
            UIPage uiPage = (UIPage)uiPortlet.getAncestorOfType(UIPage.class);
            if (windowState.equals(WindowState.MAXIMIZED.toString())) {
                if (uiPage != null) {
                    uiPage.normalizePortletWindowStates();
                    uiPage.setMaximizedUIPortlet(uiPortlet);
                }
                uiPortlet.setCurrentWindowState(WindowState.MAXIMIZED);
                return;
            }
            if (windowState.equals(WindowState.MINIMIZED.toString())) {
                uiPortlet.setCurrentWindowState(WindowState.MINIMIZED);
            } else {
                uiPortlet.setCurrentWindowState(WindowState.NORMAL);
            }
            if (uiPage != null) {
                UIPortletActionListener.clearMaximizedUIComponent(uiPage, uiPortlet);
            }
        }
    }

    public static class RenderActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            uiPortlet.setNavigationalState(null);
            HttpServletRequest request = (HttpServletRequest)event.getRequestContext().getRequest();
            UIPortletActionListener.setupPublicRenderParams(uiPortlet, request.getParameterMap());
            String navState = event.getRequestContext().getRequestParameter("navigationalstate");
            if (navState != null) {
                uiPortlet.setNavigationalState(ParametersStateString.create((String)navState));
            }
        }
    }

    public static class ProcessEventsActionListener
    extends EventListener<UIPortlet> {
        public void execute(Event<UIPortlet> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            PortalRequestContext context = (PortalRequestContext)event.getRequestContext();
            ArrayList portletInstancesInPage = new ArrayList();
            UIPortalApplication uiPortal = (UIPortalApplication)context.getUIApplication();
            uiPortal.findComponentOfType(portletInstancesInPage, UIPortlet.class);
            EventsWrapper eventsWrapper = (EventsWrapper)event.getRequestContext().getAttribute(UIPortletActionListener.PORTLET_EVENTS);
            List<javax.portlet.Event> events = eventsWrapper.getEvents();
            while (events.size() > 0) {
                javax.portlet.Event nativeEvent = events.remove(0);
                QName eventName = nativeEvent.getQName();
                for (UIPortlet uiPortletInPage : portletInstancesInPage) {
                    if (!uiPortletInPage.supportsProcessingEvent(eventName) || eventsWrapper.isInvokedTooManyTimes(uiPortletInPage)) continue;
                    List<javax.portlet.Event> newEvents = UIPortletActionListener.processEvent(uiPortletInPage, nativeEvent);
                    eventsWrapper.increaseCounter(uiPortletInPage);
                    if (context.useAjax()) {
                        log.info((Object)"Events were generated inside the scope of an AJAX call, hence will only refresh the targeted portlets");
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortletInPage);
                    } else {
                        log.info((Object)"Events were generated outside the scope of an AJAX call, hence will make a full render of the page");
                        context.ignoreAJAXUpdateOnPortlets(true);
                    }
                    if (newEvents == null || newEvents.isEmpty()) continue;
                    log.trace((Object)("The portlet: " + uiPortletInPage.getPortletContext().getId() + " processEvent() method has generated new events itself"));
                    events.addAll(newEvents);
                }
            }
            for (UIPortlet uiPortletInPage : portletInstancesInPage) {
                UIPortletActionListener.setNextState(uiPortletInPage, uiPortletInPage.getCurrentWindowState());
            }
        }
    }

    public static class ServeResourceActionListener<S, C extends Serializable, I>
    extends EventListener<UIPortlet<S, C>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIPortlet<S, C>> event) throws Exception {
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            log.trace((Object)("Serve Resource for portlet: " + String.valueOf(uiPortlet.getPortletContext())));
            String resourceId = null;
            PortalRequestContext context = (PortalRequestContext)event.getRequestContext();
            HttpServletResponse response = context.getResponse();
            try {
                Object content;
                MultiValuedPropertyMap transportHeaders;
                String charset;
                String contentType;
                int statusCode;
                String navState = context.getRequestParameter("navigationalstate");
                if (navState != null) {
                    uiPortlet.setNavigationalState(ParametersStateString.create((String)navState));
                }
                ResourceInvocation resourceInvocation = uiPortlet.create(ResourceInvocation.class, context);
                resourceId = resourceInvocation.getResourceId();
                PortletInvocationResponse portletResponse = uiPortlet.invoke((PortletInvocation)resourceInvocation);
                if (!(portletResponse instanceof ContentResponse)) {
                    if (portletResponse instanceof ErrorResponse) {
                        ErrorResponse errorResponse = (ErrorResponse)portletResponse;
                        Throwable cause = errorResponse.getCause();
                        if (cause != null) {
                            log.trace((Object)"Got error response from portlet", cause);
                        } else if (errorResponse.getMessage() != null) {
                            log.trace((Object)("Got error response from portlet:" + errorResponse.getMessage()));
                        } else {
                            log.trace((Object)"Got error response from portlet");
                        }
                    } else {
                        log.trace((Object)("Unexpected response type [" + String.valueOf(portletResponse) + "]. Expected a ContentResponse or an ErrorResponse."));
                    }
                    statusCode = 500;
                    contentType = null;
                    charset = null;
                    transportHeaders = null;
                    content = null;
                } else {
                    String status;
                    ContentResponse piResponse = (ContentResponse)portletResponse;
                    ResponseProperties properties = piResponse.getProperties();
                    transportHeaders = properties != null ? properties.getTransportHeaders() : null;
                    String string = status = transportHeaders != null ? (String)transportHeaders.getValue("portlet.http-status-code") : null;
                    if (status != null) {
                        try {
                            statusCode = Integer.parseInt(status);
                        }
                        catch (NumberFormatException e) {
                            statusCode = 500;
                        }
                    } else {
                        statusCode = 200;
                    }
                    contentType = piResponse.getContentType();
                    charset = piResponse.getEncoding();
                    log.trace((Object)("Try to get a resource of type: " + contentType + " for the portlet: " + uiPortlet.getId()));
                    content = piResponse.getChars() != null ? piResponse.getChars() : (piResponse.getBytes() != null ? (Object)piResponse.getBytes() : null);
                }
                response.setStatus(statusCode);
                if (contentType != null) {
                    response.setContentType(contentType);
                }
                if (charset != null) {
                    response.setCharacterEncoding(charset);
                }
                if (transportHeaders != null) {
                    this.sendHeaders((MultiValuedPropertyMap<String>)transportHeaders, context);
                }
                if (content instanceof String) {
                    context.getWriter().write((String)content);
                } else if (content instanceof byte[]) {
                    byte[] bytes = (byte[])content;
                    response.setContentLength(bytes.length);
                    ServletOutputStream stream = response.getOutputStream();
                    try {
                        stream.write(bytes);
                    }
                    finally {
                        Safe.close((Closeable)stream);
                    }
                }
                response.flushBuffer();
            }
            catch (NoSuchDataException e) {
                UIPortalApplication uiApp = Util.getUIPortalApplication();
                uiApp.refreshCachedUI();
                response.sendError(500, e.getMessage());
            }
            catch (Exception e) {
                if (!e.getClass().toString().contains("ClientAbortException")) {
                    log.error((Object)("Problem while serving resource " + (resourceId != null ? resourceId : "") + " for the portlet: " + uiPortlet.getPortletContext().getId()), (Throwable)e);
                }
            }
            finally {
                event.getRequestContext().setResponseComplete(true);
            }
        }

        private void sendHeaders(MultiValuedPropertyMap<String> headers, PortalRequestContext context) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : headers.keySet()) {
                for (String value : headers.getValues(key)) {
                    map.put(key, value);
                }
            }
            map.remove("portlet.http-status-code");
            context.setHeaders(map);
        }
    }

    public static class ProcessActionActionListener<S, C extends Serializable, I>
    extends EventListener<UIPortlet<S, C>> {
        public void execute(Event<UIPortlet<S, C>> event) throws Exception {
            ActionInvocation actionInvocation;
            UIPortlet uiPortlet = (UIPortlet)((Object)event.getSource());
            PortalRequestContext prcontext = (PortalRequestContext)event.getRequestContext();
            HttpServletRequest request = prcontext.getRequest();
            UIPortletActionListener.setupPublicRenderParams(uiPortlet, request.getParameterMap());
            String navState = prcontext.getRequestParameter("navigationalstate");
            if (navState != null) {
                uiPortlet.setNavigationalState(ParametersStateString.create((String)navState));
            }
            if ((actionInvocation = uiPortlet.create(ActionInvocation.class, prcontext)) == null) {
                return;
            }
            PortletInvocationResponse portletResponse = uiPortlet.invoke((PortletInvocation)actionInvocation);
            ExoPortletInstanceContext instanceCtx = (ExoPortletInstanceContext)actionInvocation.getInstanceContext();
            if (instanceCtx.getModifiedContext() != null) {
                StatefulPortletContext updatedCtx = (StatefulPortletContext)instanceCtx.getModifiedContext();
                Object portletState = uiPortlet.getModifiedState((PortletContext)updatedCtx);
                uiPortlet.update(portletState);
            } else {
                PortletContext clonedContext = instanceCtx.getClonedContext();
                if (clonedContext != null) {
                    Object state = uiPortlet.getClonedState(clonedContext);
                    uiPortlet.update(state);
                }
            }
            if (portletResponse instanceof UpdateNavigationalStateResponse) {
                this.handleUpdateNavigationalStateResponse((UpdateNavigationalStateResponse)portletResponse, uiPortlet, prcontext);
            } else if (portletResponse instanceof HTTPRedirectionResponse) {
                this.handleRedirectionResponse((HTTPRedirectionResponse)portletResponse, prcontext.getResponse());
                prcontext.setResponseComplete(true);
            } else if (portletResponse instanceof ErrorResponse) {
                this.handleErrorResponse((ErrorResponse)portletResponse);
            } else if (portletResponse instanceof SecurityResponse) {
                this.handleSecurityResponse((SecurityResponse)portletResponse);
            } else {
                throw new Exception("Unexpected response type [" + String.valueOf(portletResponse) + "]. Expected an UpdateNavigationResponse, a HTTPRedirectionResponse or an ErrorResponse.");
            }
        }

        private void handleRedirectionResponse(HTTPRedirectionResponse redirectionResponse, HttpServletResponse response) throws IOException {
            String redirectionURL = redirectionResponse.getLocation();
            response.sendRedirect(redirectionURL);
        }

        private void handleUpdateNavigationalStateResponse(UpdateNavigationalStateResponse navStateResponse, UIPortlet<S, C> uiPortlet, PortalRequestContext prcontext) throws Exception {
            StateString navigationalState;
            if (navStateResponse.getWindowState() != null) {
                WindowState state = new WindowState(UIPortletActionListener.getWindowStateOrDefault(navStateResponse));
                UIPortletActionListener.setNextState(uiPortlet, state);
            }
            if (navStateResponse.getMode() != null) {
                PortletMode mode = new PortletMode(UIPortletActionListener.getPortletModeOrDefault(navStateResponse));
                UIPortletActionListener.setNextMode(uiPortlet, mode);
            }
            if ((navigationalState = navStateResponse.getNavigationalState()) != null) {
                uiPortlet.setNavigationalState(navigationalState);
            }
            UIPortletActionListener.setupPublicRenderParams(uiPortlet, navStateResponse.getPublicNavigationalStateUpdates());
            List nsEvents = navStateResponse.getEvents();
            ArrayList<javax.portlet.Event> events = new ArrayList<javax.portlet.Event>(nsEvents.size());
            if (nsEvents != null && !nsEvents.isEmpty()) {
                for (UpdateNavigationalStateResponse.Event nsEvent : nsEvents) {
                    if (!uiPortlet.supportsPublishingEvent(nsEvent.getName())) continue;
                    class PortletEvent
                    implements javax.portlet.Event {
                        QName qName;
                        Serializable value;

                        public PortletEvent(ProcessActionActionListener this$0, QName qName, Serializable value) {
                            this.qName = qName;
                            this.value = value;
                        }

                        public String getName() {
                            return this.qName.getLocalPart();
                        }

                        public QName getQName() {
                            return this.qName;
                        }

                        public Serializable getValue() {
                            return this.value;
                        }
                    }
                    PortletEvent portletEvent = new PortletEvent(this, nsEvent.getName(), nsEvent.getPayload());
                    events.add(portletEvent);
                }
            }
            if (events != null) {
                prcontext.setAttribute(UIPortletActionListener.PORTLET_EVENTS, new EventsWrapper(events));
                uiPortlet.createEvent("ProcessEvents", Event.Phase.PROCESS, prcontext).broadcast();
            }
        }

        private void handleErrorResponse(ErrorResponse response) throws Exception {
            throw new Exception(response.getCause());
        }

        private void handleSecurityResponse(SecurityResponse response) throws Exception {
            if (response instanceof SecurityErrorResponse) {
                SecurityErrorResponse securityErrorResponse = (SecurityErrorResponse)response;
                throw new Exception("SecurityErrorResponse Returned while trying to process portlet action. ", securityErrorResponse.getThrowable());
            }
            throw new Exception("Security Response of type " + String.valueOf(response.getClass()) + " encountered while trying to process portlet action.");
        }
    }
}

