/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.addons.AddOnService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.webui.container.UIAddOnContainerForm;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.container.UIContainerForm;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(events={@EventConfig(listeners={EditContainerActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.DeleteComponentActionListener.class}, confirm="UIContainer.deleteContainer")})
public class UIAddOnContainer
extends UIContainer {
    public static final String ADDON_CONTAINER = "addonContainer";
    private boolean initialized = false;

    public List<UIComponent> getChildren() {
        if (!this.initialized) {
            AddOnService addonService = (AddOnService)this.getApplicationComponent(AddOnService.class);
            List<Application<Portlet>> apps = addonService.getApplications(this.getName());
            Container model = new Container();
            model.setChildren(new ArrayList<Application<Portlet>>(apps));
            UIContainer tmp = new UIContainer();
            PortalDataMapper.toUIContainer(tmp, model);
            for (UIComponent comp : tmp.getChildren()) {
                comp.setParent((UIComponent)this);
            }
            this.setChildren(tmp.getChildren());
            this.initialized = true;
        }
        return super.getChildren();
    }

    public ModelObject buildModelObject() {
        Container model = new Container(this.getStorageId());
        model.setId(this.getId());
        model.setName(this.getName());
        model.setTitle(this.getTitle());
        model.setIcon(this.getIcon());
        model.setDescription(this.getDescription());
        model.setHeight(this.getHeight());
        model.setWidth(this.getWidth());
        model.setTemplate(this.getTemplate());
        model.setFactoryId(this.getFactoryId());
        model.setAccessPermissions(this.getAccessPermissions());
        return model;
    }

    public static class EditContainerActionListener
    extends EventListener<UIContainer> {
        public void execute(Event<UIContainer> event) throws Exception {
            UIContainer uiContainer = (UIContainer)((Object)event.getSource());
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIContainerForm containerForm = uiMaskWS.createUIComponent(UIAddOnContainerForm.class, "UIContainerForm", "UIContainerForm");
            containerForm.setValues(uiContainer);
            uiMaskWS.setUIComponent((UIComponent)containerForm);
            uiMaskWS.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }
}

