/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.portal.UIPortalLifecycle;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.login.LogoutControl;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIPortalLifecycle.class, template="system:/groovy/portal/webui/portal/UIPortal.gtmpl", events={@EventConfig(listeners={UIPortalComponentActionListener.ChangeApplicationListActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.MoveChildActionListener.class}, csrfCheck=false), @EventConfig(listeners={LogoutActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortalComponentActionListener.ChangeLanguageActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortalComponentActionListener.EditPortalPropertiesActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortalComponentActionListener.ChangeSkinActionListener.class}, csrfCheck=false)})
public class UIPortal
extends UIContainer {
    private SiteKey siteKey;
    private String locale;
    private String label;
    private String editPermission;
    private String skin;
    private Properties properties;
    private Map<String, UIPage> allUiPages = new HashMap<String, UIPage>();
    private Map<String, String[]> publicParameters = new HashMap<String, String[]>();
    private UIComponent maximizedUIComponent;
    private boolean useDynamicLayout;

    public UIPortal() {
        ListenerService listenerService = (ListenerService)ExoContainerContext.getService(ListenerService.class);
        listenerService.addListener(LayoutService.PAGE_UPDATED, (ListenerBase)new RefreshUIPageListener());
    }

    public boolean isUseDynamicLayout() {
        return this.useDynamicLayout;
    }

    public void setUseDynamicLayout(Boolean useDynamicLayout) {
        this.useDynamicLayout = useDynamicLayout;
    }

    public SiteKey getSiteKey() {
        return this.siteKey;
    }

    public void setSiteKey(SiteKey key) {
        this.siteKey = key;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String s) {
        this.locale = s;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String s) {
        this.skin = s;
    }

    @Deprecated
    public String getOwnerType() {
        return this.siteKey.getTypeName();
    }

    public SiteType getSiteType() {
        return this.siteKey.getType();
    }

    public Map<String, String[]> getPublicParameters() {
        return this.publicParameters;
    }

    public void setPublicParameters(Map<String, String[]> publicParams) {
        this.publicParameters = publicParams;
    }

    public UserNode getNavPath() {
        PortalRequestContext prc = PortalRequestContext.getCurrentInstance();
        if (prc.getNavigationNode() == null) {
            this.setNavPath(prc.getUserPortalConfig().getUserPortal().getDefaultPath(null));
        }
        return prc.getNavigationNode();
    }

    public void setNavPath(UserNode nav) {
        PortalRequestContext.getCurrentInstance().setUserNode(nav);
    }

    public UIPage getUIPage(String pageReference) {
        if (this.isDraftPage()) {
            return null;
        }
        return this.allUiPages.get(pageReference);
    }

    public void setUIPage(String pageReference, UIPage uiPage) {
        if (!this.isDraftPage()) {
            this.allUiPages.put(pageReference, uiPage);
        }
    }

    public boolean isDraftPage() {
        return ((PortalRequestContext)RequestContext.getCurrentInstance()).isDraftPage();
    }

    public void clearUIPage(String pageReference) {
        if (this.allUiPages != null) {
            this.allUiPages.remove(pageReference);
        }
    }

    public UserNavigation getUserNavigation() {
        PortalRequestContext prc = Util.getPortalRequestContext();
        return prc.getUserPortalConfig().getUserPortal().getNavigation(this.siteKey);
    }

    public void refreshUIPage() throws Exception {
        UIPageBody uiPageBody = (UIPageBody)this.findFirstComponentOfType(UIPageBody.class);
        if (uiPageBody == null) {
            return;
        }
        uiPageBody.setPageBody(this.getSelectedUserNode(), this);
    }

    public UserNode getSelectedUserNode() {
        return this.getNavPath();
    }

    public UIComponent getMaximizedUIComponent() {
        return this.maximizedUIComponent;
    }

    public void setMaximizedUIComponent(UIComponent maximizedReferenceComponent) {
        this.maximizedUIComponent = maximizedReferenceComponent;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get((Object)name);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void setProperty(String name, String value) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        this.properties.setProperty(name, value);
    }

    public void removeProperty(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.properties.setProperty(name, null);
    }

    public String getSessionAlive() {
        return this.getProperty("sessionAlive", "onDemand");
    }

    public void setSessionAlive(String type) {
        this.setProperty("sessionAlive", type);
    }

    public Boolean isShowInfobar() {
        String value = this.getProperty("showPortletInfo", "1");
        return Integer.parseInt(value) == 1;
    }

    public void setShowInfobar(Boolean value) {
        if (value.booleanValue()) {
            this.setProperty("showPortletInfo", "1");
        } else {
            this.setProperty("showPortletInfo", "0");
        }
    }

    public String getCacheControl() {
        return this.getProperty("cacheControl");
    }

    public void setCacheControl(String cacheControl) {
        this.setProperty("cacheControl", cacheControl);
    }

    public String getViewport() {
        return this.getProperty("viewport");
    }

    public void setViewport(String viewport) {
        this.setProperty("viewport", viewport);
    }

    public String getSharedLayout() {
        return this.getProperty("sharedLayout", "allUsers");
    }

    public void setSharedLayout(String type) {
        if (type.equals("adminsOnly")) {
            this.setProperty("sharedLayout", "adminsOnly");
        } else {
            this.setProperty("sharedLayout", "allUsers");
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getPermissionClasses() {
        StringBuilder permissionClasses = new StringBuilder();
        if (UIPage.isFullPreviewInPageEditor()) {
            permissionClasses.append(" ProtectedContainer");
        }
        if (!this.hasMoveAppsPermission()) {
            permissionClasses.append(" CannotMoveApps");
        }
        if (!this.hasMoveContainersPermission()) {
            permissionClasses.append(" CannotMoveContainers");
        }
        return permissionClasses.toString();
    }

    public void setHeaderAndFooterRendered(boolean headerAndFooterRendered) {
        List list = this.getChildren();
        for (UIComponent child : list) {
            if (child instanceof UIPageBody || child.isRendered() == headerAndFooterRendered) continue;
            child.setRendered(headerAndFooterRendered);
        }
    }

    @Asynchronous
    public class RefreshUIPageListener
    extends Listener<LayoutService, Page> {
        public void onEvent(Event<LayoutService, Page> event) throws Exception {
            Page page = (Page)event.getData();
            if (page == null) {
                return;
            }
            PageKey pageKey = page.getPageKey();
            if (pageKey == null) {
                return;
            }
            String pageReference = pageKey.format();
            if (UIPortal.this.allUiPages != null && UIPortal.this.allUiPages.containsKey(pageReference)) {
                UIPortal.this.allUiPages.remove(pageReference);
            }
        }
    }

    public static class LogoutActionListener
    extends EventListener<UIComponent> {
        public void execute(org.exoplatform.webui.event.Event<UIComponent> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            HttpServletRequest req = prContext.getRequest();
            String token = this.getTokenCookie(req);
            if (token != null) {
                AbstractTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)token);
            }
            LogoutControl.wantLogout();
            Cookie cookie = new Cookie("rememberme", "");
            cookie.setPath(req.getContextPath());
            cookie.setMaxAge(0);
            prContext.getResponse().addCookie(cookie);
            prContext.sendRedirect("/");
        }

        private String getTokenCookie(HttpServletRequest req) {
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!"rememberme".equals(cookie.getName())) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }
    }
}

