/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.operation.global;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.PathTemplateFilter;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.OperationContextDelegate;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.api.operation.QueryOperationHandler;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.management.api.operation.StepResultHandler;
import org.gatein.management.api.operation.model.ExportResourceModel;
import org.gatein.management.api.operation.model.ReadResourceModel;
import org.gatein.management.core.api.operation.BasicResultHandler;

public class ExportResource
extends QueryOperationHandler<ExportResourceModel> {
    public static final ManagedDescription DESCRIPTION = new ManagedDescription(){

        public String getDescription() {
            return "Exports any resources with an export operation handler registered.  This operation is recursive until an operation handler is found.";
        }
    };

    protected ExportResourceModel execute(OperationContext operationContext) throws ResourceNotFoundException, OperationException {
        ManagedResource resource = operationContext.getManagedResource();
        final PathAddress address = operationContext.getAddress();
        final String operationName = operationContext.getOperationName();
        StepResultHandler<ExportResourceModel> exportResultHandler = new StepResultHandler<ExportResourceModel>(address){

            public void failed(String failureDescription) {
                if (address.equals((Object)this.getCurrentAddress())) {
                    throw new OperationException(operationName, "Export operation failed. Reason: " + failureDescription);
                }
                throw new OperationException(operationName, "Export operation failed. Reason: " + failureDescription + " [Step Address: " + this.getCurrentAddress() + "]");
            }
        };
        try {
            this.executeHandlers(resource, operationContext, address, operationName, exportResultHandler);
        }
        catch (OperationException e) {
            throw new OperationException(e.getOperationName(), this.getStepMessage(e, address, exportResultHandler), (Throwable)e);
        }
        catch (Throwable t) {
            throw new OperationException(operationName, this.getStepMessage(t, address, exportResultHandler), t);
        }
        ArrayList tasks = new ArrayList();
        for (ExportResourceModel model : exportResultHandler.getResults()) {
            tasks.addAll(model.getTasks());
        }
        return new ExportResourceModel(tasks);
    }

    private void executeHandlers(ManagedResource resource, OperationContext operationContext, PathAddress address, String operationName, StepResultHandler<ExportResourceModel> stepResultHandler) {
        OperationHandler handler = resource.getOperationHandler(address, operationName);
        if (handler != null && handler != this) {
            PathTemplateFilter filter;
            List filterAttributes = operationContext.getAttributes().getValues("filter");
            try {
                filter = PathTemplateFilter.parse((List)filterAttributes);
            }
            catch (ParseException e) {
                throw new OperationException(operationName, "Could not parse filter attributes.", (Throwable)e);
            }
            if (address.accepts(filter)) {
                handler.execute(operationContext, stepResultHandler);
            }
        } else {
            ManagedResource found = resource.getSubResource(address);
            if (found == null) {
                throw new OperationException(operationName, "Could not locate resource at address " + address);
            }
            OperationHandler readResource = resource.getOperationHandler(address, "read-resource");
            BasicResultHandler readResourceResult = new BasicResultHandler();
            readResource.execute(operationContext, (ResultHandler)readResourceResult);
            if (readResourceResult.getFailureDescription() != null) {
                throw new OperationException(operationName, "Failure '" + readResourceResult.getFailureDescription() + "' encountered executing " + "read-resource");
            }
            Object model = readResourceResult.getResult();
            if (!(model instanceof ReadResourceModel)) {
                throw new RuntimeException("Was expecting " + ReadResourceModel.class + " to be returned for operation " + "read-resource" + " at address " + address);
            }
            for (String child : ((ReadResourceModel)model).getChildren()) {
                final PathAddress childAddress = address.append(child);
                OperationContextDelegate childContext = new OperationContextDelegate(operationContext){

                    public PathAddress getAddress() {
                        return childAddress;
                    }
                };
                this.executeHandlers(resource, (OperationContext)childContext, childAddress, operationName, (StepResultHandler<ExportResourceModel>)stepResultHandler.next(childAddress));
            }
        }
    }

    private String getStepMessage(Throwable t, PathAddress originalAddress, StepResultHandler<ExportResourceModel> stepResultHandler) {
        String message;
        String string = message = t.getMessage() == null ? "Step operation failure" : t.getMessage();
        if (originalAddress.equals((Object)stepResultHandler.getCurrentAddress())) {
            return message;
        }
        return message + " [Step Address: " + stepResultHandler.getCurrentAddress() + "]";
    }
}

