/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.util.Assert;

public abstract class RepresentationModelAssemblerSupport<T, D extends RepresentationModel<?>>
implements RepresentationModelAssembler<T, D> {
    private final Class<?> controllerClass;
    private final Class<D> resourceType;

    public RepresentationModelAssemblerSupport(Class<?> controllerClass, Class<D> resourceType) {
        Assert.notNull(controllerClass, (String)"ControllerClass must not be null!");
        Assert.notNull(resourceType, (String)"ResourceType must not be null!");
        this.controllerClass = controllerClass;
        this.resourceType = resourceType;
    }

    @Override
    public CollectionModel<D> toCollectionModel(Iterable<? extends T> entities) {
        return this.map(entities).toResources();
    }

    public Builder<T, D> map(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        return new Builder(entities, this);
    }

    protected D createModelWithId(Object id, T entity) {
        return this.createModelWithId(id, entity, new Object[0]);
    }

    protected D createModelWithId(Object id, T entity, Object ... parameters) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        Assert.notNull((Object)id, (String)"Id must not be null!");
        D instance = this.instantiateModel(entity);
        ((RepresentationModel)instance).add(((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(this.controllerClass, parameters).slash(id)).withSelfRel());
        return instance;
    }

    protected Class<?> getControllerClass() {
        return this.controllerClass;
    }

    protected Class<D> getResourceType() {
        return this.resourceType;
    }

    protected D instantiateModel(T entity) {
        return (D)((RepresentationModel)BeanUtils.instantiateClass(this.resourceType));
    }

    static class Builder<T, D extends RepresentationModel<?>> {
        private final Iterable<? extends T> entities;
        private final RepresentationModelAssemblerSupport<T, D> resourceAssembler;

        Builder(Iterable<? extends T> entities, RepresentationModelAssemblerSupport<T, D> resourceAssembler) {
            this.entities = Objects.requireNonNull(entities, "entities must not null!");
            this.resourceAssembler = resourceAssembler;
        }

        public List<D> toListOfResources() {
            ArrayList result = new ArrayList();
            for (T entity : this.entities) {
                result.add(this.resourceAssembler.toModel(entity));
            }
            return result;
        }

        public CollectionModel<D> toResources() {
            return CollectionModel.of(this.toListOfResources());
        }
    }
}

