/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.authentication;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.gatein.wci.authentication.AuthenticationEventType;
import org.gatein.wci.security.Credentials;
import org.gatein.wci.spi.ServletContainerContext;

public class AuthenticationEvent {
    private final AuthenticationEventType type;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final String userName;
    private final Credentials credentials;
    private final ServletContainerContext containerContext;

    public AuthenticationEvent(AuthenticationEventType type, HttpServletRequest request, HttpServletResponse response, String userName, Credentials credentials, ServletContainerContext containerContext) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (containerContext == null) {
            throw new IllegalArgumentException("container is null");
        }
        this.type = type;
        this.request = request;
        this.response = response;
        this.userName = userName;
        this.credentials = credentials;
        this.containerContext = containerContext;
    }

    public AuthenticationEventType getType() {
        return this.type;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getUserName() {
        return this.userName;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public ServletContainerContext getContainerContext() {
        return this.containerContext;
    }

    public String toString() {
        return "AuthenticationEvent[type=" + this.type.name() + ",userName=" + this.userName + ",uri=" + this.request.getRequestURI() + "]";
    }
}

