/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.link.plugin;

import io.meeds.social.link.model.LinkSetting;
import io.meeds.social.link.service.LinkService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;

public class LinkSettingTranslationPlugin
extends TranslationPlugin {
    public static final String LINK_SETTINGS_OBJECT_TYPE = "link-settings";
    private static final Log LOG = ExoLogger.getLogger(LinkSettingTranslationPlugin.class);
    private LinkService linkService;
    private IdentityRegistry identityRegistry;
    private OrganizationService organizationService;

    public LinkSettingTranslationPlugin(LinkService linkService, IdentityRegistry identityRegistry, OrganizationService organizationService) {
        this.linkService = linkService;
        this.identityRegistry = identityRegistry;
        this.organizationService = organizationService;
    }

    public String getObjectType() {
        return LINK_SETTINGS_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(long linkSettingId, String username) throws ObjectNotFoundException {
        try {
            LinkSetting linkSetting = this.linkService.getLinkSetting(linkSettingId);
            return linkSetting != null && this.linkService.hasAccessPermission(linkSetting.getName(), this.getIdentity(username));
        }
        catch (Exception e) {
            LOG.warn("Error checking access permission on link setting with id {} for user {}", new Object[]{linkSettingId, username, e});
            return false;
        }
    }

    public boolean hasEditPermission(long linkSettingId, String username) throws ObjectNotFoundException {
        try {
            LinkSetting linkSetting = this.linkService.getLinkSetting(linkSettingId);
            return linkSetting != null && this.linkService.hasEditPermission(linkSetting.getName(), this.getIdentity(username));
        }
        catch (Exception e) {
            LOG.warn("Error checking edit permission on link setting with id {} for user {}", new Object[]{linkSettingId, username, e});
            return false;
        }
    }

    public long getAudienceId(long objectId) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(long objectId) throws ObjectNotFoundException {
        return 0L;
    }

    private Identity getIdentity(String username) throws Exception {
        if (StringUtils.isBlank((CharSequence)username)) {
            return null;
        }
        Identity aclIdentity = this.identityRegistry.getIdentity(username);
        if (aclIdentity == null) {
            List<MembershipEntry> entries = this.organizationService.getMembershipHandler().findMembershipsByUser(username).stream().map(membership -> new MembershipEntry(membership.getGroupId(), membership.getMembershipType())).toList();
            aclIdentity = new Identity(username, entries);
            this.identityRegistry.register(aclIdentity);
        }
        return aclIdentity;
    }
}

